/*
 * Decompiled with CFR 0.152.
 */
package Sav.Server.Outfit;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HPage {
    static Properties prop = new Properties();
    static final String nl;
    PrintWriter pw;
    String title = "Message";
    String author = "StripServer";
    Vector messages = new Vector();
    boolean messageBreak = true;

    public HPage(PrintWriter printWriter) throws IOException {
        this.pw = printWriter;
    }

    public PrintWriter writer() {
        return this.pw;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void addMessage(String string) {
        this.messages.addElement(string);
    }

    public void addMessages(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.messages.addElement(stringArray[i]);
        }
    }

    public void setBreak(boolean bl) {
        this.messageBreak = bl;
    }

    public void show() throws IOException {
        this.open();
        this.writeMessages();
        this.close();
    }

    public void open() throws IOException {
        this.pw.println("<HTML>");
        this.writeHead();
        this.pw.println("<BODY>");
    }

    public void close() throws IOException {
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void writeHead() {
        if (this.title == null && this.author == null) {
            return;
        }
        this.pw.println("<HEAD>");
        if (this.title != null) {
            this.pw.println(String.valueOf(String.valueOf(new StringBuffer(" <TITLE>").append(this.title).append("</TITLE>"))));
        }
        if (this.author != null) {
            this.pw.println(String.valueOf(String.valueOf(new StringBuffer(" <META NAME='Author' CONTENT='").append(this.author).append("'>"))));
        }
        this.pw.println("</HEAD>");
    }

    public void writeMessages() throws IOException {
        int n = this.messages.size();
        for (int i = 0; i < n; ++i) {
            this.writeMessage(i);
        }
    }

    public void writeMessage(int n) throws IOException {
        String string = (String)this.messages.elementAt(n);
        this.writeMessage(string);
    }

    public void writeMessage(String string) throws IOException {
        this.pw.println(string);
        if (this.messageBreak) {
            this.pw.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(nl))).append("<BR>").append(nl))));
        }
    }

    public void write(String string) throws IOException {
        this.pw.println(string);
    }

    public void showFile(String string) throws IOException {
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        int n = (int)file.length();
        char[] cArray = new char[n];
        if (fileReader.read(cArray, 0, n) > 0) {
            this.pw.write(cArray);
        }
        fileReader.close();
        this.pw.close();
    }

    public static String toHTML(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] > '>' || cArray[i] < '\"') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '>') {
                stringBuffer.append("&#062;");
                continue;
            }
            if (cArray[i] == '<') {
                stringBuffer.append("&#060;");
                continue;
            }
            if (cArray[i] == '\'') {
                stringBuffer.append("&#039;");
                continue;
            }
            if (cArray[i] == '&') {
                stringBuffer.append("&#038;");
                continue;
            }
            if (cArray[i] == '\"') {
                stringBuffer.append("&#034;");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String fromHTML(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            char c;
            cArray[n5] = c = string.charAt(n4);
            if (c == '&') {
                n2 = n4;
                n3 = n5;
            } else if (n2 > 0) {
                if (c == ';') {
                    String string2 = string.substring(n2 + 1, n4);
                    n2 = -1;
                    int n6 = 10;
                    String string3 = null;
                    if (string2.charAt(0) == '#') {
                        string3 = string2.substring(1);
                        if (string3.charAt(0) == 'x' || string3.charAt(0) == 'X') {
                            string3 = string3.substring(1);
                            n6 = 16;
                        }
                    } else {
                        string3 = prop.getProperty(string2);
                        if (string3 != null) {
                            string3 = string3.substring(2);
                            n6 = 16;
                        }
                    }
                    n5 = n3;
                    cArray[n5] = (char)Integer.parseInt(string3, n6);
                } else if (n4 - n2 == 7) {
                    n2 = -1;
                }
            }
            ++n4;
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    public static String toRequest(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (cArray[i] < '@') {
                stringBuffer.append('%');
                char c = Character.forDigit(cArray[i] >> 4 & 0xF, 16);
                stringBuffer.append(c);
                c = Character.forDigit(cArray[i] & 0xF, 16);
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String paramTable(HttpServletRequest httpServletRequest) throws IOException {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return HPage.paramTable(httpServletRequest, stringArray);
    }

    public static String paramTable(HttpServletRequest httpServletRequest, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TABLE>".concat(String.valueOf(String.valueOf(nl))));
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("<TR>".concat(String.valueOf(String.valueOf(nl))));
            stringBuffer.append("  <TD>");
            stringBuffer.append(HPage.toHTML(stringArray[i]));
            stringBuffer.append(":</TD>".concat(String.valueOf(String.valueOf(nl))));
            stringBuffer.append("  <TD>");
            String[] stringArray2 = httpServletRequest.getParameterValues(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(HPage.toHTML(stringArray2[j]));
            }
            stringBuffer.append("</TD></TR>".concat(String.valueOf(String.valueOf(nl))));
        }
        stringBuffer.append("</TABLE>".concat(String.valueOf(String.valueOf(nl))));
        return stringBuffer.toString();
    }

    public void writeList(String string, Vector vector, int n) {
        String string2 = HPage.list(string, vector, n, false);
        this.pw.println(string2);
    }

    public void writeList(String string, Vector vector, int n, boolean bl) {
        String string2 = HPage.list(string, vector, n, bl);
        this.pw.println(string2);
    }

    public static String list(String string, Vector vector, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SELECT NAME='");
        stringBuffer.append(HPage.toHTML(string));
        stringBuffer.append("'");
        if (n > 0) {
            stringBuffer.append(" SIZE=".concat(String.valueOf(String.valueOf(n))));
        }
        if (bl) {
            stringBuffer.append(" MULTIPLE>".concat(String.valueOf(String.valueOf(nl))));
        } else {
            stringBuffer.append(">".concat(String.valueOf(String.valueOf(nl))));
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                stringBuffer.append("<OPTION>");
                stringBuffer.append(HPage.toHTML(string2));
                stringBuffer.append("</OPTION>".concat(String.valueOf(String.valueOf(nl))));
            }
        }
        stringBuffer.append("</SELECT>".concat(String.valueOf(String.valueOf(nl))));
        return stringBuffer.toString();
    }

    public void writeLink(String string, String string2) {
        String string3 = HPage.link(string, string2);
        this.pw.println(string3);
    }

    public void writeLink(String string, String string2, String string3) {
        String string4 = HPage.link(string, string2, string3);
        this.pw.println(string4);
    }

    static String link(String string, String string2) {
        String string3 = null;
        if (string.startsWith("http://")) {
            string3 = string;
        } else if (string.startsWith("\"http://")) {
            string3 = string.substring(1, string.length() - 1);
        } else if (string.startsWith("'http://")) {
            string3 = string.substring(1, string.length() - 1);
        }
        return HPage.link(string, string3, string2);
    }

    public static String link(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("<A HREF='").append(string2).append("'"))));
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        }
        stringBuffer.append("> ");
        stringBuffer.append(HPage.toHTML(string));
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public void writeLinks(Vector vector, String string, String string2) {
        String string3 = HPage.links(vector, string, string2);
        this.pw.println(string3);
    }

    public static String links(Vector vector, String string, String string2) {
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string;
        for (int i = 0; i < n; ++i) {
            String string4 = (String)vector.elementAt(i);
            if (string.endsWith("=")) {
                string3 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string4)));
            }
            String string5 = HPage.link(string4, string3, string2);
            stringBuffer.append(string5);
            stringBuffer.append("<BR>".concat(String.valueOf(String.valueOf(nl))));
        }
        return stringBuffer.toString();
    }

    static {
        ((Hashtable)prop).put("quot", "22");
        ((Hashtable)prop).put("amp", "26");
        ((Hashtable)prop).put("lt", "3C");
        ((Hashtable)prop).put("gt", "3E");
        ((Hashtable)prop).put("nbsp", "20");
        nl = System.getProperty("line.separator");
    }
}

