/*
 * Decompiled with CFR 0.152.
 */
package Sav.Server.Outfit;

import Sav.Processor.Concept;
import Sav.TParser.Fielder;
import Sav.Z.Warning;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HPage {
    PrintWriter pw;
    String title = "Message";
    String author = "Sav Z Server";

    static void writeList(PrintWriter printWriter, String string, String string2, int n) {
        String string3;
        Vector<String> vector = null;
        if (string2 != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (Concept.isSpecific((String)string3)) continue;
                vector.addElement(string3);
            }
            if (n == 0) {
                n = vector.size();
            }
        } else {
            n = 0;
        }
        printWriter.print("<SELECT NAME='");
        printWriter.print(HPage.toHTML(string));
        if (n <= 0) {
            printWriter.println("' MULTIPLE>");
        } else {
            printWriter.println(String.valueOf(String.valueOf(new StringBuffer("' SIZE=").append(n).append(" MULTIPLE>"))));
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                string3 = (String)vector.elementAt(i);
                printWriter.print("<OPTION>");
                printWriter.print(HPage.toHTML(string3));
                printWriter.println("</OPTION>");
            }
        }
        printWriter.println("</SELECT>");
    }

    static void warn(PrintWriter printWriter, Warning[] warningArray) {
        int n = warningArray.length;
        for (int i = 0; i < n; ++i) {
            Warning warning = warningArray[i];
            printWriter.println(warning);
            printWriter.println("<BR>");
        }
    }

    public HPage(PrintWriter printWriter) throws IOException {
        this.pw = printWriter;
    }

    public HPage(PrintWriter printWriter, String string) throws IOException {
        this.pw = printWriter;
        this.title = string;
    }

    public HPage(PrintWriter printWriter, String string, String string2) throws IOException {
        this.pw = printWriter;
        this.title = string;
        this.author = string2;
    }

    public PrintWriter writer() {
        return this.pw;
    }

    public void showString(String string) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println("<HEAD>");
        this.pw.println(" <TITLE>Message</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server'>");
        this.pw.println("</HEAD>");
        this.pw.println("<BODY>");
        this.pw.println(HPage.toHTML(string, true));
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void showStrings(String[] stringArray) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println("<HEAD>");
        this.pw.println(" <TITLE>Message</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server'>");
        this.pw.println("</HEAD>");
        this.pw.println("<BODY>");
        for (int i = 0; i < stringArray.length; ++i) {
            this.pw.println(HPage.toHTML(stringArray[i], true));
        }
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void showPage(String string) throws IOException {
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        int n = (int)file.length();
        char[] cArray = new char[n];
        if (fileReader.read(cArray, 0, n) > 0) {
            this.pw.write(cArray);
        }
        fileReader.close();
        this.pw.close();
    }

    public void showRow(String[] stringArray, String[] stringArray2) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println("<HEAD>");
        this.pw.println(" <TITLE>Row</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server' />");
        this.pw.println("</HEAD>");
        this.pw.println("<BODY>");
        this.pw.println("<TABLE>");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.pw.println("<TR ALIGN=LEFT>");
            this.pw.print("  <TD>");
            this.pw.print(HPage.toHTML(stringArray[i]));
            this.pw.println(":</TD>");
            this.pw.print("  <TD>");
            this.pw.print(HPage.toHTML(stringArray2[i]));
            this.pw.println("</TD></TR>");
        }
        this.pw.println("</TABLE>");
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void showParameters(HttpServletRequest httpServletRequest, String[] stringArray) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println(" <TITLE>Request Parameters</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server' />");
        this.pw.println("<BODY>");
        this.pw.println("<TABLE>");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.pw.println("<TR>");
            this.pw.print("  <TD>");
            this.pw.print(HPage.toHTML(stringArray[i]));
            this.pw.println(":</TD>");
            this.pw.print("  <TD>");
            String[] stringArray2 = httpServletRequest.getParameterValues(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (j > 0) {
                    this.pw.print(", ");
                }
                this.pw.print(HPage.toHTML(stringArray2[j]));
            }
            this.pw.println("</TD></TR>");
        }
        this.pw.println("</TABLE>");
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void showTable(RandomAccessFile randomAccessFile, String[] stringArray) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println(" <TITLE>Table</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server' />");
        this.pw.println("<BODY>");
        this.pw.println("<TABLE RULES=ALL BORDER=1>");
        int n = stringArray.length;
        randomAccessFile.seek(0L);
        String string = randomAccessFile.readLine();
        while (string != null) {
            this.pw.println("<TR>");
            Fielder fielder = new Fielder(string, ';');
            while (fielder.hasNext()) {
                this.pw.print("  <TD>");
                String string2 = fielder.nextField();
                this.pw.print(HPage.toHTML(string2));
                this.pw.println("</TD>");
            }
            this.pw.println("</TR>");
            string = randomAccessFile.readLine();
        }
        this.pw.println("</TABLE>");
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void showErrors(String string) throws IOException {
        this.pw.println("<HTML>");
        this.pw.println(" <TITLE>Errors</TITLE>");
        this.pw.println(" <META NAME='Author' CONTENT='Sav Z Server' />");
        this.pw.println("<BODY>");
        this.pw.print("Error parameters: ".concat(String.valueOf(String.valueOf(HPage.toHTML(string, true)))));
        this.pw.println("<BR>");
        this.pw.println("Possible causes:<BR>");
        this.pw.println("web browser < 4.0<BR>");
        this.pw.println("other ...<BR>");
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public void setTitle(String string) throws IOException {
        this.title = string;
    }

    public void setAuthor(String string) throws IOException {
        this.author = this.author;
    }

    public void open() throws IOException {
        this.pw.println("<HTML>");
        this.pw.println("<HEAD>");
        this.pw.println(String.valueOf(String.valueOf(new StringBuffer(" <TITLE>").append(this.title).append("</TITLE>"))));
        this.pw.println(String.valueOf(String.valueOf(new StringBuffer(" <META name='Author' content='").append(this.author).append("'>"))));
        this.pw.println("</HEAD>");
        this.pw.println("<BODY>");
    }

    public void close() throws IOException {
        this.pw.println("</BODY>");
        this.pw.println("</HTML>");
        this.pw.close();
    }

    public static String toHTMLLink(String string) {
        String string2 = null;
        if (string.startsWith("http://")) {
            string2 = string;
        } else if (string.startsWith("\"http://")) {
            string2 = string.substring(1, string.length() - 1);
        } else if (string.startsWith("'http://")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (string2 == null) {
            return HPage.toHTML(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<A HREF='".concat(String.valueOf(String.valueOf(string2))));
        stringBuffer.append("' TARGET='_blank'");
        stringBuffer.append("> ");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public static String toRequest(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (cArray[i] < '@') {
                stringBuffer.append('%');
                char c = Character.forDigit(cArray[i] >> 4 & 0xF, 16);
                stringBuffer.append(c);
                c = Character.forDigit(cArray[i] & 0xF, 16);
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String toHTML(String string) {
        return HPage.toHTML(string, false);
    }

    public static String toHTML(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                stringBuffer.append(cArray[i]);
                if (!bl) continue;
                stringBuffer.append("<BR />");
                continue;
            }
            if (cArray[i] > '>' || cArray[i] < '\"') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '>') {
                stringBuffer.append("&#062;");
                continue;
            }
            if (cArray[i] == '<') {
                stringBuffer.append("&#060;");
                continue;
            }
            if (cArray[i] == '\'') {
                stringBuffer.append("&#039;");
                continue;
            }
            if (cArray[i] == '&') {
                stringBuffer.append("&#038;");
                continue;
            }
            if (cArray[i] == '\"') {
                stringBuffer.append("&#034;");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String fromHTML(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (c == '&' && string.charAt(i + 1) == '#') {
                cArray[n2++] = (char)Integer.parseInt(string.substring(i += 2, i + 3));
                i += 4;
                continue;
            }
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }
}

