/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import org.nakedobjects.basicgui.view.AssociationViewer;
import org.nakedobjects.basicgui.view.Cell;
import org.nakedobjects.basicgui.view.ClassListViewer;
import org.nakedobjects.basicgui.view.ClearBackground;
import org.nakedobjects.basicgui.view.CollectionViewer;
import org.nakedobjects.basicgui.view.DeleteAttributeOption;
import org.nakedobjects.basicgui.view.DeleteElementOption;
import org.nakedobjects.basicgui.view.DestroyInstanceOption;
import org.nakedobjects.basicgui.view.DestroyObjectInAttributeOption;
import org.nakedobjects.basicgui.view.DestroyObjectInCollectionOption;
import org.nakedobjects.basicgui.view.DestroyObjectOption;
import org.nakedobjects.basicgui.view.FieldIcon;
import org.nakedobjects.basicgui.view.Form;
import org.nakedobjects.basicgui.view.FormBorder;
import org.nakedobjects.basicgui.view.Icon;
import org.nakedobjects.basicgui.view.InternalListBorder;
import org.nakedobjects.basicgui.view.ObjectList;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.RealObjectViewer;
import org.nakedobjects.basicgui.view.StackLayout;
import org.nakedobjects.basicgui.view.Table;
import org.nakedobjects.basicgui.view.TableLayout;
import org.nakedobjects.basicgui.view.TableRow;
import org.nakedobjects.basicgui.view.Text;
import org.nakedobjects.basicgui.view.View;
import org.nakedobjects.basicgui.view.ViewBackground;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewerFactory;
import org.nakedobjects.basicgui.view.border.CompoundBorder;
import org.nakedobjects.basicgui.view.border.EmptyBorder;
import org.nakedobjects.basicgui.view.border.InternalIconBorder;
import org.nakedobjects.basicgui.view.border.RowBorder;
import org.nakedobjects.basicgui.view.border.TableBorder;
import org.nakedobjects.basicgui.view.border.WindowIconBorder;
import org.nakedobjects.object.NakedClassList;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.collection.TypedCollection;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.OneToManyAssociation;

public class StandardViewerFactory
extends ViewerFactory {
    private static StackLayout listLayout = new StackLayout(0, 0);
    public static final ViewBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
    public static final ViewBackground clearBackground = new ClearBackground();
    public static final View icon = new Icon();
    public static final View smallIcon = new FieldIcon();
    public static final View text = new Text();
    private static final ViewBorder topFormBorder = new WindowIconBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new FormBorder()));
    private static final ViewBorder internalFormBorder = new InternalIconBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new FormBorder()));
    public static final View topForm = new Form(topFormBorder);
    public static final View form = new Form(internalFormBorder);
    private static final ViewBorder topListBorder = new WindowIconBorder();
    private static final ViewBorder internalListBorder = new InternalListBorder();
    public static final View topList = new ObjectList(clearBackground, null, topListBorder, listLayout);
    public static final View list = new ObjectList(clearBackground, null, internalListBorder, listLayout);
    private static final View cell = new Cell();
    private static final RowBorder rowBorder = new RowBorder(false);
    private static final ViewBorder topTableBorder = new WindowIconBorder(new TableBorder());
    private static final ViewBorder internalTableBorder = new TableBorder();

    public ObjectViewer createCollectionAttributeViewer(NakedObject nakedObject, OneToManyAssociation oneToManyAssociation) {
        AssociationViewer associationViewer = new AssociationViewer(nakedObject, oneToManyAssociation, smallIcon, list);
        NakedObject nakedObject2 = (NakedObject)oneToManyAssociation.get(nakedObject);
        if (nakedObject2 instanceof TypedCollection && ((TypedCollection)nakedObject2).getType() != null) {
            associationViewer.addView(this.internalTable());
        }
        associationViewer.addOption(new DestroyObjectInAttributeOption());
        associationViewer.addOption(new DeleteAttributeOption());
        return associationViewer;
    }

    public ObjectViewer createCollectionElementViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, smallIcon, list);
        if (nakedObject instanceof TypedCollection && ((TypedCollection)nakedObject).getType() != null) {
            realObjectViewer.addView(this.internalTable());
        }
        realObjectViewer.addOption(new DestroyObjectInCollectionOption());
        realObjectViewer.addOption(new DeleteElementOption());
        return realObjectViewer;
    }

    public ObjectViewer createCollectionViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer;
        if (nakedObject instanceof NakedClassList) {
            realObjectViewer = new ClassListViewer(nakedObject, icon, topList);
        } else {
            realObjectViewer = new RealObjectViewer(nakedObject, icon, topList);
            if (nakedObject instanceof TypedCollection && ((TypedCollection)nakedObject).getType() != null) {
                realObjectViewer.addView(this.topTable());
            }
        }
        realObjectViewer.useView(1);
        return realObjectViewer;
    }

    public ObjectViewer createElementViewer(NakedObject nakedObject) {
        if (nakedObject instanceof NakedCollection) {
            return this.createCollectionElementViewer(nakedObject);
        }
        return this.createObjectElementViewer(nakedObject);
    }

    public ObjectViewer createInternalCollectionAttributeViewer(NakedObject nakedObject, OneToManyAssociation oneToManyAssociation) {
        CollectionViewer collectionViewer = new CollectionViewer(nakedObject, oneToManyAssociation, new ObjectList(null, null, internalListBorder, listLayout));
        NakedObject nakedObject2 = (NakedObject)oneToManyAssociation.get(nakedObject);
        if (nakedObject2 instanceof InternalCollection && ((InternalCollection)nakedObject2).getType() != null) {
            collectionViewer.addView(this.internalTable());
        }
        return collectionViewer;
    }

    public ObjectViewer createObjectAttributeViewer(NakedObject nakedObject, Association association) {
        AssociationViewer associationViewer = new AssociationViewer(nakedObject, association, smallIcon, form);
        associationViewer.addView(text);
        associationViewer.addOption(new DestroyObjectInAttributeOption());
        associationViewer.addOption(new DeleteAttributeOption());
        return associationViewer;
    }

    public ObjectViewer createObjectCellViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, cell);
        return realObjectViewer;
    }

    public ObjectViewer createObjectElementViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, smallIcon, form);
        realObjectViewer.addView(text);
        realObjectViewer.addOption(new DestroyObjectInCollectionOption());
        realObjectViewer.addOption(new DeleteElementOption());
        return realObjectViewer;
    }

    public ObjectViewer createInstanceElementViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, smallIcon, form);
        realObjectViewer.addView(text);
        realObjectViewer.addOption(new DestroyInstanceOption());
        return realObjectViewer;
    }

    public ObjectViewer createObjectRowViewer(NakedObject nakedObject, TableLayout tableLayout) {
        TableRow tableRow = new TableRow(rowBorder, tableLayout);
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, (View)tableRow);
        realObjectViewer.addOption(new DestroyObjectInAttributeOption());
        realObjectViewer.addOption(new DeleteElementOption());
        return realObjectViewer;
    }

    public ObjectViewer createObjectViewer(NakedObject nakedObject) {
        RealObjectViewer realObjectViewer = new RealObjectViewer(nakedObject, icon, topForm);
        realObjectViewer.addView(text);
        realObjectViewer.useView(1);
        realObjectViewer.addOption(new DestroyObjectOption());
        return realObjectViewer;
    }

    private Table internalTable() {
        return new Table(internalTableBorder, new TableLayout(rowBorder, 4, 0));
    }

    private Table topTable() {
        return new Table(topTableBorder, new TableLayout(rowBorder, 4, 0));
    }
}

