/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class CPanel
extends Panel {
    Vector vPanels;
    protected int curIndex = -1;
    private Component userPanel = null;
    private transient int osAdjustment;
    private int lastWidth = -1;

    public CPanel() {
        super.setLayout(null);
        this.vPanels = new Vector();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setCurrent(int n) {
        if (n == this.curIndex) {
            return;
        }
        this.curIndex = n;
    }

    public int setIndex() {
        int n = this.vPanels.size() - 1;
        if (this.curIndex == -1) {
            this.setCurrent(n);
        }
        return n;
    }

    public int addPanel(Component component) {
        this.vPanels.addElement(component);
        return this.setIndex();
    }

    public synchronized Component add(Component component) {
        int n = this.addPanel(component);
        if (n == this.curIndex) {
            this.select(n);
        }
        this.repaint();
        return component;
    }

    public synchronized int getPanelIndex(Component component) {
        return this.vPanels.indexOf(component);
    }

    public void setPanel(int n) {
        if (n == this.curIndex) {
            return;
        }
        this.select(n);
    }

    public void first() {
        this.select(0);
    }

    public void last() {
        this.select(this.vPanels.size() - 1);
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        Component component = (Component)this.vPanels.elementAt(n);
        this.setCurrent(n);
        this.showPanel(component);
    }

    public void showPanel(Component component) {
        if (this.userPanel != null) {
            this.userPanel.setVisible(false);
        }
        this.userPanel = component;
        if (this.userPanel != null) {
            int n;
            Component[] componentArray = this.getComponents();
            int n2 = componentArray.length;
            for (n = 0; n < n2 && componentArray[n] != this.userPanel; ++n) {
            }
            if (n == n2) {
                super.add(this.userPanel, -1);
            }
            this.curIndex = n;
            this.userPanel.setVisible(true);
            this.userPanel.requestFocus();
            this.validate();
            this.repaint();
        }
    }

    public synchronized Component getTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return null;
        }
        Component component = (Component)this.vPanels.elementAt(n);
        return component;
    }

    public void doLayout() {
        Rectangle rectangle = this.getBounds();
        if (this.userPanel != null) {
            this.userPanel.setBounds(0, 0, rectangle.width, rectangle.height);
            this.userPanel.invalidate();
            this.userPanel.validate();
            this.userPanel.repaint();
            this.repaint();
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void addNotify() {
        super.addNotify();
    }

    public synchronized void removeNotify() {
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }
}

