/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    Segment text = new Segment();
    short offset = 0;
    short length = 0;
    TabExpander expander;
    int x;
    GlyphPainter painter;
    static GlyphPainter defaultPainter;

    public GlyphView(Element element) {
        super(element);
    }

    protected final Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }

    public GlyphPainter getGlyphPainter() {
        return this.painter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.painter = glyphPainter;
    }

    public Segment getText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.text);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("GlyphView: Stale view: " + badLocationException);
        }
        return this.text;
    }

    public Color getBackground() {
        AttributeSet attributeSet;
        Document document = this.getDocument();
        if (document instanceof StyledDocument && (attributeSet = this.getAttributes()).isDefined(StyleConstants.Background)) {
            return ((StyledDocument)document).getBackground(attributeSet);
        }
        return null;
    }

    public Color getForeground() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getForeground(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public Font getFont() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getFont(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public boolean isUnderline() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    public boolean isStrikeThrough() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public TabExpander getTabExpander() {
        return this.expander;
    }

    protected void checkPainter() {
        if (this.painter == null) {
            if (defaultPainter == null) {
                String string = "javax.swing.text.GlyphPainter1";
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    Object object = clazz.newInstance();
                    if (object instanceof GlyphPainter) {
                        defaultPainter = (GlyphPainter)object;
                    }
                }
                catch (Throwable throwable) {
                    throw new StateInvariantError("GlyphView: Can't load glyph painter: " + string);
                }
            }
            this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
        }
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.checkPainter();
        this.expander = tabExpander;
        this.x = (int)f;
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        float f2 = this.painter.getSpan(this, n, n2, this.expander, f);
        return f2;
    }

    public float getPartialSpan(int n, int n2) {
        this.checkPainter();
        float f = this.painter.getSpan(this, n, n2, this.expander, this.x);
        return f;
    }

    public int getStartOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset : element.getStartOffset();
    }

    public int getEndOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset + this.length : element.getEndOffset();
    }

    public void paint(Graphics graphics, Shape shape) {
        JTextComponent jTextComponent;
        Object object;
        this.checkPainter();
        boolean bl = false;
        Container container = this.getContainer();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (container instanceof JTextComponent && (object = (jTextComponent = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, this);
        }
        if (Utilities.isComposedTextElement(this.getElement())) {
            Utilities.paintComposedText(graphics, shape.getBounds(), this);
            bl = true;
        } else if (container instanceof JTextComponent) {
            int n3;
            int n4;
            int n5;
            int n6;
            jTextComponent = (JTextComponent)container;
            object = jTextComponent.getSelectedTextColor();
            Caret caret = jTextComponent.getCaret();
            if (caret != null && !caret.isSelectionVisible()) {
                object = color2;
            }
            if (object != null && !((Color)object).equals(color2) && (n6 = jTextComponent.getSelectionStart()) != (n5 = jTextComponent.getSelectionEnd()) && (n4 = n6 <= n ? n : Math.min(n6, n2)) != (n3 = n5 >= n2 ? n2 : Math.max(n5, n))) {
                bl = true;
                if (n4 > n) {
                    this.paintTextUsingColor(graphics, shape, color2, n, n4);
                }
                this.paintTextUsingColor(graphics, shape, (Color)object, n4, n3);
                if (n3 < n2) {
                    this.paintTextUsingColor(graphics, shape, color2, n3, n2);
                }
            }
        }
        if (!bl) {
            this.paintTextUsingColor(graphics, shape, color2, n, n2);
        }
    }

    final void paintTextUsingColor(Graphics graphics, Shape shape, Color color, int n, int n2) {
        graphics.setColor(color);
        this.painter.paint(this, graphics, shape, n, n2);
        boolean bl = this.isUnderline();
        boolean bl2 = this.isStrikeThrough();
        if (bl || bl2) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            View view = this.getParent();
            if (view != null && view.getEndOffset() == n2) {
                Segment segment = this.getText(n, n2);
                while (segment.count > 0 && Character.isWhitespace(segment.array[segment.count - 1])) {
                    --n2;
                    --segment.count;
                }
            }
            int n3 = rectangle.x;
            int n4 = this.getStartOffset();
            if (n4 != n) {
                n3 += (int)this.painter.getSpan(this, n4, n, this.getTabExpander(), n3);
            }
            int n5 = n3 + (int)this.painter.getSpan(this, n, n2, this.getTabExpander(), n3);
            int n6 = (int)this.painter.getDescent(this);
            int n7 = rectangle.y + rectangle.height - (int)this.painter.getDescent(this);
            if (bl) {
                ++n7;
            } else if (bl2) {
                n7 -= (int)(this.painter.getAscent(this) * 0.3f);
            }
            graphics.drawLine(n3, n7, n5, n7);
        }
    }

    public float getPreferredSpan(int n) {
        this.checkPainter();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        switch (n) {
            case 0: {
                float f = this.painter.getSpan(this, n2, n3, this.expander, this.x);
                return Math.max(f, 1.0f);
            }
            case 1: {
                float f = this.painter.getHeight(this);
                if (this.isSuperscript()) {
                    f += f / 3.0f;
                }
                return f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        this.checkPainter();
        if (n == 1) {
            boolean bl = this.isSuperscript();
            boolean bl2 = this.isSubscript();
            float f = this.painter.getHeight(this);
            float f2 = this.painter.getDescent(this);
            float f3 = this.painter.getAscent(this);
            float f4 = bl ? 1.0f : (bl2 ? (f > 0.0f ? (f - (f2 + f3 / 2.0f)) / f : 0.0f) : (f > 0.0f ? (f - f2) / f : 0.0f));
            return f4;
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.checkPainter();
        return this.painter.modelToView(this, n, bias, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        return this.painter.viewToModel(this, f, f2, shape, biasArray);
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n2 = this.getStartOffset();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            if (n3 == n2) {
                return 0;
            }
            Segment segment = this.getText(n2, n3);
            char c = segment.last();
            while (c != '\uffff') {
                if (Character.isWhitespace(c)) {
                    return 2000;
                }
                c = segment.previous();
            }
            return 1000;
        }
        return super.getBreakWeight(n, f, f2);
    }

    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            Segment segment = this.getText(n2, n3);
            char c = segment.last();
            while (c != '\uffff') {
                if (Character.isWhitespace(c)) {
                    n3 = n2 + (segment.getIndex() - segment.getBeginIndex()) + 1;
                    break;
                }
                c = segment.previous();
            }
            GlyphView glyphView = (GlyphView)this.createFragment(n2, n3);
            glyphView.x = (int)f;
            return glyphView;
        }
        return this;
    }

    public View createFragment(int n, int n2) {
        this.checkPainter();
        Element element = this.getElement();
        GlyphView glyphView = (GlyphView)this.clone();
        glyphView.offset = (short)(n - element.getStartOffset());
        glyphView.length = (short)(n2 - n);
        glyphView.painter = this.painter.getPainter(glyphView, n, n2);
        return glyphView;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.painter.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, true);
    }

    public static abstract class GlyphPainter {
        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public abstract float getHeight(GlyphView var1);

        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return this;
        }

        public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = glyphView.getStartOffset();
            int n4 = glyphView.getEndOffset();
            switch (n2) {
                case 1: {
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    if (n == n4) {
                        return -1;
                    }
                    if (++n == n4) {
                        Segment segment = glyphView.getText(n4 - 1, n4);
                        if (segment.array[segment.offset] == '\n') {
                            return -1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                    } else {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    return n;
                }
                case 7: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        Segment segment = glyphView.getText(n4 - 1, n4);
                        if (segment.array[segment.offset] == '\n') {
                            biasArray[0] = Position.Bias.Forward;
                            return n4 - 1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                        return n4;
                    }
                    if (n == n3) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + n2);
                }
            }
            return n;
        }
    }
}

