/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(rectangle.x);
        int n2 = tableColumnModel.getColumnIndexAtX(rectangle.x + rectangle.width - 1);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(n);
        int n3 = n;
        while (n3 <= n2) {
            int n4;
            TableColumn tableColumn2 = tableColumnModel.getColumn(n3);
            rectangle2.width = n4 = tableColumn2.getWidth();
            if (tableColumn2 != tableColumn) {
                this.paintCell(graphics, rectangle2, n3);
            }
            rectangle2.x += n4;
            ++n3;
        }
        if (tableColumn != null) {
            int n5 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n5);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            this.paintCell(graphics, rectangle3, n5);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n) == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getHeaderHeight() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = 0;
        while (n2 < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            if (tableColumn.getHeaderRenderer() != null || !bl) {
                Component component = this.getHeaderRenderer(n2);
                int n3 = component.getPreferredSize().height;
                n = Math.max(n, n3);
                if (n3 > 0) {
                    bl = true;
                }
            }
            ++n2;
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int lastEffectiveMouseX;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private boolean canResize(TableColumn tableColumn) {
            return tableColumn != null && BasicTableHeaderUI.this.header.getResizingAllowed() && tableColumn.getResizable();
        }

        private TableColumn getResizingColumn(Point point) {
            return this.getResizingColumn(point, BasicTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(point.x));
        }

        private TableColumn getResizingColumn(Point point, int n) {
            int n2;
            if (n == -1) {
                return null;
            }
            Rectangle rectangle = BasicTableHeaderUI.this.header.getHeaderRect(n);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n3 = rectangle.x + rectangle.width / 2;
            int n4 = n2 = point.x < n3 ? n - 1 : n;
            if (n2 == -1) {
                return null;
            }
            return BasicTableHeaderUI.this.header.getColumnModel().getColumn(n2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            this.lastEffectiveMouseX = point.x;
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(point.x);
            if (n != -1) {
                TableColumn tableColumn = this.getResizingColumn(point, n);
                if (this.canResize(tableColumn)) {
                    BasicTableHeaderUI.this.header.setResizingColumn(tableColumn);
                } else if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    BasicTableHeaderUI.this.header.setDraggedColumn(tableColumn2);
                }
            }
        }

        private void setCursor(Cursor cursor) {
            if (BasicTableHeaderUI.this.header.getCursor() != cursor) {
                BasicTableHeaderUI.this.header.setCursor(cursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.canResize(this.getResizingColumn(mouseEvent.getPoint()))) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = n - this.lastEffectiveMouseX;
            if (n2 == 0) {
                return;
            }
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = BasicTableHeaderUI.this.header.getDraggedColumn();
            if (tableColumn != null) {
                int n3 = tableColumn.getWidth();
                int n4 = n3 + n2;
                tableColumn.setWidth(n4);
                int n5 = tableColumn.getWidth() - n3;
                this.lastEffectiveMouseX += n5;
            } else if (tableColumn2 != null) {
                this.move(mouseEvent, n2);
                this.lastEffectiveMouseX = n;
            } else {
                this.lastEffectiveMouseX = n;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.setDraggedDistance(0, BasicTableHeaderUI.this.viewIndexForColumn(BasicTableHeaderUI.this.header.getDraggedColumn()));
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void setDraggedDistance(int n, int n2) {
            BasicTableHeaderUI.this.header.setDraggedDistance(n);
            if (n2 != -1) {
                BasicTableHeaderUI.this.header.getColumnModel().moveColumn(n2, n2);
            }
        }

        private void move(MouseEvent mouseEvent, int n) {
            int n2;
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n3 = tableColumnModel.getColumnCount() - 1;
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getDraggedColumn();
            int n4 = BasicTableHeaderUI.this.header.getDraggedDistance() + n;
            int n5 = BasicTableHeaderUI.this.viewIndexForColumn(tableColumn);
            if (n4 < 0 && n5 != 0) {
                int n6 = tableColumnModel.getColumn(n5 - 1).getWidth();
                if (-n4 > n6 / 2) {
                    tableColumnModel.moveColumn(n5, n5 - 1);
                    n4 = n6 + n4;
                    --n5;
                }
            } else if (n4 > 0 && n5 != n3 && n4 > (n2 = tableColumnModel.getColumn(n5 + 1).getWidth()) / 2) {
                tableColumnModel.moveColumn(n5, n5 + 1);
                n4 = -(n2 - n4);
                ++n5;
            }
            BasicTableHeaderUI.this.header.setDraggedColumn(tableColumnModel.getColumn(n5));
            this.setDraggedDistance(n4, n5);
        }
    }
}

