/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.Normalizer;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        if (string.length() != 0) {
            this.text = new Normalizer(string, ruleBasedCollator.getDecomposition());
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        this.text = new Normalizer(characterIterator, ruleBasedCollator.getDecomposition());
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            this.text.setDecomposition(this.owner.getDecomposition());
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int next() {
        if (this.text == null) {
            return -1;
        }
        if (this.text.getDecomposition() != this.owner.getDecomposition()) {
            this.text.setDecomposition(this.owner.getDecomposition());
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        char c = this.text.next();
        if (c == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.swapOrder = c;
            return 0x7FFF0000;
        }
        if (n >= 0x7F000000) {
            n = this.nextContractChar(c);
        }
        if (n >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n);
            this.expIndex = 0;
            n = this.buffer[this.expIndex++];
        }
        return this.strengthOrder(n);
    }

    public int previous() {
        if (this.text == null) {
            return -1;
        }
        if (this.text.getDecomposition() != this.owner.getDecomposition()) {
            this.text.setDecomposition(this.owner.getDecomposition());
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        char c = this.text.previous();
        if (c == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.swapOrder = 0x7FFF0000;
            return c;
        }
        if (n >= 0x7F000000) {
            n = this.prevContractChar(c);
        }
        if (n >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n);
            this.expIndex = this.buffer.length;
            n = this.buffer[--this.expIndex];
        }
        return this.strengthOrder(n);
    }

    public static final int primaryOrder(int n) {
        return (n &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }

    final int strengthOrder(int n) {
        int n2 = this.owner.getStrength();
        if (n2 == 0) {
            n &= 0xFFFF0000;
        } else if (n2 == 1) {
            n &= 0xFFFFFF00;
        }
        return n;
    }

    public void setOffset(int n) {
        if (this.text != null) {
            if (n < this.text.getText().getBeginIndex() || n >= this.text.getText().getEndIndex()) {
                this.text.setOffset(n);
            } else {
                this.text.setOffset(n + 1);
                char c = this.text.previous();
                if (this.ordering.usedInContractSeq(c)) {
                    while (this.ordering.usedInContractSeq(c)) {
                        c = this.text.previous();
                    }
                    int n2 = this.text.getOffset();
                    while (this.text.getOffset() <= n) {
                        n2 = this.text.getOffset();
                        this.next();
                    }
                    this.text.setOffset(n2);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getOffset() : 0;
    }

    public int getMaxExpansion(int n) {
        return this.ordering.getMaxExpansion(n);
    }

    public void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        if (this.text == null) {
            this.text = new Normalizer(string, this.owner.getDecomposition());
        } else {
            this.text.setDecomposition(this.owner.getDecomposition());
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        if (this.text == null) {
            this.text = new Normalizer(characterIterator, this.owner.getDecomposition());
        } else {
            this.text.setDecomposition(this.owner.getDecomposition());
            this.text.setText(characterIterator);
        }
    }

    static final boolean isIgnorable(int n) {
        return CollationElementIterator.primaryOrder(n) == 0;
    }

    private int nextContractChar(char c) {
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n2 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.previous();
        this.key.setLength(0);
        char c2 = normalizer.next();
        while (n2 > 0 && c2 != '\uffff') {
            this.key.append(c2);
            --n2;
            c2 = normalizer.next();
        }
        String string = this.key.toString();
        n2 = 1;
        int n3 = vector.size() - 1;
        while (n3 > 0) {
            entryPair = (EntryPair)vector.elementAt(n3);
            if (entryPair.fwd && string.startsWith(entryPair.entryName) && entryPair.entryName.length() > n2) {
                n2 = entryPair.entryName.length();
                n = entryPair.value;
            }
            --n3;
        }
        while (n2 > 1) {
            this.text.next();
            --n2;
        }
        return n;
    }

    private int prevContractChar(char c) {
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n2 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.next();
        this.key.setLength(0);
        char c2 = normalizer.previous();
        while (n2 > 0 && c2 != '\uffff') {
            this.key.append(c2);
            --n2;
            c2 = normalizer.previous();
        }
        String string = this.key.toString();
        n2 = 1;
        int n3 = vector.size() - 1;
        while (n3 > 0) {
            entryPair = (EntryPair)vector.elementAt(n3);
            if (!entryPair.fwd && string.startsWith(entryPair.entryName) && entryPair.entryName.length() > n2) {
                n2 = entryPair.entryName.length();
                n = entryPair.value;
            }
            --n3;
        }
        while (n2 > 1) {
            this.text.previous();
            --n2;
        }
        return n;
    }
}

