/*
 * Decompiled with CFR 0.152.
 */
public class GMath {
    public static final int NEGATIVE = -1;
    public static final int ZERO = 0;
    public static final int POSITIVE = 1;
    public static final int LEADING_DIGITS = 3;
    public static final double ZERO_TOLERANCE = 1.0E-5;
    public static final double INFINITY = Double.POSITIVE_INFINITY;

    public static boolean isAtZero(double d, double d2) {
        return Math.abs(d / d2) < 1.0E-5;
    }

    public static boolean areEqual(double d, double d2) {
        if (d == 0.0) {
            return d2 == 0.0;
        }
        return GMath.isAtZero(d - d2, d);
    }

    public static GPoint3D times(double d, GPoint3D gPoint3D) {
        return new GPoint3D(d * gPoint3D.X, d * gPoint3D.Y, d * gPoint3D.Z);
    }

    public static GPoint3D add(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return new GPoint3D(gPoint3D.X + gPoint3D2.X, gPoint3D.Y + gPoint3D2.Y, gPoint3D.Z + gPoint3D2.Z);
    }

    public static GPoint3D subtract(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return new GPoint3D(gPoint3D.X - gPoint3D2.X, gPoint3D.Y - gPoint3D2.Y, gPoint3D.Z - gPoint3D2.Z);
    }

    public static double norm(GPoint3D gPoint3D) {
        return Math.sqrt(gPoint3D.X * gPoint3D.X + gPoint3D.Y * gPoint3D.Y + gPoint3D.Z * gPoint3D.Z);
    }

    public static GPoint3D toNorm(GPoint3D gPoint3D) {
        double d = GMath.norm(gPoint3D);
        if (d <= 1.0E-5) {
            return new GPoint3D(0.0, 0.0, 0.0);
        }
        return new GPoint3D(gPoint3D.X / d, gPoint3D.Y / d, gPoint3D.Z / d);
    }

    public static double scalarP(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return gPoint3D.X * gPoint3D2.X + gPoint3D.Y * gPoint3D2.Y + gPoint3D.Z * gPoint3D2.Z;
    }

    public static double scalarP(GEdge gEdge, GPoint3D gPoint3D) {
        return GMath.scalarP(gPoint3D, GMath.subtract(gEdge.getTail().xyzCrds, gEdge.getHead().xyzCrds));
    }

    public static GPoint3D vectorP(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return new GPoint3D(gPoint3D.Y * gPoint3D2.Z - gPoint3D.Z * gPoint3D2.Y, gPoint3D.Z * gPoint3D2.X - gPoint3D.X * gPoint3D2.Z, gPoint3D.X * gPoint3D2.Y - gPoint3D.Y * gPoint3D2.X);
    }

    public static double mixtP(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        return gPoint3D.X * gPoint3D2.Y * gPoint3D3.Z + gPoint3D.Y * gPoint3D2.Z * gPoint3D3.X + gPoint3D2.X * gPoint3D3.Y * gPoint3D.Z - gPoint3D.Z * gPoint3D2.Y * gPoint3D3.X - gPoint3D.Y * gPoint3D2.X * gPoint3D3.Z - gPoint3D.X * gPoint3D2.Z * gPoint3D3.Y;
    }

    public static GPoint3D anOrthVector(GPoint3D gPoint3D) {
        if (GMath.isAtZero(gPoint3D.X, GMath.norm(gPoint3D))) {
            return new GPoint3D(0.0, -gPoint3D.Z, gPoint3D.Y);
        }
        return new GPoint3D(-gPoint3D.Y, gPoint3D.X, 0.0);
    }

    public static double[][] copy(double[][] dArray) {
        double[][] dArrayArray = new double[][]{{dArray[0][0], dArray[0][1], dArray[0][2]}, {dArray[1][0], dArray[1][1], dArray[1][2]}, {dArray[2][0], dArray[2][1], dArray[2][2]}};
        return dArrayArray;
    }

    public static double[][] colsToMatrix(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        double[][] dArrayArray = new double[][]{{gPoint3D.X, gPoint3D2.X, gPoint3D3.X}, {gPoint3D.Y, gPoint3D2.Y, gPoint3D3.Y}, {gPoint3D.Z, gPoint3D2.Z, gPoint3D3.Z}};
        return dArrayArray;
    }

    public static double[][] invert(double[][] dArray) {
        double[][] dArrayArray = new double[][]{{dArray[0][0], dArray[1][0], dArray[2][0]}, {dArray[0][1], dArray[1][1], dArray[2][1]}, {dArray[0][2], dArray[1][2], dArray[2][2]}};
        return dArrayArray;
    }

    public static GPoint3D[] orthize(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        GPoint3D gPoint3D4;
        GPoint3D gPoint3D5 = GMath.toNorm(gPoint3D);
        GPoint3D gPoint3D6 = GMath.add(gPoint3D2, GMath.times(-GMath.scalarP(gPoint3D2, gPoint3D5), gPoint3D5));
        GPoint3D gPoint3D7 = GMath.toNorm(gPoint3D6);
        if (GMath.mixtP(gPoint3D5, gPoint3D7, gPoint3D4 = GMath.toNorm(gPoint3D6 = GMath.add(GMath.add(gPoint3D3, GMath.times(-GMath.scalarP(gPoint3D3, gPoint3D5), gPoint3D5)), GMath.times(-GMath.scalarP(gPoint3D3, gPoint3D7), gPoint3D7)))) == 0.0) {
            return null;
        }
        GPoint3D[] gPoint3DArray = new GPoint3D[]{gPoint3D5, gPoint3D7, gPoint3D4};
        return gPoint3DArray;
    }

    public static double[][] orthize(double[][] dArray) {
        GPoint3D[] gPoint3DArray = new GPoint3D[3];
        int n = 0;
        while (n < 3) {
            gPoint3DArray[n] = new GPoint3D(dArray[0][n], dArray[1][n], dArray[2][n]);
            ++n;
        }
        gPoint3DArray = GMath.orthize(gPoint3DArray[0], gPoint3DArray[1], gPoint3DArray[2]);
        return GMath.colsToMatrix(gPoint3DArray[0], gPoint3DArray[1], gPoint3DArray[2]);
    }

    public static double[][] orthize(GEdge gEdge, GEdge gEdge2) {
        GPoint3D gPoint3D = GMath.subtract(gEdge.getTail().xyzCrds, gEdge.getHead().xyzCrds);
        GPoint3D gPoint3D2 = GMath.subtract(gEdge2.getTail().xyzCrds, gEdge2.getHead().xyzCrds);
        GPoint3D[] gPoint3DArray = GMath.orthize(gPoint3D, gPoint3D2, GMath.vectorP(gPoint3D, gPoint3D2));
        return GMath.colsToMatrix(gPoint3DArray[0], gPoint3DArray[1], gPoint3DArray[2]);
    }

    public static GPoint3D times(double[][] dArray, GPoint3D gPoint3D) {
        GPoint3D gPoint3D2 = new GPoint3D();
        gPoint3D2.X = dArray[0][0] * gPoint3D.X + dArray[0][1] * gPoint3D.Y + dArray[0][2] * gPoint3D.Z;
        gPoint3D2.Y = dArray[1][0] * gPoint3D.X + dArray[1][1] * gPoint3D.Y + dArray[1][2] * gPoint3D.Z;
        gPoint3D2.Z = dArray[2][0] * gPoint3D.X + dArray[2][1] * gPoint3D.Y + dArray[2][2] * gPoint3D.Z;
        return gPoint3D2;
    }

    public static GPoint3D times(GPoint3D gPoint3D, double[][] dArray) {
        GPoint3D gPoint3D2 = new GPoint3D();
        gPoint3D2.X = dArray[0][0] * gPoint3D.X + dArray[1][0] * gPoint3D.Y + dArray[2][0] * gPoint3D.Z;
        gPoint3D2.Y = dArray[0][1] * gPoint3D.X + dArray[1][1] * gPoint3D.Y + dArray[2][1] * gPoint3D.Z;
        gPoint3D2.Z = dArray[0][2] * gPoint3D.X + dArray[1][2] * gPoint3D.Y + dArray[2][2] * gPoint3D.Z;
        return gPoint3D2;
    }

    public static double[][] times(double[][] dArray, double[][] dArray2) {
        double[][] dArrayArray = new double[][]{{dArray[0][0] * dArray2[0][0] + dArray[0][1] * dArray2[1][0] + dArray[0][2] * dArray2[2][0], dArray[0][0] * dArray2[0][1] + dArray[0][1] * dArray2[1][1] + dArray[0][2] * dArray2[2][1], dArray[0][0] * dArray2[0][2] + dArray[0][1] * dArray2[1][2] + dArray[0][2] * dArray2[2][2]}, {dArray[1][0] * dArray2[0][0] + dArray[1][1] * dArray2[1][0] + dArray[1][2] * dArray2[2][0], dArray[1][0] * dArray2[0][1] + dArray[1][1] * dArray2[1][1] + dArray[1][2] * dArray2[2][1], dArray[1][0] * dArray2[0][2] + dArray[1][1] * dArray2[1][2] + dArray[1][2] * dArray2[2][2]}, {dArray[2][0] * dArray2[0][0] + dArray[2][1] * dArray2[1][0] + dArray[2][2] * dArray2[2][0], dArray[2][0] * dArray2[0][1] + dArray[2][1] * dArray2[1][1] + dArray[2][2] * dArray2[2][1], dArray[2][0] * dArray2[0][2] + dArray[2][1] * dArray2[1][2] + dArray[2][2] * dArray2[2][2]}};
        return dArrayArray;
    }

    public static double[][] revolve(double[][] dArray, double d, GPoint3D gPoint3D) {
        d = d * Math.PI / 180.0;
        new GPoint3D(0.0, 0.0, 0.0);
        gPoint3D = GMath.toNorm(gPoint3D);
        GPoint3D gPoint3D2 = GMath.toNorm(GMath.anOrthVector(gPoint3D));
        GPoint3D gPoint3D3 = GMath.vectorP(gPoint3D, gPoint3D2);
        double[][] dArray2 = GMath.colsToMatrix(gPoint3D2, gPoint3D3, gPoint3D);
        GPoint3D[] gPoint3DArray = new GPoint3D[3];
        int n = 0;
        while (n < 3) {
            GPoint3D gPoint3D4 = new GPoint3D(dArray[0][n], dArray[1][n], dArray[2][n]);
            gPoint3D4 = GMath.times(gPoint3D4, dArray2);
            gPoint3D4 = new GPoint3D(gPoint3D4.X * Math.cos(d) - gPoint3D4.Y * Math.sin(d), gPoint3D4.X * Math.sin(d) + gPoint3D4.Y * Math.cos(d), gPoint3D4.Z);
            gPoint3DArray[n] = gPoint3D4 = GMath.times(dArray2, gPoint3D4);
            ++n;
        }
        return GMath.orthize(GMath.colsToMatrix(gPoint3DArray[0], gPoint3DArray[1], gPoint3DArray[2]));
    }

    public static double dist(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return Math.sqrt((gPoint3D2.X - gPoint3D.X) * (gPoint3D2.X - gPoint3D.X) + (gPoint3D2.Y - gPoint3D.Y) * (gPoint3D2.Y - gPoint3D.Y) + (gPoint3D2.Z - gPoint3D.Z) * (gPoint3D2.Z - gPoint3D.Z));
    }

    public static double angle(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        double d = Math.acos(GMath.scalarP(gPoint3D, gPoint3D2) / (GMath.norm(gPoint3D) * GMath.norm(gPoint3D2)));
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d;
    }

    public static double angle(GEdge gEdge, GEdge gEdge2) {
        GPoint3D gPoint3D = GMath.subtract(gEdge.getTail().xyzCrds, gEdge.getHead().xyzCrds);
        GPoint3D gPoint3D2 = GMath.subtract(gEdge2.getTail().xyzCrds, gEdge2.getHead().xyzCrds);
        return Math.acos(GMath.scalarP(gPoint3D, gPoint3D2) / (GMath.norm(gPoint3D) * GMath.norm(gPoint3D2)));
    }

    public static boolean isAt(GPoint3D gPoint3D, GPoint3D gPoint3D2, double d) {
        return GMath.dist(gPoint3D, gPoint3D2) / d <= 1.0E-5;
    }

    public static boolean isAt(GVertex gVertex, GPoint3D gPoint3D, double d) {
        return GMath.dist(gVertex.xyzCrds, gPoint3D) / d <= 1.0E-5;
    }

    public static double simpleRatio(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        GPoint3D gPoint3D4 = GMath.subtract(gPoint3D3, gPoint3D);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D2, gPoint3D3);
        if (GMath.norm(gPoint3D5) <= 1.0E-5) {
            return Double.POSITIVE_INFINITY;
        }
        double d = GMath.norm(gPoint3D5);
        if (!GMath.isAtZero(gPoint3D5.X, d)) {
            return gPoint3D4.X / gPoint3D5.X;
        }
        if (!GMath.isAtZero(gPoint3D5.Y, d)) {
            return gPoint3D4.Y / gPoint3D5.Y;
        }
        return gPoint3D4.Z / gPoint3D5.Z;
    }

    public static boolean areCollinear(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        GPoint3D gPoint3D4 = GMath.subtract(gPoint3D2, gPoint3D);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D3, gPoint3D);
        GPoint3D gPoint3D6 = GMath.subtract(gPoint3D2, gPoint3D3);
        return GMath.norm(gPoint3D4) <= 1.0E-5 || GMath.norm(gPoint3D5) <= 1.0E-5 || GMath.norm(gPoint3D6) <= 1.0E-5 || GMath.norm(GMath.vectorP(gPoint3D5, gPoint3D6)) / (GMath.norm(gPoint3D5) * GMath.norm(gPoint3D6)) <= 1.0E-5;
    }

    public static boolean areCollinear(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return GMath.norm(gPoint3D) <= 1.0E-5 || GMath.norm(gPoint3D2) <= 1.0E-5 || GMath.norm(GMath.vectorP(gPoint3D, gPoint3D2)) / (GMath.norm(gPoint3D) * GMath.norm(gPoint3D2)) <= 1.0E-5;
    }

    public static boolean areCollinear(GEdge gEdge, GEdge gEdge2) {
        GPoint3D gPoint3D = gEdge.getHead().xyzCrds;
        GPoint3D gPoint3D2 = gEdge.getTail().xyzCrds;
        GPoint3D gPoint3D3 = gEdge2.getHead().xyzCrds;
        GPoint3D gPoint3D4 = gEdge2.getTail().xyzCrds;
        return GMath.areCollinear(gPoint3D, gPoint3D2, gPoint3D3) && GMath.areCollinear(gPoint3D, gPoint3D2, gPoint3D4);
    }

    public static boolean areOrthogonal(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        if (GMath.norm(gPoint3D) < 1.0E-5 || GMath.norm(gPoint3D2) < 1.0E-5) {
            return true;
        }
        return Math.abs(GMath.angle(gPoint3D, gPoint3D2) - 1.5707963267948966) < 1.0E-5;
    }

    public static boolean isBetween(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        GPoint3D gPoint3D4 = GMath.subtract(gPoint3D3, gPoint3D);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D2, gPoint3D3);
        return GMath.norm(gPoint3D4) <= 1.0E-5 || GMath.norm(gPoint3D5) <= 1.0E-5 || GMath.norm(GMath.vectorP(gPoint3D4, gPoint3D5)) / (GMath.norm(gPoint3D4) * GMath.norm(gPoint3D5)) <= 1.0E-5 && GMath.simpleRatio(gPoint3D, gPoint3D2, gPoint3D3) > 0.0;
    }

    public static GPoint3D drop(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        GPoint3D gPoint3D4;
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D3, gPoint3D2);
        double d = GMath.scalarP(gPoint3D5, gPoint3D4 = GMath.subtract(gPoint3D, gPoint3D2)) / GMath.scalarP(gPoint3D5, gPoint3D5);
        if (Double.isNaN(d)) {
            return null;
        }
        return new GPoint3D(gPoint3D2.X + gPoint3D5.X * d, gPoint3D2.Y + gPoint3D5.Y * d, gPoint3D2.Z + gPoint3D5.Z * d);
    }

    public static int[] expForm(double d) {
        if (d <= 0.0) {
            return null;
        }
        int n = 0;
        if (d < 1.0) {
            while (d < 1.0) {
                --n;
                d *= 10.0;
            }
        } else if (d >= 10.0) {
            while (d >= 10.0) {
                ++n;
                d /= 10.0;
            }
        }
        int[] nArray = new int[]{(int)Math.floor(d), n};
        return nArray;
    }

    public static int leadingDigits(double d) {
        String string = String.valueOf(d);
        int n = string.length();
        if (d == 0.0 || string.indexOf(69) > 0) {
            return n;
        }
        if (d >= Math.pow(10.0, 3.0)) {
            return string.indexOf(46);
        }
        int n2 = 0;
        while (string.charAt(n2) == '0' || string.charAt(n2) == '.') {
            ++n2;
        }
        n2 = Math.min(n, n2 + 3);
        if (string.charAt(0) != '0' && string.indexOf(46) <= n2) {
            ++n2;
        }
        return n2;
    }

    public static double intPow(int n, int n2) {
        double d;
        block3: {
            block2: {
                d = 1.0;
                if (n2 <= 0) break block2;
                int n3 = 0;
                while (n3 < n2) {
                    d *= (double)n;
                    ++n3;
                }
                break block3;
            }
            if (n2 >= 0) break block3;
            int n4 = 0;
            while (n4 > n2) {
                d /= (double)n;
                --n4;
            }
        }
        return d;
    }

    public static int random(int n) {
        return (int)((double)n * Math.random());
    }

    public static int random(int n, int n2) {
        return (int)((double)(n2 - n) * Math.random()) + n;
    }

    public static void sort(double[] dArray) {
        double d = dArray.length;
        if (d < 2.0) {
            return;
        }
        int n = 0;
        while ((double)n < d - 1.0) {
            int n2 = n + 1;
            while ((double)n2 < d) {
                if (dArray[n2] < dArray[n]) {
                    double d2 = dArray[n];
                    dArray[n] = dArray[n2];
                    dArray[n2] = d2;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static GPoint3D adhereXYPlane(GPoint3D gPoint3D, GProjSystem gProjSystem) {
        GPoint3D gPoint3D2 = gProjSystem.xyzToUVW(new GPoint3D(0.0, 0.0, 0.0));
        GPoint3D gPoint3D3 = GMath.subtract(gProjSystem.xyzToUVW(new GPoint3D(0.0, 0.0, 1.0)), gPoint3D2);
        double d = (gPoint3D3.X * (gPoint3D2.X - gPoint3D.X) + gPoint3D3.Y * (gPoint3D2.Y - gPoint3D.Y)) / gPoint3D3.Z + gPoint3D2.Z;
        if (Double.isNaN(d)) {
            return null;
        }
        return gProjSystem.uvwToXYZ(new GPoint3D(gPoint3D.X, gPoint3D.Y, d));
    }

    public static boolean adhere(GPoint3D gPoint3D, GPoint3D gPoint3D2, GProjSystem gProjSystem, double d) {
        return GMath.dist(gPoint3D, gProjSystem.project(gPoint3D2)) <= d;
    }

    public static GPoint3D adhere(GPoint3D gPoint3D, GSegment gSegment, GProjSystem gProjSystem, double d) {
        GPoint3D gPoint3D2 = gProjSystem.project(gSegment.end1);
        GPoint3D gPoint3D3 = gProjSystem.project(gSegment.end2);
        if (GMath.dist(gPoint3D, gPoint3D2) <= d) {
            return gSegment.end1;
        }
        if (GMath.dist(gPoint3D, gPoint3D3) <= d) {
            return gSegment.end2;
        }
        if (gPoint3D2.equals(gPoint3D3)) {
            return null;
        }
        GPoint3D gPoint3D4 = GMath.drop(gPoint3D, gPoint3D2, gPoint3D3);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D4, gPoint3D2);
        GPoint3D gPoint3D6 = GMath.subtract(gPoint3D3, gPoint3D2);
        GPoint3D gPoint3D7 = GMath.subtract(gPoint3D3, gPoint3D4);
        if (GMath.scalarP(gPoint3D5, gPoint3D7) < 0.0) {
            return null;
        }
        if (GMath.dist(gPoint3D, gPoint3D4) > d) {
            return null;
        }
        double d2 = GMath.norm(gPoint3D5) / GMath.norm(gPoint3D6);
        return GMath.add(gSegment.end1, GMath.times(d2, GMath.subtract(gSegment.end2, gSegment.end1)));
    }

    public static GPoint3D adhere(GPoint3D gPoint3D, GFacet gFacet, GProjSystem gProjSystem) {
        GPoint3D gPoint3D2 = gFacet.edgeList.getHead().getEdge().getHead().uvwCrds;
        GPoint3D gPoint3D3 = gFacet.getUVWNormal();
        double d = (gPoint3D3.X * (gPoint3D2.X - gPoint3D.X) + gPoint3D3.Y * (gPoint3D2.Y - gPoint3D.Y)) / gPoint3D3.Z + gPoint3D2.Z;
        if (Double.isNaN(d)) {
            return null;
        }
        GPoint3D gPoint3D4 = gProjSystem.uvwToXYZ(new GPoint3D(gPoint3D.X, gPoint3D.Y, d));
        if (gFacet.encircles(gPoint3D4)) {
            return gPoint3D4;
        }
        return null;
    }

    public static GPoint3D midpoint(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        return new GPoint3D((gPoint3D.X + gPoint3D2.X) / 2.0, (gPoint3D.Y + gPoint3D2.Y) / 2.0, (gPoint3D.Z + gPoint3D2.Z) / 2.0);
    }

    public static GPoint3D intersect(GEdge gEdge, GEdge gEdge2) {
        GPoint3D gPoint3D = gEdge.getHead().xyzCrds;
        GPoint3D gPoint3D2 = gEdge.toVector();
        GPoint3D gPoint3D3 = gEdge2.getHead().xyzCrds;
        GPoint3D gPoint3D4 = gEdge2.toVector();
        if (GMath.areCollinear(gPoint3D2, gPoint3D4)) {
            return null;
        }
        double d = GMath.norm(gPoint3D2);
        double d2 = gPoint3D2.X * gPoint3D4.Y - gPoint3D2.Y * gPoint3D4.X;
        double d3 = !GMath.isAtZero(d2, d *= d) ? (gPoint3D4.Y * (gPoint3D3.X - gPoint3D.X) - gPoint3D4.X * (gPoint3D3.Y - gPoint3D.Y)) / d2 : (!GMath.isAtZero(d2 = gPoint3D2.Y * gPoint3D4.Z - gPoint3D2.Z * gPoint3D4.Y, d) ? (gPoint3D4.Z * (gPoint3D3.Y - gPoint3D.Y) - gPoint3D4.Y * (gPoint3D3.Z - gPoint3D.Z)) / d2 : (gPoint3D4.X * (gPoint3D3.Z - gPoint3D.Z) - gPoint3D4.Z * (gPoint3D3.X - gPoint3D.X)) / (gPoint3D2.Z * gPoint3D4.X - gPoint3D2.X * gPoint3D4.Z));
        return new GPoint3D(gPoint3D.X + gPoint3D2.X * d3, gPoint3D.Y + gPoint3D2.Y * d3, gPoint3D.Z + gPoint3D2.Z * d3);
    }

    public static double deviation(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        return (gPoint3D3.X * (gPoint3D.X - gPoint3D2.X) + gPoint3D3.Y * (gPoint3D.Y - gPoint3D2.Y) + gPoint3D3.Z * (gPoint3D.Z - gPoint3D2.Z)) / GMath.norm(gPoint3D3);
    }

    public static GPoint3D intersect(GEdge gEdge, GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        GPoint3D gPoint3D3 = gEdge.getHead().xyzCrds;
        GPoint3D gPoint3D4 = gEdge.getTail().xyzCrds;
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D4, gPoint3D3);
        double d = (gPoint3D2.X * (gPoint3D.X - gPoint3D3.X) + gPoint3D2.Y * (gPoint3D.Y - gPoint3D3.Y) + gPoint3D2.Z * (gPoint3D.Z - gPoint3D3.Z)) / (gPoint3D2.X * gPoint3D5.X + gPoint3D2.Y * gPoint3D5.Y + gPoint3D2.Z * gPoint3D5.Z);
        if (d < 1.00001 && d > -1.0E-5) {
            return GMath.add(gPoint3D3, GMath.times(d, gPoint3D5));
        }
        return null;
    }

    public static GPoint3D[] intersectSphere(GEdge gEdge, GPoint3D gPoint3D, double d) {
        double d2;
        GPoint3D[] gPoint3DArray = new GPoint3D[2];
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        GPoint3D gPoint3D2 = gEdge.getHead().xyzCrds;
        GPoint3D gPoint3D3 = gEdge.getTail().xyzCrds;
        GPoint3D gPoint3D4 = GMath.subtract(gPoint3D3, gPoint3D2);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D2, gPoint3D);
        double d3 = GMath.scalarP(gPoint3D4, gPoint3D4);
        double d4 = GMath.scalarP(gPoint3D4, gPoint3D5);
        double d5 = d4 * d4 - d3 * (d2 = GMath.scalarP(gPoint3D5, gPoint3D5) - d * d);
        if (GMath.isAtZero(d5, d3 * d3)) {
            dArray[0] = -d4 / d3;
        } else if (d5 > 0.0) {
            double d6 = Math.sqrt(d5);
            dArray[0] = (-d4 - d6) / d3;
            dArray[1] = (-d4 + d6) / d3;
        }
        int n = 0;
        while (n < 2) {
            if (dArray[n] < 1.00001 && dArray[n] > -1.0E-5) {
                gPoint3DArray[n] = GMath.add(gPoint3D2, GMath.times(dArray[n], gPoint3D4));
            }
            ++n;
        }
        return gPoint3DArray;
    }

    public static boolean isSimilar(GEdge gEdge, GEdge gEdge2, GEdge gEdge3, GEdge gEdge4) {
        return Math.abs(gEdge.getLength() / gEdge2.getLength() - gEdge3.getLength() / gEdge4.getLength()) < 1.0E-5 && Math.abs(GMath.angle(gEdge, gEdge2) - GMath.angle(gEdge3, gEdge4)) < 1.0E-5;
    }

    public static GPoint3D[] layAngle(GPoint3D gPoint3D, GPoint3D gPoint3D2, double d) {
        double d2 = GMath.norm(gPoint3D);
        double d3 = d2 * Math.cos(d * Math.PI / 180.0);
        GPoint3D[] gPoint3DArray = new GPoint3D[2];
        double d4 = gPoint3D.X * gPoint3D2.Y - gPoint3D.Y * gPoint3D2.X;
        if (!GMath.isAtZero(d4, d2 * d2)) {
            gPoint3DArray = GMath.solve(gPoint3D.X, gPoint3D.Y, gPoint3D.Z, gPoint3D2.X, gPoint3D2.Y, gPoint3D2.Z, d3);
        } else {
            d4 = gPoint3D.Y * gPoint3D2.Z - gPoint3D.Z * gPoint3D2.Y;
            if (!GMath.isAtZero(d4, d2 * d2)) {
                gPoint3DArray = GMath.solve(gPoint3D.Y, gPoint3D.Z, gPoint3D.X, gPoint3D2.Y, gPoint3D2.Z, gPoint3D2.X, d3);
                gPoint3DArray[0] = new GPoint3D(gPoint3DArray[0].Z, gPoint3DArray[0].X, gPoint3DArray[0].Y);
                gPoint3DArray[1] = new GPoint3D(gPoint3DArray[1].Z, gPoint3DArray[1].X, gPoint3DArray[1].Y);
            } else {
                d4 = gPoint3D.X * gPoint3D2.Z - gPoint3D.Z * gPoint3D2.X;
                gPoint3DArray = GMath.solve(gPoint3D.X, gPoint3D.Z, gPoint3D.Y, gPoint3D2.X, gPoint3D2.Z, gPoint3D2.Y, d3);
                gPoint3DArray[0] = new GPoint3D(gPoint3DArray[0].X, gPoint3DArray[0].Z, gPoint3DArray[0].Y);
                gPoint3DArray[1] = new GPoint3D(gPoint3DArray[1].X, gPoint3DArray[1].Z, gPoint3DArray[1].Y);
            }
        }
        GPoint3D[] gPoint3DArray2 = new GPoint3D[]{GMath.vectorP(gPoint3DArray[0], gPoint3D2), GMath.vectorP(gPoint3DArray[1], gPoint3D2)};
        return gPoint3DArray2;
    }

    public static GPoint3D[] solve(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d * d5 - d2 * d4;
        double d9 = d3 * d5 - d2 * d6;
        double d10 = d3 * d4 - d * d6;
        double d11 = d9 * d9 + d10 * d10 + d8 * d8;
        double d12 = d9 * d7 * d5 + d10 * d7 * d4;
        double d13 = d7 * d7 * (d4 * d4 + d5 * d5) - d8 * d8;
        double d14 = Math.sqrt(d12 * d12 - d11 * d13);
        double[] dArray = new double[]{(d12 + d14) / d11, (d12 - d14) / d11};
        GPoint3D[] gPoint3DArray = new GPoint3D[2];
        int n = 0;
        while (n < 2) {
            double d15 = (d7 * d5 - dArray[n] * d9) / d8;
            double d16 = (-d7 * d4 + dArray[n] * d10) / d8;
            gPoint3DArray[n] = new GPoint3D(d15, d16, dArray[n]);
            ++n;
        }
        return gPoint3DArray;
    }

    public static double area(GPoint3D gPoint3D, GPoint3D gPoint3D2, GPoint3D gPoint3D3) {
        double d = (gPoint3D2.Y - gPoint3D.Y) * (gPoint3D3.Z - gPoint3D.Z) - (gPoint3D2.Z - gPoint3D.Z) * (gPoint3D3.Y - gPoint3D.Y);
        double d2 = (gPoint3D2.Z - gPoint3D.Z) * (gPoint3D3.X - gPoint3D.X) - (gPoint3D2.X - gPoint3D.X) * (gPoint3D3.Z - gPoint3D.Z);
        double d3 = (gPoint3D2.X - gPoint3D.X) * (gPoint3D3.Y - gPoint3D.Y) - (gPoint3D2.Y - gPoint3D.Y) * (gPoint3D3.X - gPoint3D.X);
        return 0.5 * Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static double distance(GPoint3D gPoint3D, GFacet gFacet) {
        GPoint3D gPoint3D2 = gFacet.getXYZNormal();
        GPoint3D gPoint3D3 = gFacet.edgeList.getHead().getEdge().getHead().xyzCrds;
        return Math.abs(GMath.scalarP(gPoint3D2, GMath.subtract(gPoint3D, gPoint3D3))) / GMath.norm(gPoint3D2);
    }
}

