/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GProjSystem
implements Serializable {
    public static final double VSLOPE = 1.1780972450961724;
    public static final double HSLOPE = 1.2566370614359172;
    private double[][] matrix;
    private GPoint3D center;

    public GProjSystem() {
        this.initMatrix();
        this.center = new GPoint3D();
    }

    public void print() {
        System.out.print("Center: ");
        this.center.print();
        System.out.println("Matrix:\n" + this.matrix);
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(double[][] dArray) {
        this.matrix = dArray;
    }

    public GPoint3D getCenter() {
        return this.center;
    }

    public void setCenter(GPoint3D gPoint3D) {
        this.center = gPoint3D;
    }

    public GPoint3D getJ() {
        return new GPoint3D(this.matrix[0][1], this.matrix[1][1], this.matrix[2][1]);
    }

    public GPoint3D getK() {
        return new GPoint3D(this.matrix[0][2], this.matrix[1][2], this.matrix[2][2]);
    }

    public GProjSystem copy() {
        GProjSystem gProjSystem = new GProjSystem();
        gProjSystem.matrix = GMath.copy(this.matrix);
        gProjSystem.center = new GPoint3D(this.center);
        return gProjSystem;
    }

    public boolean equals(GProjSystem gProjSystem) {
        if (!this.center.equals(gProjSystem.center)) {
            return false;
        }
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                if (this.matrix[n][n2] != gProjSystem.matrix[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    protected void initMatrix() {
        double d = Math.cos(1.2566370614359172);
        double d2 = Math.cos(1.1780972450961724);
        double d3 = Math.sqrt(1.0 - d * d - d2 * d2);
        double d4 = Math.sqrt(1.0 - d2 * d2);
        GPoint3D gPoint3D = new GPoint3D(-d / d4, -d3 * d2 / d4, d3);
        GPoint3D gPoint3D2 = new GPoint3D(d3 / d4, -d * d2 / d4, d);
        GPoint3D gPoint3D3 = new GPoint3D(0.0, d4, d2);
        this.matrix = GMath.colsToMatrix(gPoint3D, gPoint3D2, gPoint3D3);
    }

    public GPoint3D xyzToUVW(GPoint3D gPoint3D) {
        return GMath.times(this.matrix, GMath.subtract(gPoint3D, this.center));
    }

    public GPoint3D uvwToXYZ(GPoint3D gPoint3D) {
        return GMath.add(GMath.times(gPoint3D, this.matrix), this.center);
    }

    public GPoint3D project(GPoint3D gPoint3D) {
        GPoint3D gPoint3D2 = this.xyzToUVW(gPoint3D);
        gPoint3D2.Z = 0.0;
        return gPoint3D2;
    }

    public GSegment project(GSegment gSegment) {
        return new GSegment(this.project(gSegment.end1), this.project(gSegment.end2));
    }

    public GRectangle project(GRectangle gRectangle) {
        GPoint3D[] gPoint3DArray = new GPoint3D[]{new GPoint3D(gRectangle.left, gRectangle.top, 0.0), new GPoint3D(gRectangle.right, gRectangle.top, 0.0), new GPoint3D(gRectangle.right, gRectangle.bottom, 0.0), new GPoint3D(gRectangle.left, gRectangle.bottom, 0.0)};
        int n = 0;
        while (n < 4) {
            gPoint3DArray[n] = this.project(gPoint3DArray[n]);
            ++n;
        }
        GRectangle gRectangle2 = new GRectangle();
        int n2 = 0;
        while (n2 < 4) {
            gRectangle2.left = Math.min(gRectangle2.left, gPoint3DArray[n2].X);
            gRectangle2.right = Math.max(gRectangle2.right, gPoint3DArray[n2].X);
            gRectangle2.bottom = Math.min(gRectangle2.bottom, gPoint3DArray[n2].Y);
            gRectangle2.top = Math.max(gRectangle2.top, gPoint3DArray[n2].Y);
            ++n2;
        }
        return gRectangle2;
    }

    public void revolve(int n, GPoint3D gPoint3D) {
        this.matrix = GMath.revolve(this.matrix, n, gPoint3D);
    }
}

