
   Lesson 3: Dot commands

In WinWord-like wordprocessors, formatting information is held in the document 
file in binary (not text) format. Opening such a document with an ASCII editor 
produces sections containing normal text and others - the binary parts - 
containing nonsense (the binary sections). Write&Set stores the formatting 
information in dot commands which are part of the normal ASCII text. There are 
two different kinds of formatting information: print characters, which were 
discussed in Lesson 2, and dot commands.

A dot command must be inserted on a line separate from the text and must begin 
with a dot (i.e., a period) in the leftmost margin (i.e., in column 1). In 
most cases, the dot is followed by two characters which are not 
case-sensitive. Many dot commands require a following argument. For example:

.RM50

This dot command refers to the formatting process 
and sets the right margin to the value 50. You are 
allowed to enter spaces between "RM" and the 
number. If the line does not begin with a dot in 
the first column, the line will be printed as if 
it were part of the text; for example:

  .RM70

You should format and preview the file to see the 
result.

Dot commands are shown highlighted in WSedit. 
Nevertheless, dot commands consist of normal 
characters, and you can use the normal 
search/replace procedures to find and modify dot 
commands.

Not all dot commands require a parameter value. 
For example, the Page command inserts a page 
break.

.PA

A very useful dot command is the use of two dots, 
in columns 1 and 2; for example:

..comment this won't be printed!

With the "dot dot" dot command, you can write 
comments which won't be considered part of the 
text and won't be previewed and printed. WSedit 
shows these comment lines in magenta color.

Other useful dot commands follow.

.LH8
line height sets the line height to 8/48 inches. 
This is the default linespacing of a conventional 
typewriter.

.LH12
means 150% of the default typewriter 
linespacing.

.LH10
The default values after installing WSedit and 
WSformat is ".LH10" for both programs. ".LH10" is 
a good choice for Times Roman 12 or Helvetica 
12.

Measurement of values in dot commands

Many dot commands express horizontal or vertical 
distances on the printed page.

The default horizontal spacing on a page is 
specified as the spacing of a 12 point Courier 
font, and the default vertical spacing is ".LH8". 
Both directions refer to the columns and lines of 
old typewriters. A character is considered to be 
as wide as a "Courier 12" character - the only 
font that most typewriters used; and the vertical 
measurement is the default for single-spaced 
lines. WSformat assumes 1/48 inches, so ".LH8" 
(line height) indicates a line spacing of 8/48 
inch or 6 lines per inch.

All dot commands which allow character or line 
counts to indicate distances will also accept 
inches and centimeters.  If there are 10 
horizontal characters per inch:

.RM 70       (indicating 70 typewriter spaces)

and is equivalent to

.RM 7.0"     (indicating 7.0 inches)

and

.RM 17.8     (indicating 17.8 cm)

One inch is the same as 2.54 cm.

How to find the desired dot command

In the WSformat menu bar, you will find an item 
"Command". The "Insert Dot Commands" window opens 
which helps you locate all existing dot commands. 
Press the "?" button to learn more about this 
useful dialog window.

With this window, you do not need to know the name 
or syntax of the dot commands in order to use 
them.

For example, to insert a line which is shown on 
top of every page ("header line"), do the 
following:

(It is required that both WSformat and WSedit are 
running and the document is already selected in 
WSformat.)

- click "Command" in the WSformat menu bar
- open the subtree "Page Formatting" (click to the 
"plus" sign)  if not open already
- open the subtree "Header and Footer Lines"
- click to "Header Line (.HE)" and you will see a 
short description
- push the "Insert" button
- the titlebar in WSedit shows the following text: 
"Enter the text here which shall occur at the top 
of every page"
- type the header line text at the cursor position 
in WSedit, e.g. "Lesson 2".

Preview and Print shows the header line on each 
page.

If you already have a WS file containing dot 
commands, move the mouse cursor over the dot 
command and you will get a short description. If 
WSformat is running, Double-clicking the dot 
command in the WSedit window opens the WSformat 
"command dialog" with the current dot command.

The Write&Set archive has a directory "DocuSrc", 
containing the WS source file of the WSedit and 
WSformat online help. These WS files contain many 
dot commands.

Default values of dot commands

Every dot command which requires a parameter has a 
default value which is valid before inserting the 
specific dot command. Some of these default values 
cannot be changed, but others can be changed in 
the WSformat settings notebook. To activate the 
settings notebook, click on the WSformat menu item 
"Settings", then on "Settings Notebook". The pages 
"Format" and "Layout" show the dot command default 
values. On the "Layout" page, all vertical values 
refer to lines and all horizontal values to 
characters. If you want so see the values in cm or 
inches, select the radiobox "scale for bubble 
hint" and move the mouse over the edit field with 
the value. Moving the mouse over a dot command let 
you show a bubble help window with a short 
explanation.