/*
 * Decompiled with CFR 0.152.
 */
package com.jshift.ccu.vbDotNet;

import com.jshift.ccu.Attribute;
import com.jshift.ccu.CcuType;
import com.jshift.ccu.Entity;
import com.jshift.ccu.ExtrapolationParameters;
import com.jshift.ccu.IZ;
import com.jshift.ccu.SI;
import com.jshift.ccu.util.LinePrefixer;
import com.jshift.ccu.vbDotNet.C;
import com.jshift.ccu.vbDotNet.I;
import com.jshift.ccu.vbDotNet.VbDotNetAttributeMgrStruct;
import com.jshift.ccu.vbDotNet.VbDotNetEntityMgr;
import com.jshift.ccu.vbDotNet.Z;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

public class VbDotNetAttributeMgr
extends VbDotNetAttributeMgrStruct {
    public static final Set ATTRIBUTE_MODIFIERS = new TreeSet(VbDotNetEntityMgr.MODIFIERS);
    public static final Set MEMBER_VAR_MODIFIERS;
    public static final Set DECLARATION_MODIFIERS;
    public static final Set ACCESSOR_MODIFIERS;
    public static final Set MUTATOR_MODIFIERS;
    private static final Set MODIFIERS;
    private static final Set STANDARD_CLASSES;

    public VbDotNetAttributeMgr(Attribute attribute) {
        super(attribute);
        this.getConditionalValues().put("explicitModifiers", new I(this));
        this.getConditionalValues().put("modifiers", new Z(this));
        this.appendConditionalVal("explicitCode", new C(this));
    }

    public final String getLang() {
        return IZ.VB_DOT_NET_STR;
    }

    public final byte getNameConversionOptions() {
        return 10;
    }

    public final String getInternalName(ExtrapolationParameters extrapolationParameters) {
        String string = this.getName(extrapolationParameters);
        Set set = this.getModifiers(extrapolationParameters);
        if (set.contains("MustOverride")) {
            return null;
        }
        return "_" + Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public final Set getModifiers(ExtrapolationParameters extrapolationParameters) {
        if (this.isExplicitModifiers()) {
            return this.getModifiers();
        }
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList("Public"));
        Enumeration enumeration = this.getElement().getManagers().elements();
        while (enumeration.hasMoreElements()) {
            SI sI;
            try {
                sI = (SI)enumeration.nextElement();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!sI.isExplicitModifiers()) continue;
            if (sI.isExplicitFullyAccessible() || sI.isExplicitNamespaceAccessible() || sI.isExplicitSubclassAccessible()) {
                if (sI.isFullyAccessible(extrapolationParameters)) {
                    treeSet.add("Public");
                    treeSet.remove("Protected");
                    treeSet.remove("Private");
                    treeSet.remove("Friend");
                } else if (sI.isSubclassAccessible(extrapolationParameters) || sI.isNamespaceAccessible(extrapolationParameters)) {
                    treeSet.add("Protected");
                    treeSet.remove("Public");
                    treeSet.remove("Private");
                    treeSet.remove("Friend");
                } else {
                    treeSet.add("Private");
                    treeSet.remove("Public");
                    treeSet.remove("Protected");
                    treeSet.remove("Friend");
                }
            }
            if (sI.isExplicitShared()) {
                if (sI.isShared(extrapolationParameters)) {
                    treeSet.add("Shared");
                } else {
                    treeSet.remove("Shared");
                }
            }
            if (sI.isExplicitAbstract()) {
                if (sI.isAbstract(extrapolationParameters)) {
                    treeSet.add("MustInherit");
                } else {
                    treeSet.remove("MustInherit");
                }
            }
            if (!sI.isExplicitFinal()) break;
            if (sI.isFinal(extrapolationParameters)) {
                treeSet.add("NotInheritable");
                break;
            }
            treeSet.remove("NotInheritable");
            break;
        }
        return treeSet;
    }

    public final String getCode(ExtrapolationParameters extrapolationParameters) {
        String string;
        String string2;
        if (this.isExplicitCode()) {
            return this.getCode();
        }
        String string3 = this.getLineSeparator(extrapolationParameters);
        String string4 = this.getIndentStr(extrapolationParameters);
        String string5 = this.getName(extrapolationParameters);
        String string6 = this.getInternalName(extrapolationParameters);
        String string7 = this.className(extrapolationParameters);
        CcuType ccuType = this.getType(extrapolationParameters);
        CcuType ccuType2 = this.getMasterEquivalentType(extrapolationParameters);
        Set set = this.getModifiers(extrapolationParameters);
        TreeSet<String> treeSet = new TreeSet<String>(set);
        treeSet.retainAll(MEMBER_VAR_MODIFIERS);
        treeSet.add("Private");
        TreeSet treeSet2 = new TreeSet(set);
        treeSet2.retainAll(DECLARATION_MODIFIERS);
        TreeSet treeSet3 = new TreeSet(set);
        treeSet3.retainAll(ACCESSOR_MODIFIERS);
        TreeSet treeSet4 = new TreeSet(set);
        treeSet4.retainAll(MUTATOR_MODIFIERS);
        String string8 = "";
        if (this.getComment(extrapolationParameters) != null) {
            string8 = string8 + LinePrefixer.prefix(this.getComment(extrapolationParameters) + string3, " ' ", string3);
        }
        if (!set.contains("MustOverride")) {
            string8 = string8 + "Dim " + IZ.expandGroup(treeSet, null, "", " ", "") + ' ' + string6 + " As " + string7;
            if (this.getDefaultVal(extrapolationParameters) != null) {
                string2 = "";
                string = "";
                Object var17_17 = null;
                if (STANDARD_CLASSES.contains(ccuType.getVal())) {
                    string2 = "\"";
                    string = string2 + " C";
                } else if (MODIFIERS.contains(ccuType.getVal())) {
                    string = string2 = "\"";
                } else if ("Date".equals(ccuType2.getVal())) {
                    string2 = "# ";
                    string = " #";
                }
                string8 = string8 + " = " + string2 + this.getDefaultVal(extrapolationParameters) + string;
            }
            string8 = string8 + "\r\n";
        }
        string2 = "";
        string2 = string2 + IZ.expandGroup(treeSet3, null, "", " ", "") + (treeSet3.size() == 0 ? "" : " ") + string7 + " Get" + string3;
        string2 = string2 + LinePrefixer.prefix("Return " + string6 + string3, string4, string3);
        string2 = string2 + "End Get" + string3;
        if (!set.contains("ReadOnly")) {
            string2 = string2 + IZ.expandGroup(treeSet4, null, "", " ", "") + (treeSet4.size() == 0 ? "" : " ") + "Set(ByVal " + "Value" + " As " + string7 + ')' + string3;
            string = this.getValidationCode(extrapolationParameters);
            if (string != null) {
                string2 = string2 + LinePrefixer.prefix(string, string4, string3);
            }
            string2 = string2 + LinePrefixer.prefix(string6 + " = " + "Value" + string3, string4, string3);
            string2 = string2 + "End Set" + string3;
        }
        string8 = string8 + IZ.expandGroup(treeSet2, null, "", " ", "") + (treeSet2.size() == 0 ? "" : " ") + "Property " + string5 + "() As " + string7 + string3 + LinePrefixer.prefix(string2, string4, string3) + "End Property" + string3;
        return string8;
    }

    private final String getValidationCode(ExtrapolationParameters extrapolationParameters) {
        String string;
        Object object;
        String string2 = this.getInternalName(extrapolationParameters);
        String string3 = this.getLineSeparator(extrapolationParameters);
        String string4 = this.getIndentStr(extrapolationParameters);
        CcuType ccuType = this.getType(extrapolationParameters);
        boolean bl = this.isNullable(extrapolationParameters);
        String string5 = "";
        if (!bl) {
            string5 = string5 + "If Value Is Null Then Throw New System.ArgumentNullException(\"" + string2 + "\")" + string3;
        }
        Object object2 = this.getMin(extrapolationParameters);
        Object object3 = this.getMax(extrapolationParameters);
        if (!(object2 == null && object3 == null || ccuType.getArrayDepth() <= 1 && STANDARD_CLASSES.contains(ccuType.getVal()))) {
            object = new Vector(2);
            string = null;
            boolean bl2 = this.isInclusiveMin(extrapolationParameters);
            boolean bl3 = this.isInclusiveMax(extrapolationParameters);
            if (this.minMaxEqualAndNotNull(extrapolationParameters)) {
                ((Vector)object).add("Value" + (ccuType.getArrayDepth() > 0 || MODIFIERS.contains(ccuType.getVal()) ? ".Length" : "") + " <> " + (object2 instanceof Date ? "New Date(\"" + object2 + "\")" : object2));
                string = "equal to " + object2;
            } else {
                if (object2 != null) {
                    ((Vector)object).add("Value" + (ccuType.getArrayDepth() > 0 || MODIFIERS.contains(ccuType.getVal()) ? ".Length" : "") + " <" + (bl2 ? "" : "=") + " " + (object2 instanceof Date ? "New Date(\"" + object2 + "\")" : object2));
                }
                if (this.getMax(extrapolationParameters) != null) {
                    ((Vector)object).add("Value" + (ccuType.getArrayDepth() > 0 || MODIFIERS.contains(ccuType.getVal()) ? ".Length" : "") + " >" + (bl3 ? "" : "=") + ' ' + (object3 instanceof Date ? "New Date(\"" + object3 + "\")" : object3));
                }
            }
            String string6 = "";
            int n = 0;
            while (n < ((Vector)object).size()) {
                if (n != 0) {
                    string6 = string6 + " OrElse ";
                }
                string6 = string6 + ((Vector)object).elementAt(n);
                n = (byte)(n + 1);
            }
            if (string == null) {
                string = ((Vector)object).size() == 2 ? "between " + object2 + " and " + object3 : (object2 != null ? "greater than " + (bl2 ? "or equal to " : "") + object2 : "less than " + (bl3 ? "or equal to " : "") + object3);
            }
            if (bl && ((Vector)object).size() > 0) {
                string6 = "Value Is Not Null AndAlso " + (((Vector)object).size() > 1 ? "(" : "") + string6 + (((Vector)object).size() > 1 ? ")" : "");
            }
            if (((Vector)object).size() > 0) {
                string5 = string5 + "If " + string6 + " Then" + string3 + LinePrefixer.prefix("Throw New System.ArgumentOutOfRangeException(\"Must be " + string + ".\", \"" + string2 + "\")" + string3, string4, string3) + "End If" + string3;
            }
        }
        if (this.getFormat(extrapolationParameters) != null && MODIFIERS.contains(ccuType.getVal()) && ccuType.getArrayDepth() == 0) {
            object = ((Pattern)this.getFormat(extrapolationParameters)).pattern();
            string = "Not RegEx.IsMatch(Value, \"" + (String)object + "\")";
            if (bl) {
                string = "Value Is Not Null AndAlso " + string;
            }
            string5 = string5 + "If " + string + " Then" + string3 + LinePrefixer.prefix("Throw New System.ArgumentException(\"Must match RegEx.\", \"" + string2 + "\")" + string3, string4, string3) + "End If" + string3;
        }
        return "".equals(string5) ? null : string5;
    }

    final boolean isUseableForEquals(ExtrapolationParameters extrapolationParameters) {
        return VbDotNetEntityMgr.STANDARD_CLASSES.contains(this.getType(extrapolationParameters).getVal());
    }

    public final String getEqualsCode(ExtrapolationParameters extrapolationParameters) {
        String string = this.getInternalName(extrapolationParameters);
        String string2 = "";
        if (!this.isUseableForEquals(extrapolationParameters)) {
            string2 = "' ";
        }
        string2 = string2 + "Object.Equals(" + string + ", " + "testVal" + '.' + string + ')';
        return string2;
    }

    public final String getHashingCode(ExtrapolationParameters extrapolationParameters) {
        String string = this.getInternalName(extrapolationParameters);
        String string2 = this.getLineSeparator(extrapolationParameters);
        String string3 = this.getIndentStr(extrapolationParameters);
        String string4 = "retVal *= " + extrapolationParameters.getEntity().getMgr(this.getLang()).getPreference("Hash Multiplier", extrapolationParameters) + string2;
        string4 = string4 + "retVal += IIf(" + string + " Is Null, 0, " + this.getInternalName(extrapolationParameters) + ".HashCode())" + string2;
        return this.isUseableForEquals(extrapolationParameters) ? string4 : LinePrefixer.prefix(string4, "' ", string2);
    }

    private final boolean isUseableForCopyTo(ExtrapolationParameters extrapolationParameters) {
        return !this.getModifiers(extrapolationParameters).contains("ReadOnly") && !this.getModifiers(extrapolationParameters).contains("Shared");
    }

    public final String className(ExtrapolationParameters extrapolationParameters) {
        CcuType ccuType = this.getType(extrapolationParameters);
        if (ccuType.getVal() instanceof Entity) {
            return ((Entity)ccuType.getVal()).getMgr(this.getLang()).getName(extrapolationParameters) + VbDotNetAttributeMgr.buildArraySuffix(ccuType);
        }
        return (String)ccuType.getVal() + VbDotNetAttributeMgr.buildArraySuffix(ccuType);
    }

    public static final String buildArraySuffix(CcuType ccuType) {
        String string = "";
        int n = 1;
        while (n < ccuType.getArrayDepth()) {
            string = string + ',';
            ++n;
        }
        if (ccuType.getArrayDepth() > 0) {
            string = '(' + string + ')';
        }
        return string;
    }

    public final boolean isExplicitSubclassAccessible() {
        return this.isExplicitModifiers();
    }

    public final boolean isSubclassAccessible(ExtrapolationParameters extrapolationParameters) {
        return !this.getModifiers(extrapolationParameters).contains("Private");
    }

    public final boolean isExplicitFullyAccessible() {
        return this.isExplicitModifiers();
    }

    public final boolean isFullyAccessible(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("Public");
    }

    public final boolean isExplicitNamespaceAccessible() {
        return this.isExplicitModifiers();
    }

    public final boolean isNamespaceAccessible(ExtrapolationParameters extrapolationParameters) {
        return !this.getModifiers(extrapolationParameters).contains("Private");
    }

    public final boolean isExplicitShared() {
        return this.isExplicitModifiers();
    }

    public final boolean isShared(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("Shared");
    }

    public final boolean isExplicitAbstract() {
        return this.isExplicitModifiers();
    }

    public final boolean isAbstract(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("MustInherit");
    }

    public final boolean isExplicitFinal() {
        return this.isExplicitModifiers();
    }

    public final boolean isFinal(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("NotInheritable");
    }

    public final boolean isExplicitReadOnly() {
        return this.isExplicitModifiers();
    }

    public final boolean isReadOnly(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("ReadOnly");
    }

    public final boolean isExplicitWriteOnly() {
        return this.isExplicitModifiers();
    }

    public final boolean isWriteOnly(ExtrapolationParameters extrapolationParameters) {
        return this.getModifiers(extrapolationParameters).contains("WriteOnly");
    }

    static {
        ATTRIBUTE_MODIFIERS.remove("NotInheritable");
        ATTRIBUTE_MODIFIERS.remove("MustInherit");
        MEMBER_VAR_MODIFIERS = new TreeSet(ATTRIBUTE_MODIFIERS);
        MEMBER_VAR_MODIFIERS.remove("ReadOnly");
        MEMBER_VAR_MODIFIERS.remove("Public");
        MEMBER_VAR_MODIFIERS.remove("Protected");
        MEMBER_VAR_MODIFIERS.remove("Friend");
        DECLARATION_MODIFIERS = new TreeSet(ATTRIBUTE_MODIFIERS);
        ACCESSOR_MODIFIERS = new TreeSet(ATTRIBUTE_MODIFIERS);
        MUTATOR_MODIFIERS = ACCESSOR_MODIFIERS;
        MODIFIERS = new HashSet<String>(Arrays.asList("String", "System.String"));
        STANDARD_CLASSES = new HashSet<String>(Arrays.asList("Character", "System.Character", "Char", "System.Char"));
    }
}

