/*
 * Decompiled with CFR 0.152.
 */
package karl.swing;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class GuiThreadGroup
extends ThreadGroup {
    private static final Map _groups = Collections.synchronizedMap(new HashMap());
    private Component _parent;

    public static synchronized ThreadGroup getInstance(Component parentCmp, ThreadGroup parent, String name) {
        ThreadGroup t = (ThreadGroup)_groups.get(name);
        if (t == null) {
            _groups.put(new GuiThreadGroup(parentCmp, parent, name), name);
        } else if (parent != null) {
            while (parent != null && t.getParent() != parent) {
                parent = parent.getParent();
            }
            if (parent == null) {
                throw new IllegalArgumentException("Bad Parent");
            }
        }
        return t;
    }

    private GuiThreadGroup(Component parentCmp, ThreadGroup parent, String name) {
        super(parent, name);
        this._parent = parentCmp;
    }

    public void uncaughtException(Thread t, Throwable e) {
        GuiThreadGroup.error(this._parent, t, e);
    }

    public static void error(Component parent, Thread t, Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        int i = JOptionPane.showConfirmDialog(parent, String.valueOf(String.valueOf(new StringBuffer("Exception in Thread ").append(t.getName()).append(".\nExit Program?\n\n").append(sw.toString()))), "Unexpected Exception.", 0);
        if (i != 1) {
            System.exit(1);
        }
    }
}

