/*
 * Decompiled with CFR 0.152.
 */
package karl.io;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import java.util.Vector;
import karl.io.DirectoryChangeEvent;
import karl.io.DirectoryChildGroup;
import karl.util.ImmutableCollection;

public class DirectoryNode {
    static final File VIRTUAL_ROOT = new File("/");
    static final long SIZE_UNDESCENDED = Long.MIN_VALUE;
    public static final int MASK_FILE = 1;
    public static final int MASK_HIDDEN = 2;
    public static final int MASK_ALL = 4;
    static final int MASK_MAX = 5;
    private File _base = null;
    private DirectoryNode _cache = null;
    private boolean _cache_is_parent = false;
    private long _self_size = 0L;
    private long _self_size_disk = 0L;
    private long _total_size = Long.MIN_VALUE;
    private long _total_size_disk = Long.MIN_VALUE;
    private boolean _is_link = false;
    private EventListener _listener = null;
    private DirectoryChildGroup[] _childGroups = null;

    public static void main(String[] args) {
        long t0 = System.currentTimeMillis();
        DirectoryNode dn = new DirectoryNode(new File("/"));
        System.out.println(dn.getFile().getAbsolutePath());
        System.out.println(dn.getSize());
        System.out.println(dn);
        System.out.println(dn.getTotalSize());
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Time: ").append(System.currentTimeMillis() - t0).append("ms"))));
    }

    public DirectoryNode(File f) {
        this(f, null);
    }

    public DirectoryNode(File f, DirectoryNode cache) {
        if (f == null) {
            throw new NullPointerException("File cannot be Null");
        }
        this._cache = cache;
        DirectoryNode clone = null;
        if (this._cache != null) {
            clone = this._cache.locateChild(f);
        }
        if (clone != null) {
            if (clone == cache) {
                this._cache = this;
            } else {
                this._cache_is_parent = true;
            }
            this._base = clone._base;
            this._childGroups = clone._childGroups;
            this._self_size = clone._self_size;
            this._self_size_disk = clone._self_size_disk;
            this._total_size = clone._total_size;
            this._total_size_disk = clone._total_size_disk;
        } else {
            this._base = f;
            this._self_size = f.length();
            try {
                if (!f.getAbsolutePath().equals(f.getCanonicalPath())) {
                    this._is_link = true;
                    this._self_size = 0L;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._cache != null && !this.isParent(this._cache.getFile())) {
                this._cache = null;
            }
        }
    }

    private DirectoryNode(File f, DirectoryNode cache, EventListener listener) {
        this._cache = cache;
        this._cache_is_parent = true;
        this._base = f;
        this._listener = listener;
        if (f == null) {
            return;
        }
        this._self_size = f.length();
        try {
            if (!f.getAbsolutePath().equals(f.getCanonicalPath())) {
                this._is_link = true;
                this._self_size = 0L;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Collection getChildren(int groupMask) {
        if (groupMask < 0 || groupMask > 4) {
            return null;
        }
        if (this._total_size == Long.MIN_VALUE) {
            this.walkChildren();
        }
        if (!this._is_link && (this._base == null || this._base.isDirectory())) {
            return new ImmutableCollection(this._childGroups[groupMask].children);
        }
        return new Vector(0);
    }

    public long getChildrenSize(int groupMask) {
        if (groupMask < 0 || groupMask > 4) {
            return 0L;
        }
        if (this._total_size == Long.MIN_VALUE) {
            this.walkChildren();
        }
        if (this._base.isDirectory()) {
            return this._childGroups[groupMask].total_size;
        }
        return 0L;
    }

    public static String subdirName(String path, int startoffset) {
        int j = startoffset;
        j = path.indexOf(File.separator, startoffset);
        while (j == startoffset) {
            j = path.indexOf(File.separator, ++startoffset);
        }
        if (j < 0) {
            return path.substring(startoffset);
        }
        return path.substring(startoffset, j);
    }

    public boolean isParent(File child) {
        String base;
        if (this._base == null) {
            return true;
        }
        if (child == null || child == VIRTUAL_ROOT) {
            return false;
        }
        if (!this._base.isDirectory()) {
            return false;
        }
        String next = child.getAbsolutePath();
        return next.startsWith(base = this._base.getAbsolutePath());
    }

    public DirectoryNode locateChild(File child) {
        if (!this.isParent(child)) {
            return null;
        }
        if (this._base == child || this._base != null && this._base.equals(child)) {
            return this;
        }
        String next = child.getAbsolutePath();
        String base = this._base == null ? "" : this._base.getAbsolutePath();
        String s = DirectoryNode.subdirName(next, base.length());
        if (this._childGroups == null) {
            this.walkChildren();
        }
        if (this._base == null) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(File.separator)));
        }
        DirectoryNode n = this._childGroups[4].get(s);
        return n.locateChild(child);
    }

    public File getFile() {
        if (this._base == null) {
            return VIRTUAL_ROOT;
        }
        return this._base;
    }

    public DirectoryNode getCache() {
        if (this._cache == null) {
            return this;
        }
        return this._cache;
    }

    public long getSize() {
        return this._self_size;
    }

    public void close() {
        this._total_size = Long.MIN_VALUE;
        this._childGroups = null;
    }

    public String toString() {
        if (this._base == null) {
            return String.valueOf(String.valueOf(new StringBuffer("(virtual root) (").append(this.getTotalSizeH()).append(")")));
        }
        boolean d = this._base.isDirectory();
        boolean h = this._base.isHidden();
        boolean l = this._is_link;
        String cp = "";
        try {
            cp = this._base.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._cache == this || this._base.getParent() == null) {
            if (this._base.getAbsolutePath().endsWith(File.separator)) {
                d = false;
            }
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._base.getAbsolutePath()))).append(d ? File.separator : "").append(h ? " (hidden)" : "").append(" (").append(this.getTotalSizeH()).append(")").append(l ? " -->".concat(String.valueOf(String.valueOf(cp))) : "")));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._base.getName()))).append(d ? File.separator : "").append(h ? " (hidden)" : "").append(" (").append(this.getTotalSizeH()).append(")").append(l ? " -->".concat(String.valueOf(String.valueOf(cp))) : "")));
    }

    public boolean equals(Object o) {
        if (o instanceof File) {
            return this.getFile().equals(o);
        }
        if (o instanceof DirectoryNode) {
            return this.getFile().equals(((DirectoryNode)o).getFile());
        }
        return false;
    }

    public long getTotalSize() {
        if (this._total_size == Long.MIN_VALUE) {
            this.walkChildren();
        }
        return this._total_size;
    }

    public String getTotalSizeH() {
        return DirectoryNode.sizeToSizeH(this.getTotalSize());
    }

    public static String sizeToSizeH(long s) {
        if (s < 1024L) {
            return String.valueOf(String.valueOf(s)).concat("");
        }
        if (s < 0x100000L) {
            return String.valueOf(String.valueOf((double)Math.round((double)s / 102.4) / 10.0)).concat(" k");
        }
        if (s < 0x40000000L) {
            return String.valueOf(String.valueOf((double)Math.round((double)(s >> 10) / 10.24) / 100.0)).concat(" M");
        }
        if (s < 0x10000000000L) {
            return String.valueOf(String.valueOf((double)Math.round((double)(s >> 20) / 10.24) / 100.0)).concat(" G");
        }
        return String.valueOf(String.valueOf(s >> 30)).concat(" G");
    }

    public void setEventListener(EventListener d) {
        this._listener = d;
    }

    public static DirectoryNode[] getRoots(DirectoryNode cache) {
        File[] roots = File.listRoots();
        DirectoryNode[] dirs = new DirectoryNode[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            dirs[i] = new DirectoryNode(roots[i], cache);
        }
        return dirs;
    }

    public DirectoryNode getRootNode() {
        if (this._cache._base == null) {
            return this._cache;
        }
        DirectoryNode[] roots = DirectoryNode.getRoots(this._cache);
        if (roots.length == 1) {
            return roots[0];
        }
        DirectoryNode rootNode = new DirectoryNode(null, this._cache, this._listener);
        rootNode._cache_is_parent = false;
        rootNode._self_size = 0L;
        return rootNode;
    }

    public DirectoryNode getParent() {
        if (this._base.getParent() == null) {
            return this.getRootNode();
        }
        return new DirectoryNode(this._base.getParentFile(), this.getCache());
    }

    public DirectoryNode getNextSibling(int mask1, int mask2, EventListener listener) {
        if (mask2 < 0) {
            mask2 = mask1;
        }
        DirectoryNode n = this.getParent();
        n.setEventListener(listener);
        int mask = mask1;
        if (n._total_size == Long.MIN_VALUE) {
            n.walkChildren();
        }
        if (n._childGroups == null) {
            return null;
        }
        int me = n._childGroups[mask].children.indexOf(this);
        if (me >= n._childGroups[mask].children.size() - 1) {
            mask = mask2;
            me = -1;
        } else if (me < 0) {
            mask = mask2;
            me = n._childGroups[mask].children.indexOf(this);
            if (me >= n._childGroups[mask].children.size() - 1) {
                mask = mask1;
                me = -1;
            }
        }
        return (DirectoryNode)n._childGroups[mask].children.get(me + 1);
    }

    public DirectoryNode getPreviousSibling(int mask1, int mask2, EventListener listener) {
        if (mask2 < 0) {
            mask2 = mask1;
        }
        DirectoryNode n = this.getParent();
        n.setEventListener(listener);
        int mask = mask2;
        if (n._total_size == Long.MIN_VALUE) {
            n.walkChildren();
        }
        if (n._childGroups == null) {
            return null;
        }
        int me = n._childGroups[mask].children.indexOf(this);
        if (me == 0) {
            mask = mask1;
            me = n._childGroups[mask].children.size();
        } else if (me < 0) {
            mask = mask1;
            me = n._childGroups[mask].children.indexOf(this);
            if (me <= 0) {
                mask = mask2;
                me = n._childGroups[mask].children.size();
            }
        }
        return (DirectoryNode)n._childGroups[mask].children.get(me - 1);
    }

    public DirectoryNode getFirstChild(int mask1, int mask2, EventListener listener) {
        this._listener = listener;
        if (this._total_size == Long.MIN_VALUE) {
            this.walkChildren();
        }
        if (this._childGroups == null) {
            return null;
        }
        return (DirectoryNode)this._childGroups[mask1].children.get(0);
    }

    private void setupChildGroups() {
        this._childGroups = new DirectoryChildGroup[5];
        for (int i = 0; i < 5; ++i) {
            this._childGroups[i] = new DirectoryChildGroup(i);
        }
    }

    private void walkChildren() {
        this._total_size = 0L;
        if (this._is_link) {
            return;
        }
        if (this._base == null) {
            this.setupChildGroups();
            DirectoryNode[] roots = DirectoryNode.getRoots(this._cache);
            for (int i = 0; i < roots.length; ++i) {
                roots[i].setEventListener(this._listener);
                this.addChild(roots[i]);
            }
            this._total_size += this._childGroups[4].total_size;
            if (this._listener != null) {
                this._listener.event(new DirectoryChangeEvent(this));
            }
        } else if (this._base.isDirectory()) {
            this.setupChildGroups();
            File[] children = this._base.listFiles();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                if (this._cache != null && this._cache.getFile().equals(children[i])) {
                    this.addChild(this._cache);
                    continue;
                }
                DirectoryNode n = new DirectoryNode(children[i], this._cache, this._listener);
                this.addChild(n);
            }
            this._total_size += this._childGroups[4].total_size;
            if (this._listener != null) {
                this._listener.event(new DirectoryChangeEvent(this));
            }
        } else {
            this._total_size = this._self_size;
        }
        Thread.yield();
        if (!this._cache_is_parent) {
            if (this._cache != null) {
                this._cache._cache = this;
            }
            this._cache = this;
        }
    }

    private void addChild(DirectoryNode f) {
        for (int i = 0; i < 5; ++i) {
            this._childGroups[i].add(f);
        }
    }

    static {
        SIZE_UNDESCENDED = Long.MIN_VALUE;
        MASK_FILE = 1;
        MASK_HIDDEN = 2;
        MASK_ALL = 4;
        MASK_MAX = 5;
    }

    public static interface EventListener
    extends java.util.EventListener {
        public void event(EventObject var1);
    }
}

