/*
 * Decompiled with CFR 0.152.
 */
package karl.io;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import karl.io.DirectoryNode;

class DirectoryChildGroup {
    public int stat = 0;
    public long aggregate_size = 0L;
    public long total_size = 0L;
    public Vector children = new Vector(10, 100);

    public DirectoryChildGroup(int stat) {
        this.stat = stat;
    }

    public boolean add(DirectoryNode f) {
        if (this.stat != 4) {
            if ((this.stat & 1) == 0 ^ f.getFile().isDirectory()) {
                return false;
            }
            if ((this.stat & 2) != 0 ^ f.getFile().isHidden()) {
                return false;
            }
        }
        this.children.add(f);
        this.aggregate_size += f.getSize();
        this.total_size += f.getTotalSize();
        return true;
    }

    public DirectoryNode get(String name) {
        Iterator i = ((AbstractList)this.children).iterator();
        while (i.hasNext()) {
            DirectoryNode n = (DirectoryNode)i.next();
            if (n.getFile().getName().equals(name)) {
                return n;
            }
            if (!n.getFile().getAbsolutePath().equals(name)) continue;
            return n;
        }
        return null;
    }
}

