#ifndef _STICKY_HEADER
#define _STICKY_HEADER

#include "resource.h"
#include <windows.h>

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// Sub-class structure to save information about each sub-class instance
typedef struct SCI
{
    int        stickyIdx;
    HWND       hOwnerWnd;
    WNDPROC    pOrigSubclassProc;
} SubClassInfo;

// Preferences colour quick scheme array struct
struct ColScheme
{
    COLORREF textCol;
    COLORREF backCol;
    COLORREF alarmCol;
};

// Sticky record array structure definitions.
struct StringRec
{
    int   strLen;
    char* pString;
};

struct Alarm
{
#define ALRMINIT  -2
#define ALRMEVERY (~0)
    int           year, month;
    unsigned int  day;
    int           hour, minute, AMPM;                     // am = 0, pm = 1;
    int           alarmSndRpt;
    BOOL          LoopPlayback;
    BOOL          alarmEnabled;
    BOOL          weekDayTest;      // Determine if alarm is to go off next/current week day
    BOOL          everyDayTest;     // Determine if alarm is be repeated after the event

// Alarm blinking of sticky notes...
#define ALARMBACKG  RGB (255, 0, 0)               // default blinking colour.
    COLORREF alarmBlinkCol;                       // colour of the sticky that will blink.
    BOOL     alarmBlinking;                       // allow blinking of sticky?
    BOOL     alarmBlinker;                        // used to test when sticky is activated
                                                  // after an alarm.
    BOOL     alarmSndThread;                      // used in playback of sound file in thread.
    BOOL     alarmDlgThread;                      // used to determine if alarm dialog is active, this
                                                  // variable is set upon alarm dialog displaying and
                                                  // set to false upon load Sticky.
};

struct StickyRec
{
    RECT      winDim;
    RECT      unrolledDim;
    BOOL      unrolledDimInit;
    RECT      rolledDim;
    BOOL      rolledDimInit;

    // Colour definition for window
    COLORREF  textCol;
    COLORREF  backCol;
    HBRUSH    backGH;

    // Window State Variables.
    BOOL      rolledUp;
    BOOL      minimised;
    BOOL      restored;
    int       winShowState;
    BOOL      topMostWin;
    BOOL      vScrollBar;
    BOOL      hScrollBar;    
    BOOL      thinEdge;
    BOOL      calculatorMode;

    StringRec userMemo;
    BOOL      wordWrapped;
    HWND      stickyWnd;
    HWND      editControl;

    // Font info for a given sticky edit control
    LOGFONT   editFont;
    HFONT     hFont;

    // Font to describe sticky title
    LOGFONT   titleFont;

    // ***** Sticky Window Caption ******
#define CAPTIONSIZE  50                           // Windows Caption Size
    char     winCaption[CAPTIONSIZE+1];           // 51 is the default Sticky preferences
    Alarm    stickyAlrm;                          // Alarm information.
};

// ----------------------------------------------------------------------------
// ---------------- Global variable accessed in more than 1 file --------------
// ----------------------------------------------------------------------------

// Actual Sticky record array
#define   STICKRECNUM  50
extern    StickyRec    StickyRecords[STICKRECNUM+1];

// Preferences quick colour scheme array
#define   MAXCOLSCHEMENUM 50
extern    ColScheme ColourSchemes[MAXCOLSCHEMENUM];

// Program running globals
extern    HWND         ParentStarter;       // Main Sticky Window, situated in the system tray
extern    HANDLE       HInst;               // Handle to current program instance

// Global preferences variables.
extern    BOOL         AutoTextCopy;        // Automatically copy text after selection in edit control
extern    BOOL         LatchActive;         // Latch to the next window 
extern    int          LatchPixelRange;    
extern    BOOL         MAPIActive;          // Mail-to option available ?
extern    BOOL         SoundActive;         // Sound on or off

// Sound file locations
#define   MAXSNDFILELEN  MAX_PATH
extern    char         RollupSnd[MAXSNDFILELEN];
extern    char         UnrollSnd[MAXSNDFILELEN];
extern    char         AlarmSnd[MAXSNDFILELEN];

// ----------------------------------------------------------------------------
// ------------------ Popmenu Global Contants and Sting -----------------------
// ----------------------------------------------------------------------------

// Popup-menu IDS are in popupmenu.h                 
#include "popupmenu.h"   // these ids are used in the resource compiler for accelerators

// Custom menu constant strings
#define STRNEWSTICKYMAINWIN "New Sticky"
#define STRNEWSTICKY        "&New Sticky\tAlt+N"
#define STRROLLUP           "Roll Sticky\tAlt+Z"
#define STRUNROLL           "UnRoll Sticky\tAlt+Z"
#define STRSETTITLE         "Set Sticky &Title\tAlt+T"
#define STRPREFS            "&Preferences\tAlt+P"
#define STRSETTOPMOST       "Always On Top\tAlt+V"
#define STRSETALARM         "Set &Alarm\tAlt+A"
#define STRPRINTSTICKY      "Print &Sticky\tAlt+S"
#define STRCLOSESTICKY      "&Close Sticky\tAlt+F4"
#define STRABOUT            "About Stickies"
#define STRQUITSTICKIES     "Quit Stickies"
#define STRLEAVEMENU        "Leave Menu"

#define STRDEFSTICKIESPREFS "Sticky Default Prefs"
#define STREXPORTSTICKY     "E&xport Sticky\tAlt+X"
#define STRIMPORTSTICKY     "Import Sticky\tAlt+I"
#define STREXPORTIMPORT     "Export/Import"
#define STRMAKEASDEFAULT    "Make As &Default Style\tAlt+D"

#define STRCALSUBMENU       "Calculator"
#define STRCALMODEONOFF     "Calc Mode On/Off\tAlt+C"
#define STRCALSELECTION     "Calc Selection\tAlt+Enter"

// Sticky find submenu
#define STRFINDSUBMENU      "Find Utils"
#define STRFINDTEXT         "&Find Text\tAlt+F"
#define STRFINDREPLACE      "Find &Replace Text\tAlt+R"

// Sticky mail submenu
#define STRMAILTOSUBMENU    "Mail To ..."
#define STRMAILTONOINSTALL  "No Sticky Installer\tAlt+Q"
#define STRMAILTOINSTALL    "With Sticky Installer\tAlt+W"

// Stickies utils submenu
#define STRUTILSSUBMENU     "Stickies Utils"
#define STRIMPORTSTICKYMAIN "Import Sticky"
#define STRNUKEALLSTICKIES  "Nuke All Stickies"
#define STRREALIGNSTICKIES  "Re-Align Stickies"
#define STRSAVESTICKIES     "Save Stickies Now!"
#define STRHELPME           "Help Me..."

// Icon identifer within the system tray area
#define   TRAY_ICON        0
#define   MYWM_NOTIFYICON  (WM_APP+100)

// *** File names ***
#define STRSTICKYRECORDS    "sticky.rec"
#define STRSTICKYSTRINGS    "sticky.str"
#define STRROLLUPSND        "rollup.wav"
#define STRUNROLLSND        "unroll.wav"
#define STRALARMSND         "alarm.wav"
#define STRSTICKYHELP       "stickies.hlp"

// Window class name
#define STRWINSTICKYCLASS   "Sticky Class"
#define STRWINAPPNAMECLASS  "Stickies"

// Registry Profile Strings
#define REGOPENLOC    "software\\De Toni Ware"
#define REGMISCINFO   "Sticky Info"
#define REGROLLUPWAVE "Rollup Wave"
#define REGUNROLLWAVE "Unroll Wave"
#define REGALARMWAVE  "Alarm Wave"


// ----------------------------------------------------------------------------
// ---------------------------- Window Prototypes -----------------------------
// ----------------------------------------------------------------------------

int   WINAPI   MainWindow       (HWND, UINT, UINT, LONG);
int   WINAPI   Sticky           (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
int   CALLBACK SubClassEditCntl (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL  CALLBACK StickyPrefs      (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL  CALLBACK StickyTitle      (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL  CALLBACK AboutDialog      (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL  CALLBACK DragDropQuery    (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
BOOL  CALLBACK StickyPrefs      (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

// ----------------------------- Generic Program ------------------------------

void loadMainStickyPrefs     (void);
void SaveMainStickyPrefs     (void);
void InitStickyRecords       (void);
int  GetNextStickyFree       (void);
HWND GetStickyEditControl    (HWND Owner);
int  GetWndIdx               (HWND Owner);
void SaveStickyWinPos        (int idx);
void StoreStickyData         (int idx);
void NukeRec                 (HWND Owner);
void CleanUp                 (void);
int  LoadSticky              (HWND hWnd, int idx, BOOL initAlarmInfo);
int  NewSticky               (HWND hWnd);
int  LoadStickyFromFile      ();
int  SaveStickyToFile        ();
void ProcessDragDropFiles    (WPARAM wParam, int mode, int wndIdx);
BOOL FontChooseFont          (HWND hwnd, LOGFONT& logfont);
void FontSetFont             (HWND hwndEdit, LOGFONT& logfont, HFONT& hFont);
BOOL pickColour              (HWND hwnd, COLORREF* pRGB);
void MakeDefaults            (void);
int  GetStickyTitleFontHeight(HWND hwnd, int idx);
void PaintStickyPrefsColours (HWND hwnd, COLORREF col);
void SelectSoundFile         (HWND hwnd, char* pSndFile, int buffLen);
void ProcessWindowMoving     (HWND hwnd, LPARAM lParam, POINTS lastLButtonDn);
void SetNULLSForDefaultSticky(void);
void DuplicateSticky         (int srcIdx, int destIdx);

#endif
