
{***************************************************************}
{ VSQL Visual Query Parser v2.0 for Delphi(r) Programmers       }
{ packaged as TBSVSQL Visual Component.                         }
{ Copyright (c) 1998/2000 Business Software                          }
{                    bsoft@totalise.co.uk                      }
{ Source Code Supplied as Registered User Package.              }
{ Form Component 'wrapper' for TBSVsql component in vsql1.pas   }
{***************************************************************}
unit bsvsql1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  DBTables,DB, Controls, Forms, Dialogs,vsql1;

type
  Tbsvsql = class(TComponent)
  private
  FQuery:Tquery;
  FDBComboVisible:boolean;
  FNoOpenQuery:boolean;
  FNoSaveQuery:boolean;
  FNoPath:boolean;
  FReadOnly:boolean;
  FCaption:string;
  FInitialdir:string;
  FLoginPrompt:boolean;
  procedure setquery(value:TQuery);
  function getquery:TQuery;
  procedure setdbcombovisible(value:boolean);
  function getdbcombovisible:boolean;
  procedure setproperties;
  protected
  {}
  public
  function showmodal:boolean;
  procedure show;
  procedure openquery(s:string);
  constructor Create(AOwner: TComponent); override;
  destructor destroy; override;

  published
  property QueryName:TQuery read getquery write setquery;
  property DBComboVisible:boolean read getdbcombovisible write setdbcombovisible;
  property LoginPrompt:boolean read FLoginPrompt write FLoginPrompt;
  property NoOpenQuery:boolean read FNoOpenQuery write FNoOpenQuery;
  property NoSaveQuery:boolean read FNoSaveQuery write FNoSaveQuery;
  property NoPath:boolean read FNoPath write FNoPath;
  property ReadOnly:boolean read FReadOnly write FReadOnly;
  property Caption:string read FCaption write FCaption;
  property InitialDir:string read Finitialdir write finitialdir;
  end;

var vsql:tvsql;


procedure Register;

implementation

procedure Register;
begin
RegisterComponents('BSoft', [Tbsvsql]);
end;


constructor Tbsvsql.create(aOwner:Tcomponent);
begin
inherited create(aowner);
FDBComboVisible:=true;
FCaption:='VSQL: Visual SQL Parser v1.6';
end;


{open as modal style dialog}
function Tbsvsql.showmodal:boolean;
begin
result:=false;
if (queryname=nil) then showmessage('QueryName Property'+#13+'not assigned!') else
   begin
   vsql:=TVSQL.create(application);
       try
       setproperties;
       result:=(vsql.showmodal=mrOK);
       finally
       vsql.free;
       vsql:=nil;
       end;
   end;
end;

{open as non-modal dialog}
procedure TBsvsql.show;
begin
if (queryname=nil) then showmessage('QueryName Property'+#13+'not assigned!') else
  begin
  if (vsql=nil) then  {check if one prepared earlier, if not then create one}
  vsql:=tvsql.create(application); {freed when application closes}
     try
     setproperties;
     vsql.show;
     except
     vsql.free;
     vsql:=nil;
     end;
  end;
end;

procedure TBSvsql.setproperties;
begin
vsql.query:=fquery;
vsql.FDBComboVisible:=fdbcombovisible;
vsql.FNoSaveQuery:=FNoSaveQuery;
vsql.FNoOpenQuery:=FNoOpenQuery;
vsql.FNoPath:=FNoPath;
vsql.ReadOnly1.checked:=FReadOnly;
vsql.FInitialDir:=FInitialDir;
vsql.LoginPrompt1.checked:=FLoginPrompt;
vsql.caption:=FCaption;
end;

procedure TBsVSQL.Openquery(s:string);
begin
vsql.opensqlas(s);
end;

procedure Tbsvsql.setquery(value:TQuery);
begin
fquery:=value;
end;

function Tbsvsql.getquery:TQuery;
begin
result:=fquery;
end;

procedure TBsvsql.setdbcombovisible(value:boolean);
begin
FDBComboVisible:=value;
end;

function Tbsvsql.getdbcombovisible:boolean;
begin
result:=fdbcombovisible;
end;

destructor Tbsvsql.destroy;
begin
{}
inherited destroy;
end;


end.
