unit MainFrm;

interface

{.$DEFINE USEGIFIMAGE} // Use this define, if you want to enable Gif support
                      // with Anders Melander's TGifImage
                      // http://www.melander.dk/delphi/gifimage/
                      // or http://www.torry.net/vcl/graphics/gif/gifimage.exe
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, ShellApi,
  Dialogs, StdCtrls, ComCtrls, RVStyle, RVScroll,
  RichView, RVFuncs, ExtCtrls, RVEdit, CRVFData, RVOfficeCnv

  {$IFDEF USEGIFIMAGE}
  , GifImage
  {$ENDIF}
  ;

type
  TfrmMain = class(TForm)
    od: TOpenDialog;
    rvs: TRVStyle;
    rve: TRichViewEdit;
    Panel1: TPanel;
    btnOpen: TButton;
    rvc: TRVOfficeConverter;
    btnSave: TButton;
    sd: TSaveDialog;
    pb: TProgressBar;
    procedure btnOpenClick(Sender: TObject);
    procedure rvcConverting(Sender: TObject; Percent: Integer);
    procedure btnSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rveReadHyperlink(Sender: TCustomRichView; const Target,
      Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
      ItemTag: Integer; var ItemName: String);
    procedure rveURLNeeded(Sender: TCustomRichView; id: Integer;
      var url: String);
    procedure rveJump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

{====================== Import and export =====================================}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
  od.Filter := 'RTF (Built-In RichView Import)|*.rtf|'+rvc.GetImportFilter;
  sd.Filter := 'RTF (Built-In RichView Export)|*.rtf|'+rvc.GetExportFilter;

  rve.Clear;
  rve.Add('This demo shows how to use Microsoft Office text converters.',0);
  rve.AddNL('First items in filters (file masks) of the file-selection dialogs are RTF import/export '+
            'by the component itself. Others use converters.',0,0);
  rve.AddNL('For HTML import testing, look at test/test.htm.',0,0);
  rve.AddNL('After loading, Ctrl+click any hypertext link to view its target.',0,0);
  rve.AddNL('You''ll see option for HTML export via converters. You can use it, but native RichView HTML'+
            ' export gives much better results.',0,0);  
  rve.Format;
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.btnOpenClick(Sender: TObject);
var r: Boolean;
begin
  if not od.Execute then
    exit;
  rve.Clear;
  rve.Format;
  rve.Update;

  rve.Clear;
  if od.FilterIndex=1 then
    r := rve.LoadRTF(od.FileName)
  else begin
    pb.Visible := True;
    r:= rvc.ImportRV(od.FileName, rve, od.FilterIndex-2);
  end;
  if not r then
    Application.MessageBox('Error','Error',0);
  pb.Visible := False;
  rve.Format;
  rve.SetFocus;
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.btnSaveClick(Sender: TObject);
var r: Boolean;
begin
  if not sd.Execute then
    exit;
  pb.Visible := True;
  if sd.FilterIndex=1 then
    r := rve.SaveRTF(sd.FileName,False)
  else begin
    pb.Visible := True;
    r:= rvc.ExportRV(sd.FileName, rve, sd.FilterIndex-2);
  end;
  if not r then
    Application.MessageBox('Error','Error',0);
  pb.Visible := False;
  rve.SetFocus;  
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rvcConverting(Sender: TObject; Percent: Integer);
begin
  pb.Position := Percent;
end;
{============================ Hypertext =======================================}
// We store URLs in tags
procedure TfrmMain.rveReadHyperlink(Sender: TCustomRichView; const Target,
  Extras: String; DocFormat: TRVLoadFormat; var StyleNo, ItemTag: Integer;
  var ItemName: String);
begin
  ItemTag := Integer(StrNew(PChar(Target)));
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rveURLNeeded(Sender: TCustomRichView; id: Integer;
  var url: String);
var ItemNo: Integer;
    RVData: TCustomRVFormattedData;
begin
  rve.GetJumpPointLocation(id, RVData, ItemNo);
  url := PChar(RVData.GetItemTag(ItemNo));
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rveJump(Sender: TObject; id: Integer);
var ItemNo: Integer;
    RVData: TCustomRVFormattedData;
    s: String;
begin
  rve.GetJumpPointLocation(id, RVData, ItemNo);
  s := PChar(RVData.GetItemTag(ItemNo));
  ShellExecute(0, 'open', PChar(s), nil, nil, SW_SHOW);
end;
{==================== Working with TGifImage ==================================}
{$IFDEF USEGIFIMAGE}
procedure MyAfterImportGraphic(Graphic: TGraphic);
begin
  if Graphic is TGifImage then
    TGifImage(Graphic).DrawOptions := TGifImage(Graphic).DrawOptions-[goAnimate]+[goTransparent];
end;
{------------------------------------------------------------------------------}
// Required for all Delphi/C++Builder, except from D6
function MyCreateGraphics(GraphicClass: TGraphicClass): TGraphic;
begin
  if GraphicClass=TGifImage then  begin
    Result := TGifImage.Create;
    end
  else
    Result := GraphicClass.Create;
end;
{------------------------------------------------------------------------------}
initialization
  TPicture.RegisterFileFormat('gif','Gif Image',TGifImage);
  RV_CreateGraphics := MyCreateGraphics;
  RV_AfterImportGraphic := MyAfterImportGraphic;
  RegisterClass(TGifImage);
{$ENDIF}

end.
