unit TPasScript_IMP;
interface
uses
  Windows,
  Messages,
  stdctrls,
  SysUtils,
  SysConst,
  Classes,
  Consts,
  TypInfo,
  Controls,
  Graphics,
  Menus,
  ImgList,
  Forms,
  ActnList,
  Math,
  Printers,
  StdActns,
  Clipbrd,
  extctrls,
  buttons,
  dialogs,
  passcr;

implementation
procedure TComponent_SetVCLComObject(Value: Pointer);
begin
  TComponent(GetInstance).VCLComObject := Value;
end;

function TComponent_GetVCLComObject: Pointer;
begin
  result := TComponent(GetInstance).VCLComObject;
end;

function TComponent_GetOwner: TComponent;
begin
  result := TComponent(GetInstance).Owner;
end;

procedure TComponent_SetDesignInfo(Value: Longint);
begin
  TComponent(GetInstance).DesignInfo := Value;
end;

function TComponent_GetDesignInfo: Longint;
begin
  result := TComponent(GetInstance).DesignInfo;
end;

procedure TComponent_SetComponentIndex(Value: Integer);
begin
  TComponent(GetInstance).ComponentIndex := Value;
end;

function TComponent_GetComponentIndex: Integer;
begin
  result := TComponent(GetInstance).ComponentIndex;
end;

function TComponent_GetComponentCount: Integer;
begin
  result := TComponent(GetInstance).ComponentCount;
end;

function TComponent_GetComponents(Index: Integer): TComponent;
begin
  result := TComponent(GetInstance).Components[Index];
end;

procedure TPasScript_SetCompileState(Value: TCompileState);
begin
  TPasScript(GetInstance).CompileState := Value;
end;

function TPasScript_GetCompileState: TCompileState;
begin
  result := TPasScript(GetInstance).CompileState;
end;

procedure TPasScript_SetText(Value: String);
begin
  TPasScript(GetInstance).Text := Value;
end;

function TPasScript_GetText: String;
begin
  result := TPasScript(GetInstance).Text;
end;

function TPasScript_GetTextErrorPos: Integer;
begin
  result := TPasScript(GetInstance).TextErrorPos;
end;

function TPasScript_GetErrorPos: Integer;
begin
  result := TPasScript(GetInstance).ErrorPos;
end;

function TPasScript_GetErrorLine: Integer;
begin
  result := TPasScript(GetInstance).ErrorLine;
end;

function TPasScript_GetErrorScript: String;
begin
  result := TPasScript(GetInstance).ErrorScript;
end;

function TPasScript_GetErrorFileName: String;
begin
  result := TPasScript(GetInstance).ErrorFileName;
end;

function TPasScript_GetErrorMessage: String;
begin
  result := TPasScript(GetInstance).ErrorMessage;
end;

function TPasScript_GetCurrentFile: String;
begin
  result := TPasScript(GetInstance).CurrentFile;
end;

function TPasScript_GetLineCount: Integer;
begin
  result := TPasScript(GetInstance).LineCount;
end;

function TPasScript_GetCurrentLine: Integer;
begin
  result := TPasScript(GetInstance).CurrentLine;
end;

procedure TPasScript_SetUnitFolderList(Value: String);
begin
  TPasScript(GetInstance).UnitFolderList := Value;
end;

function TPasScript_GetUnitFolderList: String;
begin
  result := TPasScript(GetInstance).UnitFolderList;
end;

initialization
  RegisterRTTIType(TypeInfo(TNotifyEvent));
// Derived from TPasScript
  RegisterRTTIType(TypeInfo(TPasScript));
  RegisterType('TPasScriptClass = class of TPasScript;');
//-- TPasScript
  RegisterMethod(TPasScript, 'constructor Create(AOwner: TComponent); override;', @TPasScript.Create);
  RegisterMethod(TPasScript, 'destructor Destroy; override;', 
          @TPasScript.Destroy);
  RegisterRTTIType(TypeInfo(TPasScriptConsole));
  RegisterMethod(TPasScript, 'class function GetConsole: TPasScriptConsole;', 
          @TPasScript.GetConsole);
  RegisterMethod(TPasScript, 'function Parse: boolean;', 
          @TPasScript.Parse);
  RegisterMethod(TPasScript, 'procedure ProcessRunError;', 
          @TPasScript.ProcessRunError);
  RegisterMethod(TPasScript, 'function Run: boolean;', 
          @TPasScript.Run);
  RegisterMethod(TPasScript, 'procedure Terminate(RaisedException: boolean);', 
          @TPasScript.Terminate);
  RegisterMethod(TPasScript, 'procedure Suspend;', 
          @TPasScript.Suspend);
  RegisterMethod(TPasScript, 'function Resume: boolean;', 
          @TPasScript.Resume);
  RegisterMethod(TPasScript, 'function IsSuspended: boolean;', 
          @TPasScript.IsSuspended);
  RegisterMethod(TPasScript, 'function IsRunning: boolean;', 
          @TPasScript.IsRunning);
  RegisterRTTIType(TypeInfo(TStream));
  RegisterMethod(TPasScript, 'function LoadBinProg(f: TStream): boolean;', 
          @TPasScript.LoadBinProg);
  RegisterMethod(TPasScript, 'function SaveBinProg(f: TStream): boolean;', 
          @TPasScript.SaveBinProg);
  RegisterMethod(TPasScript, 'function CallFunction(const FuncName: String;                          const Params: array of const;                          Instance: TObject = nil): Variant;', 
          @TPasScript.CallFunction);
  RegisterMethod(TPasScript, 'procedure CallProcedure(const ProcName: String;                            const Params: array of const;                            Instance: TObject = nil);', 
          @TPasScript.CallProcedure);
  RegisterMethod(TPasScript, 'function GetAddress(const Name: String): Pointer;', 
          @TPasScript.GetAddress);
  RegisterMethod(TPasScript, 'function SetAddress(const Name: String; P: Pointer): boolean;', 
          @TPasScript.SetAddress);
  RegisterMethod(TPasScript, 'function TPasScript_GetUnitFolderList: String;', 
          @TPasScript_GetUnitFolderList, true);
  RegisterMethod(TPasScript, 'procedure TPasScript_SetUnitFolderList(Value: String);', 
          @TPasScript_SetUnitFolderList, true);
  RegisterProperty(TPasScript, 'property UnitFolderList: String read TPasScript_GetUnitFolderList write TPasScript_SetUnitFolderList;');
  RegisterMethod(TPasScript, 'function TPasScript_GetCurrentLine: Integer;', 
          @TPasScript_GetCurrentLine, true);
  RegisterProperty(TPasScript, 'property CurrentLine: Integer read TPasScript_GetCurrentLine;');
  RegisterMethod(TPasScript, 'function TPasScript_GetLineCount: Integer;', 
          @TPasScript_GetLineCount, true);
  RegisterProperty(TPasScript, 'property LineCount: Integer read TPasScript_GetLineCount;');
  RegisterMethod(TPasScript, 'function TPasScript_GetCurrentFile: String;', 
          @TPasScript_GetCurrentFile, true);
  RegisterProperty(TPasScript, 'property CurrentFile: String read TPasScript_GetCurrentFile;');
  RegisterMethod(TPasScript, 'function TPasScript_GetErrorMessage: String;', 
          @TPasScript_GetErrorMessage, true);
  RegisterProperty(TPasScript, 'property ErrorMessage: String read TPasScript_GetErrorMessage;');
  RegisterMethod(TPasScript, 'function TPasScript_GetErrorFileName: String;', 
          @TPasScript_GetErrorFileName, true);
  RegisterProperty(TPasScript, 'property ErrorFileName: String read TPasScript_GetErrorFileName;');
  RegisterMethod(TPasScript, 'function TPasScript_GetErrorScript: String;', 
          @TPasScript_GetErrorScript, true);
  RegisterProperty(TPasScript, 'property ErrorScript: String read TPasScript_GetErrorScript;');
  RegisterMethod(TPasScript, 'function TPasScript_GetErrorLine: Integer;', 
          @TPasScript_GetErrorLine, true);
  RegisterProperty(TPasScript, 'property ErrorLine: Integer read TPasScript_GetErrorLine;');
  RegisterMethod(TPasScript, 'function TPasScript_GetErrorPos: Integer;', 
          @TPasScript_GetErrorPos, true);
  RegisterProperty(TPasScript, 'property ErrorPos: Integer read TPasScript_GetErrorPos;');
  RegisterMethod(TPasScript, 'function TPasScript_GetTextErrorPos: Integer;', 
          @TPasScript_GetTextErrorPos, true);
  RegisterProperty(TPasScript, 'property TextErrorPos: Integer read TPasScript_GetTextErrorPos;');
  RegisterMethod(TPasScript, 'function TPasScript_GetText: String;', 
          @TPasScript_GetText, true);
  RegisterMethod(TPasScript, 'procedure TPasScript_SetText(Value: String);', 
          @TPasScript_SetText, true);
  RegisterProperty(TPasScript, 'property Text: String read TPasScript_GetText write TPasScript_SetText;');
  RegisterRTTIType(TypeInfo(TCompileState));
  RegisterMethod(TPasScript, 'function TPasScript_GetCompileState: TCompileState;', 
          @TPasScript_GetCompileState, true);
  RegisterMethod(TPasScript, 'procedure TPasScript_SetCompileState(Value: TCompileState);', 
          @TPasScript_SetCompileState, true);
  RegisterProperty(TPasScript, 'property CompileState: TCompileState read TPasScript_GetCompileState write TPasScript_SetCompileState;');
  RegisterMethod(TPasScript, 'procedure InitDebug;', 
          @TPasScript.InitDebug);
  RegisterRTTIType(TypeInfo(TTraceMode));
  RegisterMethod(TPasScript, 'function Trace(TraceMode: TTraceMode;                   StartPos: Integer; var NewPos: Integer): boolean;', 
          @TPasScript.Trace);
  RegisterMethod(TPasScript, 'function GetPCodeLineNumber(const SourceFileName: String;                                SourceLine: Integer ): Integer;', 
          @TPasScript.GetPCodeLineNumber);
  RegisterMethod(TPasScript, 'function GetSourceFileName(PCodeLineNumber: Integer): String;', 
          @TPasScript.GetSourceFileName);
  RegisterMethod(TPasScript, 'function GetSourceLine(PCodeLineNumber: Integer): String;', 
          @TPasScript.GetSourceLine);
  RegisterMethod(TPasScript, 'function GetSourceLineNumber(PCodeLineNumber: Integer): Integer;', 
          @TPasScript.GetSourceLineNumber);
  RegisterMethod(TPasScript, 'function IsExecutableLine(PCodeLineNumber: Integer): boolean;', 
          @TPasScript.IsExecutableLine);
  RegisterMethod(TPasScript, 'function EvalExpression(const Expression: String;                            PCodeLineNumber: Integer;                            var Res: String): boolean;', 
          @TPasScript.EvalExpression);
  RegisterMethod(TPasScript, 'function EvalAssignment(const Expression: String;                            PCodeLineNumber: Integer): boolean;', 
          @TPasScript.EvalAssignment);
  RegisterMethod(TPasScript, 'procedure AddBreakpoint(PCodeLineNumber: Integer);', 
          @TPasScript.AddBreakpoint);
  RegisterMethod(TPasScript, 'procedure RemoveBreakpoint(PCodeLineNumber: Integer);', 
          @TPasScript.RemoveBreakpoint);
// Derived from TComponent
  RegisterRTTIType(TypeInfo(TComponent));
  RegisterType('TComponentClass = class of TComponent;');
//-- TComponent
  RegisterMethod(TComponent, 'constructor Create(AOwner: TComponent); virtual;', @TComponent.Create);
  RegisterMethod(TComponent, 'destructor Destroy; override;', 
          @TComponent.Destroy);
  RegisterMethod(TComponent, 'procedure DestroyComponents;', 
          @TComponent.DestroyComponents);
  RegisterMethod(TComponent, 'procedure Destroying;', 
          @TComponent.Destroying);
  RegisterMethod(TComponent, 'function FindComponent(const AName: string): TComponent;', 
          @TComponent.FindComponent);
  RegisterMethod(TComponent, 'procedure FreeNotification(AComponent: TComponent);', 
          @TComponent.FreeNotification);
  RegisterMethod(TComponent, 'procedure FreeOnRelease;', 
          @TComponent.FreeOnRelease);
  RegisterMethod(TComponent, 'function GetParentComponent: TComponent; dynamic;', 
          @TComponent.GetParentComponent);
  RegisterMethod(TComponent, 'function GetNamePath: string; override;', 
          @TComponent.GetNamePath);
  RegisterMethod(TComponent, 'function HasParent: Boolean; dynamic;', 
          @TComponent.HasParent);
  RegisterMethod(TComponent, 'procedure InsertComponent(AComponent: TComponent);', 
          @TComponent.InsertComponent);
  RegisterMethod(TComponent, 'procedure RemoveComponent(AComponent: TComponent);', 
          @TComponent.RemoveComponent);
  RegisterMethod(TComponent, 'function TComponent_GetComponents(Index: Integer): TComponent;', 
          @TComponent_GetComponents, true);
  RegisterProperty(TComponent, 'property Components[Index: Integer]: TComponent read TComponent_GetComponents;');
  RegisterMethod(TComponent, 'function TComponent_GetComponentCount: Integer;', 
          @TComponent_GetComponentCount, true);
  RegisterProperty(TComponent, 'property ComponentCount: Integer read TComponent_GetComponentCount;');
  RegisterMethod(TComponent, 'function TComponent_GetComponentIndex: Integer;', 
          @TComponent_GetComponentIndex, true);
  RegisterMethod(TComponent, 'procedure TComponent_SetComponentIndex(Value: Integer);', 
          @TComponent_SetComponentIndex, true);
  RegisterProperty(TComponent, 'property ComponentIndex: Integer read TComponent_GetComponentIndex write TComponent_SetComponentIndex;');
  RegisterMethod(TComponent, 'function TComponent_GetDesignInfo: Longint;', 
          @TComponent_GetDesignInfo, true);
  RegisterMethod(TComponent, 'procedure TComponent_SetDesignInfo(Value: Longint);', 
          @TComponent_SetDesignInfo, true);
  RegisterProperty(TComponent, 'property DesignInfo: Longint read TComponent_GetDesignInfo write TComponent_SetDesignInfo;');
  RegisterMethod(TComponent, 'function TComponent_GetOwner: TComponent;', 
          @TComponent_GetOwner, true);
  RegisterProperty(TComponent, 'property Owner: TComponent read TComponent_GetOwner;');
  RegisterMethod(TComponent, 'function TComponent_GetVCLComObject: Pointer;', 
          @TComponent_GetVCLComObject, true);
  RegisterMethod(TComponent, 'procedure TComponent_SetVCLComObject(Value: Pointer);', 
          @TComponent_SetVCLComObject, true);
  RegisterProperty(TComponent, 'property VCLComObject: Pointer read TComponent_GetVCLComObject write TComponent_SetVCLComObject;');
// Derived from TPersistent
  RegisterRTTIType(TypeInfo(TPersistent));
  RegisterType('TPersistentClass = class of TPersistent;');
//-- TPersistent
  RegisterMethod(TPersistent, 'constructor Create;', @TPersistent.Create);
  RegisterMethod(TPersistent, 'destructor Destroy; override;', 
          @TPersistent.Destroy);
  RegisterMethod(TPersistent, 'procedure Assign(Source: TPersistent); virtual;', 
          @TPersistent.Assign);
  RegisterMethod(TPersistent, 'function  GetNamePath: string; dynamic;', 
          @TPersistent.GetNamePath);
//-- TObject
end.
