unit uFtInchTest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, Maskftin, ExtCtrls, Buttons;

type
  TfrmTestFtInch = class(TForm)
    editWidth: TMaskFtInch;
    Label1: TLabel;
    editLength: TMaskFtInch;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    lblAreaIn: TLabel;
    lblAreaFt: TLabel;
    GroupBox2: TGroupBox;
    radMode: TRadioGroup;
    radRound: TRadioGroup;
    Label6: TLabel;
    Label7: TLabel;
    lblDecIn: TLabel;
    lblDecFt: TLabel;
    btnClose: TBitBtn;
    procedure UpdateControls(Sender: TObject);
    procedure radModeClick(Sender: TObject);
    procedure radRoundClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  frmTestFtInch: TfrmTestFtInch;

implementation

{$R *.dfm}

procedure TfrmTestFtInch.UpdateControls(Sender: TObject);
	begin
  try
  	lblAreaIn.caption	:= FloatToStr(editWidth.DecInch * editLength.DecInch);
    lblAreaFt.caption	:= FloatToStr(editWidth.DecFt * editLength.DecFt);
    lblDecIn.caption	:= FloatToStr(editWidth.DecInch);
    lblDecFt.caption	:= FloatToStr(editWidth.DecFt);
  except
  	lblAreaIn.caption	:= '0.0';
    lblAreaFt.caption	:= '0.0';
    lblDecIn.caption	:= '0.0';
    lblDecFt.caption	:= '0.0';
    end;
	end;


procedure TfrmTestFtInch.radModeClick(Sender: TObject);
	begin
  editWidth.Mode	:= radMode.ItemIndex;
  UpdateControls(Sender);
	end;

procedure TfrmTestFtInch.radRoundClick(Sender: TObject);
	begin
  if radRound.ItemIndex = 0 then
  	editWidth.RoundTo	:= 16;
  if radRound.ItemIndex = 1 then
  	editWidth.RoundTo	:= 32;
  UpdateControls(Sender);
	end;

procedure TfrmTestFtInch.btnCloseClick(Sender: TObject);
	begin
  close;
	end;

end.
