{$INCLUDE ..\cDefines.inc}
unit cDynLib;

{                                                                              }
{                    Dynamically Loaded Libraries 3.02                         }
{                                                                              }
{      This unit is copyright  2001-2002 by David Butler (david@e.co.za)      }
{                                                                              }
{                  This unit is part of Delphi Fundamentals.                   }
{                    Its original file name is cDynLib.pas                     }
{       The latest version is available from the Fundamentals home page        }
{                     http://fundementals.sourceforge.net/                     }
{                                                                              }
{                I invite you to use this unit, free of charge.                }
{        I invite you to distibute this unit, but it must be for free.         }
{             I also invite you to contribute to its development,              }
{             but do not distribute a modified copy of this file.              }
{                                                                              }
{          A forum is available on SourceForge for general discussion          }
{             http://sourceforge.net/forum/forum.php?forum_id=2117             }
{                                                                              }
{ Revision history:                                                            }
{   2001/06/26  1.01  Added TDynamicLibrary.                                   }
{   2002/06/06  3.02  Created cDynLib unit from cSysUtils.                     }
{                                                                              }

interface

uses
  // Delphi
  Windows,
  SysUtils;



{ DLL functions                                                                }
type
  EDynamicLibrary = class (Exception);

Function  LoadDLL (const FileName : String) : HMODULE;
Procedure UnloadDLL (const Handle : HMODULE);
Function  LoadAnyDLL (const FileNames : Array of String) : HMODULE;
Function  GetDLLProcAddress (const Handle : HMODULE; const ProcName : String) : FARPROC;



{ TDynamicLibrary                                                              }
type
  TDynamicLibrary = class
    Handle : HMODULE;

    Constructor Create (const FileName : String); overload;
    Constructor Create (const FileNames : Array of String); overload;
    Destructor  Destroy; override;

    Function  GetProcAddress (const ProcName : String) : FARPROC;
  end;



implementation



{                                                                              }
{ Dynamic Libraries                                                            }
{                                                                              }
Function DoLoadLibrary (const FileName : String) : HMODULE;
  Begin
    Result := LoadLibrary (PChar (FileName));
  End;

Function LoadDLL (const FileName : String) : HMODULE;
  Begin
    Result := DoLoadLibrary (FileName);
    if Result = 0 then
      raise EDynamicLibrary.Create ('Could not load DLL: ' + FileName + ': Error #' +
                            IntToStr (GetLastError));
  End;

Function LoadAnyDLL (const FileNames : Array of String) : HMODULE;
var I : Integer;
  Begin
    For I := 0 to Length (FileNames) - 1 do
      begin
        Result := DoLoadLibrary (FileNames [I]);
        if Result <> 0 then
          exit;
      end;
    raise EDynamicLibrary.Create ('Could not load DLLs: Error #' +
                          IntToStr (GetLastError));
  End;

Procedure UnloadDLL (const Handle : HMODULE);
  Begin
    FreeLibrary (Handle);
  End;

Function GetDLLProcAddress (const Handle : HMODULE; const ProcName : String) : FARPROC;
  Begin
    Result := GetProcaddress (Handle, PChar (ProcName));
    if Result = nil then
      raise EDynamicLibrary.Create ('Could not import function from DLL: ' + ProcName +
                            ': Error #' + IntToStr(GetLastError));
  End;

{ TDynamicLibrary                                                              }
Constructor TDynamicLibrary.Create (const FileName : String);
  Begin
    inherited Create;
    Handle := LoadDLL (FileName);
  End;

Destructor TDynamicLibrary.Destroy;
  Begin
    if Handle <> 0 then
      UnloadDLL (Handle);
    inherited Destroy;
  End;

Constructor TDynamicLibrary.Create (const FileNames : Array of String);
  Begin
    inherited Create;
    Handle := LoadAnyDLL (FileNames);
  End;

Function TDynamicLibrary.GetProcAddress (const ProcName : String) : FARPROC;
  Begin
    Result := GetDLLProcAddress (Handle, ProcName);
  End;



end.

