// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: logfile.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 11/17/1995 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program description and details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The LogFile class is used to log program events.
*/
// ----------------------------------------------------------- //   
#include "logfile.h"
#include <time.h>
#include <string.h>
#include <stdio.h>

int LogFile::Open(char *fname)
{
  out_file.open(fname, ios::app);
  if (!out_file) return 1; // Could not open the file
  stream = &out_file;
  is_open = 1;
  return 0;
}

int LogFile::Open(const char *fname)
{
  out_file.open(fname, ios::app);
  if (!out_file) return 1; // Could not open the file
  stream = &out_file;
  is_open = 1;
  return 0;
}

int LogFile::OverWrite(char *fname)
{
  out_file.open(fname, ios::out);
  if (!out_file) return 1; // Could not open the file
  stream = &out_file;
  is_open = 1;
  return 0;
}

int LogFile::OverWrite(const char *fname)
{
  out_file.open(fname, ios::out);
  if (!out_file) return 1; // Could not open the file
  stream = &out_file;
  is_open = 1;
  return 0;
}

void LogFile::Close()
{
  out_file.close();
  is_open = 0;
}

void LogFile::Flush()
{
  if(is_open) out_file.flush();
}

void LogFile::WriteSysTime()
{
  if(is_open) {
    char date[255]; GetSystemTime(date);
    *(stream) << ' ' << date << ' ';
  }
}

void LogFile::GetSystemTime(char *s, int full_month_name)
// Function used to create a custom time string.
{
  time_t STime;
  struct tm *TimeBuffer;
  char month[25]; char day[25]; char year[25];
  char hour[25]; char minutes[25]; char seconds[25];
  time(&STime);
  TimeBuffer = localtime(&STime);
  if(full_month_name)
    strftime(month, 25, "%B", TimeBuffer);
  else
    strftime(month, 25, "%b", TimeBuffer);
  strftime(day, 25, "%d", TimeBuffer);
  strftime(year, 25, "%Y", TimeBuffer);
  strftime(hour, 25, "%H", TimeBuffer);
  strftime(minutes, 25, "%M", TimeBuffer);
  strftime(seconds, 25, "%S", TimeBuffer);

  // Weekday Name Month Day, Year HH:MM:SS
  sprintf(s, "%s %s, %s %s:%s:%s", month, day, year, hour, minutes, seconds);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
