// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: ehandler.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/14/1996  
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The Ehandler class is used to display exceptions that
occur at run-time. 
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "ehandler.h"

#if defined (__wxWIN168B__)
#include "wxincs.h"

#elif defined (__wxWIN201__)
#include "wx2incs.h"

#elif defined (__CONSOLE__)
#include <iostream.h>
#include <stdlib.h>

#elif defined (__CURSES__)
#include <stdlib.h>
#include "terminal.h"

#else
#error You must define a display type for error messaging
#endif

const char *MessageBoxCaption = "Program Error";

EHandler ExceptionHandler;
EHandler *ProgramError = &ExceptionHandler; // Global exception handler pointer

void EHandler::DisplayException(const char *mesg)
{
#if defined (__wxWIN168B__)
  wxMessageBox((char *)mesg, (char *)MessageBoxCaption, wxOK|wxCENTRE);

#elif defined (__wxWIN201__)
  wxString message(mesg);
  wxString caption(MessageBoxCaption);
  wxMessageBox(message, caption, wxOK|wxCENTRE);

#elif defined (__CURSES__)
  terminal->ClearScreen();
  terminal->Write(mesg, 0, 0);
  terminal->AnyKey(0, 2);

#elif defined (__CONSOLE__)
    cout << endl << mesg << endl;

#else
#error You must define a display type for error messaging
#endif
}

void EHandler::SignalException(const char *mesg, int Level)
{
  // By default a message will be displayed
  DisplayException(mesg); 

  switch(Level) {
    case FATAL:    // Fatal error, terminate program immediately
      Terminate();
      
    case DISPLAY: // Dummy handler that does nothing
      return;
      
    default:
      Terminate();
  }
}

void EHandler::Message(const char *mesg1, const char *mesg2, 
		       const char *mesg3)
{
#if defined (__wxWIN168B__)
  int len = strlen(mesg1) + strlen(mesg2) + strlen(mesg3);
  char *comp = new char[len+1];
  comp[len] = '\0';
  strcpy(comp, mesg1);
  strcat(comp, mesg2);
  strcat(comp, mesg3);
  wxMessageBox(comp, "Program Message", wxOK|wxCENTRE);
  delete comp;

#elif defined (__wxWIN201__)
  wxString message(mesg1);
  wxString caption("Program Message");
  message += mesg2;
  message += mesg3;
  wxMessageBox(message, caption, wxOK|wxCENTRE|wxICON_EXCLAMATION);

#elif defined (__CONSOLE__
  cout << endl;
  if(mesg1) cout << mesg1;
  if(mesg2) cout << mesg2;
  if(mesg3) cout << mesg3;
  cout << endl;

#else
#error You must define a display type for error messaging
#endif
}

void EHandler::Terminate()
{
#if defined (__wxWIN168B__)
  // Terminate the program using the wxExit() function.
  wxExit();
  // Exits application after calling wxApp::OnExit. Should only
  // be used in an emergency: normally the top-level frame should
  // be deleted (after deleting all other frames) to terminate the
  // application. 

#elif defined (__wxWIN201__)
  // Terminate the program using the wxExit() function.
  wxExit();

#elif defined (__CURSES__)
  // Terminate the program abnormally
  terminal->finish();
  exit(FatalErrorLevel);

#elif defined (__CONSOLE__)
  // Terminate the program abnormally
  exit(FatalErrorLevel);

#else
#error You must define a display type for error messaging
#endif
}

void EHandler::TrapException(AF ActionFunction)
{
  // Call the user defined routine
  (*ActionFunction)();
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
