// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: eds201.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 04/30/2001
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to generate platform dependent randomly encrypted 
data sets.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "eds201.h"

eds2String::eds2String(eds2MagicNumber_t magic_num)
{
  InitDynamicTable(magic_num);
}

eds2String::eds2String(const eds2String &ob)
{
  eds2Copy(ob);
}

eds2String eds2String::operator=(const eds2String &ob)
{
  eds2Copy(ob);
  return *this;
}

void eds2String::eds2Copy(const eds2String &ob)
{
  eds2_magic_number = ob.eds2_magic_number;
  for(unsigned i = 0; i < eds2TableSize; i++) 
    eds2_table[i] = ob.eds2_table[i];
}

eds2WORD eds2String::EncryptString(unsigned char c)
// Return a encrypted value for the specified character.
{
  return eds2_table[(unsigned)c];
}

int eds2String::DecryptString(eds2WORD val, unsigned char &c)
// Decrypt the specified value and pass back the character in "c."
// Returns false if the encrypted value is not found in the
// encryption table.
{
  for(unsigned i = 0; i < eds2TableSize; i++) {
    if(eds2_table[i] == val) { // Found a match
      c = (unsigned char)i;
      return 1;
    }
  }
  return 0; // No match was found
}

void eds2String::InitDynamicTable(eds2MagicNumber_t magic_num)
// Initialize the dynamic magic number table. The dynamic table allows 
// applications to change the encryption codes as the program is running.
// Table values are calculated by a byte-wise 16-bit operation based on 
// a specified polynomial. NOTE: In this representation the coefficient 
// of x^0 is stored in the MSB of the 16-bit word and the coefficient of 
// x^15 is stored in the LSB.
{
  eds2_magic_number = magic_num;
  int i, n;
  eds2WORD_t val_16;

  for (i = 0; i < eds2TableSize; i++) {
    val_16=i;
    for (n = 1; n < 9; n++) {
      if (val_16 & 1)
	val_16=(val_16 >> 1) ^ eds2_magic_number;
      else
	val_16=val_16 >> 1;
    }
    eds2_table[i]=val_16;
  }
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
