// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: membuf.h 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The MemoryBuffer class is used to create create and manipulate resizable
memory buffers. The MemoryBuffer class guarantees that each object is 
unique by storing a unique copy of each buffer with each object. This 
ensures that MemoryBuffer objects can be safely copy constructed, 
assigned, resized, and deleted by multiple threads. NOTE: Multiple 
threads accessing shared memory segments must be handled by the 
application.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_MEMBUF_HPP__
#define __GX_MEMBUF_HPP__

#include <string.h>

// Memory buffer class
class MemoryBuffer
{
public:
  MemoryBuffer() { mptr = 0; l_length = d_length = 0; }
  MemoryBuffer(unsigned bytes) {
    mptr = 0; l_length = d_length = 0; Alloc(bytes);
  }
  MemoryBuffer(const void *buf, unsigned bytes);
  ~MemoryBuffer() { if(mptr) delete mptr; }
  MemoryBuffer(const MemoryBuffer &buf);
  MemoryBuffer &operator=(const MemoryBuffer &buf);

public: // Pointer and length functions
  unsigned length() const { return l_length; }  // Returns logical length
  unsigned dlength() const { return d_length; } // Returns actual length
  int resize(unsigned bytes, int keep = 1);
  unsigned char *m_buf() { return mptr; }
  const unsigned char *m_buf() const { return mptr; } 
  int is_null() { return ((mptr == 0) || (l_length == 0)); }
  int is_null() const { return ((mptr == 0) || (l_length == 0)); }
  int Load(const void *buf, unsigned bytes); 
  void Clear();

public: // Append, Insert, delete, and remove functions
  void Cat(const void *buf, unsigned bytes) { InsertAt(l_length, buf, bytes); }
  void Cat(unsigned char byte) { Cat((void *)&byte, 1); }
  void Cat(char byte) { Cat((void *)&byte, 1); }
  unsigned DeleteAt(unsigned position, unsigned bytes);
  unsigned InsertAt(unsigned position, const void *buf, unsigned bytes);
  unsigned InsertAt(unsigned position, const MemoryBuffer &buf) {
    return InsertAt(position, (const void *)buf.mptr, buf.l_length);
  }
  unsigned ReplaceAt(unsigned position, const void *buf, unsigned bytes);
  unsigned ReplaceAt(unsigned position, const MemoryBuffer &buf) {
    return ReplaceAt(position, (const void *)buf.mptr, buf.l_length);
  }
  
public: // Search functions
  unsigned Find(void *buf, unsigned offset = 0); 
  unsigned Find(void *buf, unsigned bytes, unsigned offset = 0) const;
  unsigned Find(const MemoryBuffer &buf, unsigned offset = 0) const {
    return Find(buf.mptr, buf.l_length, offset); 
  }
  
public: // Memory allocation/de-allocation routines
  void *Alloc(unsigned bytes);
  void *Realloc(unsigned bytes, int keep = 1, int reuse = 1);
  void Destroy();
  void *FreeBytes();

public: // Convertion functions
  operator char *() const { return (char *)mptr; }
  operator const char *() const { return (const char*)mptr; }

public: // Overloaded operators
  int operator!() { return ((mptr == 0) || (l_length == 0)); } 
  int operator!() const { return ((mptr == 0) || (l_length == 0)); }
  operator const int () const { return ((mptr != 0) && (l_length != 0)); }
  operator int () { return ((mptr != 0) && (l_length != 0)); }
  unsigned char &operator[](unsigned i);
  unsigned char &operator[](unsigned i) const;
  void operator+=(const MemoryBuffer &buf) { Cat(buf.mptr, buf.l_length); }
  void operator+=(const unsigned char &byte) { Cat(byte); }
  void operator+=(const char &byte) { Cat(byte); }
  friend MemoryBuffer operator+(const MemoryBuffer &a, const MemoryBuffer &b);

  friend int operator==(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) == 0;
  }

  friend int operator!=(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) != 0;
  }

  friend int operator>(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) > 0;
  }

  friend int operator>=(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) >= 0;
  }
  
  friend int operator<(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) < 0;
  }
  
  friend int operator<=(const MemoryBuffer &a, const MemoryBuffer &b) {
    return BufferCompare(a, b) <= 0;
  }

public: // Friend functions
  // Returns -1 if a < b, 0 if a == b, and 1 if a > b
  friend int BufferCompare(const MemoryBuffer &a, const MemoryBuffer &b);  

private: 
  unsigned char *mptr; // Pointer to start of buffer
  unsigned d_length;   // Number of bytes allocated for the buffer
  unsigned l_length;   // Logical length of the buffer
};

#endif  // __GX_MEMBUF_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

