** Internal structure of the rules file: 

*FINAL  
  0                    Lecanora_sp 0
  1                    Lepraria_sp 0
  2             Xantoria_parietina 0
  3                       Usnea_sp 0
  4                    Cladonia_sp 0
  5        Pseudevernia_furfuracea 0
  6             Ramalina_farinacea 0
  7              Ramalina_fraxinea 0
  8            Ramalina_fastigiata 0
  9                     Physcia_sp 0
 10             Platismatia_glauca 0
 11            Hypogymnia_physodes 0
 12              Evernia_prunastri 0
 13            Evernia_furfuraceae 0
 14              Parmelia_caperata 0
 15             Parmelia_saxatilis 0
 16            Parmelia_acetabulum 0
 17            Parmelia_glabratula 0
 18               Parmelia_sulcata 0
 19            Parmelia_subrudecta 0
 20          Parmelia_pastillifera 0
 21              Parmelia_tiliacea 0
 22                Stereocaulon_sp 0
 23                   Baeomyces_sp 0
 24                    Cetraria_sp 0
 25                Cornicularia_sp 0
 26                   Alectoria_sp 0
 27                    Ramalina_sp 0
 28              Cladonia_foliacea 0
 29                   Peltigera_sp 0
 30                  Candelaria_sp 0
 31              Cetraria_pinastri 0
 32                     Lobaria_sp 0
 33                Cetraria_glauca 0
 34                  Anaptychia_sp 0
 35                   Undefined_sp 0
 36                     Biatora_sp 0
 37                 Icmadophila_sp 0

*GROUPS ** (entering rule number follows grup name)
  0                        Lichens 0
  1                        Evernia 10
  2                       Parmelia 13
  3                       Lichens' 42
** Total nubmer of rules: 74

*RULES 
 *RULE 0 33
  *ENTER 
   Lecanora_sp
   Lepraria_sp
   Xantoria_parietina
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The leaflike thallus has a different upper- and bottomside. Often the bottomside has rhizines. $Lichens/blad.jpg 
   Xantoria_parietina
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *ELSE 
   Lecanora_sp
   Lepraria_sp
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 1 35
  *ENTER 
   Xantoria_parietina
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The thallus is yellow or orange. $Lichens/xantpar.jpg 
   Xantoria_parietina
*END
 *ELSE The lobes are gray, gray-green, yellowish green, olive-green, brown or other colour. $Lichens/nt_yellow.jpg 
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 2 33
  *ENTER 
   Lecanora_sp
   Lepraria_sp
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *IF The thallus is ribbonlike, bushlike or has the form of a beaker ? $Lichens/strvorm.jpg 
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *ELSE 
   Lecanora_sp
   Lepraria_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 3 33
  *ENTER 
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *IF The "branches" of the thallus are rather flat. $Lichens/plat.jpg 
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *ELSE  
   Usnea_sp
   Cladonia_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 4 39
  *ENTER 
   Lecanora_sp
   Lepraria_sp
*END
 *IF The thallus is crusty and is firmly attached on a the tree. It is quite impossible to remove the lichen without damaging it. Mostly its a Lecanora-species  $Lichens/lecaspec.jpg
   Lecanora_sp
*END
 *ELSE The lichen has a powderlike thallus; gray, white or green. $Lichens/leprspec.jpg 
   Lepraria_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 5 33
  *ENTER 
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *IF Upper- and bottomside have the same colour. $Lichens/sides_eq.jpg 
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
*END
 *ELSE  
   Pseudevernia_furfuracea
   Evernia_prunastri
   Evernia_furfuraceae
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 6 39
  *ENTER 
   Usnea_sp
   Cladonia_sp
*END
 *IF The branches of the thallus are round and hanging down like a beard. $Lichens/baard.jpg 
   Usnea_sp
*END
 *ELSE The beakerlike thallus is pointing upwards. $Lichens/beker.jpg 
   Cladonia_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 7 33
  *ENTER 
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lobes are gray, gray-green or yellowish green (color example in the picture below) $Lichens/parmsax.jpg  . 
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *ELSE The lobes are olive-green or brown (look at color only in picture below).  $Lichens/parmglab.jpg 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 8 35
  *ENTER 
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
*END
 *IF The edges of the thallus are often torn. The "wounds" are filled with a powder.  $Lichens/ramfar.jpg 
   Ramalina_farinacea
*END
 *ELSE The edges of the thallus are smooth and have big dish-like apothecia on the branches. $Lichens/apoth.jpg 
   Ramalina_fraxinea
   Ramalina_fastigiata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 9 37
  *ENTER 
   Pseudevernia_furfuracea
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *IF The upperside is yellowish green, the bottomside is white. $Lichens/evprun.jpg
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *ELSE The upper side is greyish green, gray or black with little extrusions (isidia). The edges of the thallus are curly. The bottomside is black, the ends of the lobes are pinkly white. $Lichens/pseudfur.jpg 
   Pseudevernia_furfuracea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 10 39
  *ENTER 
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *IF  The upper side of lobes is greenish, the lower whitish. Normally grows on deciduos trees  $Lichens/evprun.jpg 
   Evernia_prunastri
*END
 *ELSE The upper side of lobes is grey, usually with numerous powder-like extrusions (isidia), the lower side is bright rose - coloured or lilyish black. Normally grows on coniferouos trees (usually pines). $Lichens/evfurf.jpg 
   Evernia_furfuraceae
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 11 39
  *ENTER 
   Ramalina_fraxinea
   Ramalina_fastigiata
*END
 *IF Thallus mostly with big lobes, with small sublobes and big apothecia. Often the thallus has small white dots on it (pseudocyfella). This species only grows on the bark of trees. $Lichens/ramfrax.jpg 
   Ramalina_fraxinea
*END
 *ELSE This last one is rather rare. The thallus consist of short, strong ribbonlike branches, which can form very dense "pillows". At the end of the branches there are mostly apothecia. Dense thallus bundles on treebark are very characteristic. $Lichens/ramfast.jpg 
   Ramalina_fastigiata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 12 35
  *ENTER 
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lichen has a very small thallus. The lobes are less then 2 mm; mostly they are invisible whit the bare eye, so use a magnifier. $Lichens/physcten.jpg 
   Physcia_sp
*END
 *ELSE The lichen has a great thallus with very good visible lobes. $Lichens/nt_yellow.jpg 
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 13 33
  *ENTER 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lobes are olive-green or brown. (look at color only in the illustration below) $Lichens/parmacet.jpg 
   Parmelia_acetabulum
   Parmelia_glabratula
*END
 *ELSE 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 14 35
  *ENTER 
   Platismatia_glauca
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lichen has broad lobes with edges that are curling up (like lettuce). $Lichens/platglau.jpg 
   Platismatia_glauca
*END
 *ELSE The lobes are pressed against the substrate. $Lichens/nt_yellow.jpg 
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 15 35
  *ENTER 
   Hypogymnia_physodes
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lobes are medium-sized (2 - 3 mm), swollen and have a raised top. $Lichens/hypphys.jpg 
   Hypogymnia_physodes
*END
 *ELSE The lobes are pressed against the substrate, are flat and spread. $Lichens/nt_yellow.jpg 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 16 39
  *ENTER 
   Parmelia_acetabulum
   Parmelia_glabratula
*END
 *IF The thallus is spread wide open. The lobes are broad, olive-green and often showing apothecia. $Lichens/parmacet.jpg 
   Parmelia_acetabulum
*END
 *ELSE The thallus is rather small, pressed against the substrate and brown.  $Lichens/parmglab.jpg 
   Parmelia_glabratula
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 17 35
  *ENTER 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The thallus is yellowish green. $Lichens/parmcap.jpg 
   Parmelia_caperata
*END
 *ELSE The thallus is greyish green.  $Lichens/parmsax.jpg 
   Parmelia_saxatilis
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 18 33
  *ENTER 
   Parmelia_saxatilis
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The lobes have a network of white lines and white points (soralia) losing a white powder.  $Lichens/parmsulc.jpg
   Parmelia_sulcata
   Parmelia_subrudecta
*END
 *ELSE  
   Parmelia_saxatilis
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 19 39
  *ENTER 
   Parmelia_sulcata
   Parmelia_subrudecta
*END
 *IF Bring a few drops of KOH-sol (10%) on the thallus. A red colour should appear $Lichens/parmsulc.jpg 
   Parmelia_sulcata
*END
 *ELSE The red colour after KOH treatment does not appear $Lichens/parmsulc.jpg 
   Parmelia_subrudecta
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 20 35
  *ENTER 
   Parmelia_saxatilis
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF The middle of the thallus contains numerous little warts. The thallus is gray.  $Lichens/parmsax.jpg 
   Parmelia_saxatilis
*END
 *ELSE The middle of the thallus contains numerous little warts. The thallus is white till gray.  $Lichens/parmpast.jpg 
   Parmelia_pastillifera
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 21 39
  *ENTER 
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *IF Bring a few drops of KOH-sol (10%) on the thallus. A red colour should appear $Lichens/parmpast.jpg 
   Parmelia_pastillifera
*END
 *ELSE The red colour after KOH treatment does not appear $Lichens/parmpast.jpg  
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 22 31
  *ENTER 
   Usnea_sp
*END
 *IF A lot of Beardmosses disappeared because of the air pollution. Now we can only find a lot of these species only in the high mountains and in the Northern regions. The Beardmosses indicate clean air Most species are hanging down on the trees; some of them form upstanding bushes. Usnea is recognisable on the white central "wire" that appears when the lichen is carefully torn apart. SO2-sensitivity: ca 30 mkg/m3. The image enlarged. $Lichens/Kedene.jpg 
   Usnea_sp
*END
 *ELSE  
   Usnea_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 23 31
  *ENTER 
   Ramalina_farinacea
*END
 *IF Your lichen is Ramalina farinacea The branches of the tallus are narrow, with soralia on the edge of the thallus. The species looks a lot like R. pollinaria which has soralia on the middle of the thallus as well. SO2-sensitivity: ca 55 mkg/m3 $Lichens/ramfar.jpg 
   Ramalina_farinacea
*END
 *ELSE  
   Ramalina_farinacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 24 11
  *ENTER 
   Ramalina_fraxinea
*END
 *IF The lichen is Ramalina fraxinea ( grows mostly on Fraxinus sp.), Thallus mostly with big lobes, with small sublobes and big apothecia. They are quite large, up to 10 mm in diameter, and grow at the borders of the lobes. Often the thallus has small white dots on it (pseudocyfella). This species only grows on the bark of trees. Lichen is greysh green or grey. Can be found not only in the forest, but also in parks and gardens. SO2-sensitivity: ca 32 mkg/m3 $Lichens/ramfrax.jpg 
   Ramalina_fraxinea
*END
 *ELSE  
   Ramalina_fraxinea
   Ramalina_fastigiata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 25 11
  *ENTER 
   Ramalina_fastigiata
*END
 *IF The lichen is Ramalina fastigiata. This one is rather rare. The thallus consist of short, strong ribbonlike branches, which can form very dense "pillows". At the end of the branches there are mostly apothecia. Dense thallus bundles on treebark are very characteristic SO2-sensitivity: ca 35 kmg/m3 $Lichens/ramfast.jpg 
   Ramalina_fastigiata
*END
 *ELSE  
   Ramalina_fraxinea
   Ramalina_fastigiata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 26 31
  *ENTER 
   Evernia_prunastri
*END
 *IF Your lichen is Evernia prunastri. Ribbonlike thallus hanging down in bundles. Upper side is greyish-green, bottom is white. Apothecia area seldom, soridia however appear numerous. To be found mostly on branches, seldom on stones or on the ground. Confusion is possible with Pseudevernia (upper side gray, bottom black) and Ramalina (both sides green). SO2-sensitivity: ca 55 mkg/m3. $Lichens/evprun.jpg 
   Evernia_prunastri
*END
 *ELSE  
   Evernia_prunastri
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 27 31
  *ENTER 
   Pseudevernia_furfuracea
*END
 *IF The lichen is Pseudevernia furfuracea. In Europe there is only one species of this genus. The ribbonlike branches of the thallus often look like antlers. The gray upper side is well filled with isidia. The bottom is black. Apothecia are big with an olive-brown dish, but they appear very seldom. The species is common on pine-trees in mountains. SO2-sensitivity: ca 45 g/m3 $Lichens/pseudfur.jpg 
   Pseudevernia_furfuracea
*END
 *ELSE  
   Pseudevernia_furfuracea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 28 31
  *ENTER 
   Xantoria_parietina
*END
 *IF The lichen is Xantoria parietina . Mostly the thallus is yellow, with lobes that are flat (1-2 mm). There are numerous orange-yellow apothecia. The lichen is found in whole Europe on bark, wood and stones. SO2-sensitivity: ca 70 g/m3 $Lichens/xantpar.jpg 
   Xantoria_parietina
*END
 *ELSE  
   Xantoria_parietina
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 29 31
  *ENTER 
   Physcia_sp
*END
 *IF The lichen belongs to the genus Physcia. Probably its Physcia tenella. This species grows very well in dusty air. The small, white lobes of the thallus cover each other to form sods. The ends of the thallus contain soredia and are flat; in contrast with the species P.adscendens which resembles a lot like P. tenella but which has thallus ends that look like a helmet. Physcia is very common. SO2-sensitivity: ca 70 g/m3 $Lichens/physcten.jpg 
   Physcia_sp
*END
 *ELSE  
   Physcia_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 30 31
  *ENTER 
   Platismatia_glauca
*END
 *IF This lichen is Platismatia glauca. The big lobes are gray to greyish-green. The edges often are strongly indented and are carrying soredia. The bottomside is brown or black. The thallus grows a bit bushlike on bark and small tree branches. SO2-sensitivity: ca 50 g/m3 $Lichens/platglau.jpg 
   Platismatia_glauca
*END
 *ELSE  
   Platismatia_glauca
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 31 31
  *ENTER 
   Hypogymnia_physodes
*END
 *IF a) curly edge : Hypogymnia physodes b) tube-like edge : Hypogymnia tubulifera The most probably Hypogymnia physodes. The edges of the thallus bear typical lipsoralia. The species is common on mineral-poor bark, wood and stones. In very polluted regions this leaflike species often is the last one to survive. SO2-sensitivity: ca 60 g/m3 $Lichens/hypphys.jpg 
   Hypogymnia_physodes
*END
 *ELSE  
   Hypogymnia_physodes
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 32 31
  *ENTER 
   Parmelia_caperata
*END
 *IF Your lichen is Parmelia caperata (Schildmos).The wide lobes are yellowish-green and bear granular soralia. The bottomside has no rhizines on the edge. Grows on wood and stones in warmer regions. SO2-sensitivity: ca 40 g/m3 $Lichens/parmcap.jpg 
   Parmelia_caperata
*END
 *ELSE  
   Parmelia_caperata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 33 31
  *ENTER 
   Parmelia_sulcata
*END
 *IF Thallus is blue-gray, carrying a net of thin white lines leading to soralia on the edge. Common on stones and bark. Confusion is possible with other Parmalia- and Hypogymnia-species. SO2-sensitivity: ca 65 g/m3 $Lichens/parmsulc.jpg 
   Parmelia_sulcata
*END
 *ELSE  
   Parmelia_sulcata
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 34 31
  *ENTER 
   Parmelia_subrudecta
*END
 *IF Thallus is greyish-white, blue-gray or brown-gray. Upper side bears small white dots (pseudocyphella) which break open in red soralia. Bottomside is coloured lightly. SO2-sensitivity: ca 65 g/m3 $Lichens/parmsulc.jpg 
   Parmelia_subrudecta
*END
 *ELSE  
   Parmelia_subrudecta
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 35 31
  *ENTER 
   Parmelia_saxatilis
*END
 *IF The lichen is Parmelia saxatilis. The thallus forms rosette. Grows on stone and bark. The dish-like apothecia are brown. Commonly, specially in mountains. SO2-sensitivity: ca 65 g/m3 $Lichens/parmsax.jpg 
   Parmelia_saxatilis
*END
 *ELSE  
   Parmelia_saxatilis
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 36 31
  *ENTER 
   Parmelia_pastillifera
*END
 *IF Parmelia pastillifer. Thallus is big (diameter more then 10 cm) and consist of white-gray rounded lobes. The central lobes are bearing tube-like isidia on the topside. Grows on Tilia sp. SO2-sensitivity: ca 35 g/m3 $Lichens/parmpast.jpg  
   Parmelia_pastillifera
*END
 *ELSE  
   Parmelia_pastillifera
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 37 31
  *ENTER 
   Parmelia_tiliacea
*END
 *IF Parmelia tiliacea. Thallus is big (diameter more then 10 cm) and consist of white-gray rounded lobes. The central lobes are bearing tube-like isidia on the topside. Grows on Tilia sp. SO2-sensitivity: ca 35 g/m3 $Lichens/parmpast.jpg  
   Parmelia_tiliacea
*END
 *ELSE  
   Parmelia_tiliacea
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 38 31
  *ENTER 
   Parmelia_acetabulum
*END
 *IF The lichen is Parmelia acetabulum. When the thallus is dry, its greyish-green; when wet, its bright green. Almost always carrying brownish, dish-like apothecia. Very common on trees. SO2-sensitivity: ca 35 g/m3 $Lichens/parmacet.jpg
   Parmelia_acetabulum
*END
 *ELSE  
   Parmelia_acetabulum
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 39 31
  *ENTER 
   Parmelia_glabratula
*END
 *IF The lichen is Parmelia glabratula. Thallus is brown, when wet: green. The upper side of young lobes often are covered with "hairs" (use a magnifier). Common in mountain regions of South- and Central-Europe. SO2-sensitivity: ca 55 g/m3 $Lichens/parmglab.jpg 
   Parmelia_glabratula
*END
 *ELSE  
   Parmelia_glabratula
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 40 31
  *ENTER 
   Lecanora_sp
*END
 *IF The lichen in front of you belongs to a group that is hard to determinate. Its a crusty lichen. You can best use a picture-book to determine these lichens. Often it concerns a Lecanora-species. SO2-sensitivity: ca 125 g/m3. $Lichens/lecaspec.jpg 
   Lecanora_sp
*END
 *ELSE  
   Lecanora_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 41 31
  *ENTER 
   Lepraria_sp
*END
 *IF The lichen in front of you is a powderlike lichen. Lepraria is the most common genus SO2-sensitivity: ca 150 g/m3 $Lichens/leprspec.jpg 
   Lepraria_sp
*END
 *ELSE  
   Lepraria_sp
*END

*FROM by Pierre Volpe, http://users.pandora.be/pivo/lichenes 1
*PG 0
*END

 *RULE 42 33
  *ENTER 
   Xantoria_parietina
   Usnea_sp
   Cladonia_sp
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
   Alectoria_sp
   Ramalina_sp
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END
 *IF The thallus is ribbonlike, bushlike or has the form of a beaker ? $Lichens/strvorm.jpg 
   Usnea_sp
   Cladonia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
   Alectoria_sp
   Ramalina_sp
*END
 *ELSE 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 43 33
  *ENTER 
   Usnea_sp
   Cladonia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
   Alectoria_sp
   Ramalina_sp
*END
 *IF The lichen grows on a soil (ground) $Lichens/cladspec.jpg
   Cladonia_sp
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
*END
 *ELSE The lichen is found on a trunk, stone, stump, rock, etc $Lichens/trunk.jpg
   Usnea_sp
   Cladonia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Stereocaulon_sp
   Alectoria_sp
   Ramalina_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 44 33
  *ENTER 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END
 *IF So-called "leafy" lichens. The thallus consists shredded or lobed sheets. They, or at least their edges can be easily separated from the surface on that the lichen grows $Lichens/nt_yellow.jpg 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END
 *ELSE  "Crusty" lichens. Lichen is deeply grown into substrate, unseparable from it. It looks like some spots on the substrate. Only very seldom indistinct small lobes can be seen just on the edges of the thallus. $Lichens/lecaspec.jpg
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 45 33
  *ENTER 
   Cladonia_sp
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
*END
 *IF The thallus is of two kinds: the primary one has the shape of small sheets, scales or grain. From it, the secondary thallus grows. This one has the form of round small bush-like branches or single stems. The primary thallus can be quite small and sometimes vanishes $Lichens/primsec.jpg
   Cladonia_sp
   Stereocaulon_sp
   Baeomyces_sp
*END
 *ELSE The thallus is only bushlike. The branches are flat or twisted into tubes $Lichens/evfurf.jpg
   Cetraria_sp
   Cornicularia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 46 33
  *ENTER 
   Usnea_sp
   Cladonia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Stereocaulon_sp
   Alectoria_sp
   Ramalina_sp
*END
 *IF The lichen grows on stumps, on trunk by the roots, sometimes on stones 
   Cladonia_sp
   Stereocaulon_sp
*END
 *ELSE The lichen is normally found on tree stems or branches $Lichens/trunk.jpg 
   Usnea_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Alectoria_sp
   Ramalina_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 47 35
  *ENTER 
   Cladonia_sp
   Stereocaulon_sp
   Baeomyces_sp
*END
 *IF The primary thallus is crust-like or scales-like. From it, the secondary bushlike thallus grows. Its branches contains numerous wart-shaped shoots, making the lichen similar to coral 
   Stereocaulon_sp
*END
 *ELSE No wart-shaped shoots, secondary thallus consist only branches or single stems. $Lichens/clad_sm.jpg 
   Cladonia_sp
   Baeomyces_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 48 39
  *ENTER 
   Cetraria_sp
   Cornicularia_sp
*END
 *IF Thallus is branched into lobes. They are flat or twisted into tubes 
   Cetraria_sp
*END
 *ELSE Brown or black-brown ball-shaped small bushes, branched into tiny, almost round branches. Weakly attached to the soil. Grows in dunes and sands. 
   Cornicularia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 49 39
  *ENTER 
   Cladonia_sp
   Baeomyces_sp
*END
 *IF From primary crust-like thallus grow only small (less than 5 mm) single stems 
   Baeomyces_sp
*END
 *ELSE The stems are usually higher than 10 mm and often branched. The primary thallus is scales-like and often early disappear. $Lichens/clad_sm.jpg 
   Cladonia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 50 39
  *ENTER 
   Cladonia_sp
   Stereocaulon_sp
*END
 *IF The lichen is remembers small branched bush. Its branches contains numerous wart-shaped shoots, making the lichen similar to coral. Can grow on stones, carried round by soil.  
   Stereocaulon_sp
*END
 *ELSE No wart-shaped shoots, secondary thallus consist only branches or single stems. Normally grows on stumps or on trunk by the roots. $Lichens/primsec.jpg 
   Cladonia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 51 33
  *ENTER 
   Usnea_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Alectoria_sp
   Ramalina_sp
*END
 *IF The thallus looks like branched threads, growing in tufts, usually hanging down $Lichens/baard.jpg 
   Usnea_sp
   Alectoria_sp
*END
 *ELSE The thallus has shape of branched lobed ribbons or laciniated sheets $Lichens/plat.jpg
   Evernia_prunastri
   Evernia_furfuraceae
   Ramalina_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 52 39
  *ENTER 
   Usnea_sp
   Alectoria_sp
*END
 *IF The threads branches many times into two (is multiply forked). The inner part of the thread has the same colour as its surface $Lichens/alectoria_a.jpg
   Alectoria_sp
*END
 *ELSE From several the main threads at right angle goes multiple small branches. The inner part is white, this is clearly seen after rupturing the thread $Lichens/usnea_a.jpg 
   Usnea_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 53 35
  *ENTER 
   Evernia_prunastri
   Evernia_furfuraceae
   Ramalina_sp
*END
 *IF Upper- and bottomside have the same colour, usually grey or greyish green $Lichens/sides_eq.jpg
   Ramalina_sp
*END
 *ELSE The lower side is brighter. The thallus branching a little remembers the elk horns. $Lichens/sides.jpg
   Evernia_prunastri
   Evernia_furfuraceae
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 54 33
  *ENTER 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END
 *IF Lichen is found on a soil, or maybe on stone, covered by soil 
   Cladonia_foliacea
   Peltigera_sp
*END
 *ELSE Lichen grows on trunks, branches or bald stones 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 55 37
  *ENTER 
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END
 *IF  Lichen grows on a soil, sand, peats or decomposing wood 
   Biatora_sp
   Icmadophila_sp
*END
 *ELSE  Lichen grows on tree cortex or stones 
   Undefined_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 56 39
  *ENTER 
   Cladonia_foliacea
   Peltigera_sp
*END
 *IF Thallus has shape of thin shredded small sheet, up to 30 mm in diameter. The lower side is white, the upper usually yellowish white. Grows in sands and dunes, mostly in places where the sand is a not disturbed by wind. Quite rare. 
   Cladonia_foliacea
*END
 *ELSE Thallus usually larger, the lobes wide, greyish or brown, often with large round "fruits" in the top of the lobes 
   Peltigera_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 57 33
  *ENTER 
   Xantoria_parietina
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END
 *IF The lichen is brightly yellow. $Lichens/xantpar.jpg 
   Xantoria_parietina
   Candelaria_sp
   Cetraria_pinastri
*END
 *ELSE The lichen has different colour, only sometimes it is a little yellowish $Lichens/nt_yellow.jpg 
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 58 35
  *ENTER 
   Xantoria_parietina
   Candelaria_sp
   Cetraria_pinastri
*END
 *IF The thallus is yellow, usually has a round shape with lobes that are flat (1-2 mm). Typically it is rather large. There are numerous orange-yellow apothecia (fruit bodies). If you drop 10 % KOH solution on it, the bright purple colour appear. $Lichens/xantpar.jpg 
   Xantoria_parietina
*END
 *ELSE The lichen is usually small and dont change colour after KOH treatment 
   Candelaria_sp
   Cetraria_pinastri
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 59 35
  *ENTER 
   Physcia_sp
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END
 *IF Thallus usually is 20-30 mm in diameter, gray or brownish, consists finely lobed or shredded rosettes. At the end of shreds it is possible to see something like powder (soredes, used by lichen for propagation) $Lichens/physcten.jpg 
   Physcia_sp
*END
 *ELSE Thallus consists large rosettes, lobed sheets or branched lobes. $Lichens/nt_yellow.jpg
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 60 39
  *ENTER 
   Candelaria_sp
   Cetraria_pinastri
*END
 *IF Thallus remembers small scales, only 2-3 mm length, sulphur colour. These scales makes rosette. As a rule, this lichen grows on deciduous trees 
   Candelaria_sp
*END
 *ELSE Thallus quite large, up to 50 mm in diameter, laciniate, lemon colour. As a rule, grows on pines and other coniferous trees, sometimes on stones. 
   Cetraria_pinastri
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 61 35
  *ENTER 
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
*END
 *IF Thallus consists large sheets. They are 100-300 mm in diameter, with creases, usually greyish. Typically grows on the trunks of the old oaks. $Lichens/Lobaria.jpg
   Lobaria_sp
*END
 *ELSE Thallus is smaller $Lichens/nt_yellow.jpg
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cetraria_glauca
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 62 35
  *ENTER 
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Cetraria_glauca
   Anaptychia_sp
*END
 *IF Thallus round or remembers irregular rosette, with lobed or shredded borders. The lobes edges are irregularly cut out. The upper side of the lobes is bluish grey, the lower side black and the edges white. At the edges sometime you can see fruit bodies and powderlike sorals. Cetraria glauca.  $Lichens/cetraria.jpg
   Cetraria_glauca
*END
 *ELSE 
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 63 33
  *ENTER 
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Anaptychia_sp
*END
 *IF Thallus from the same background branches into narrow, flat lobed shreds, often looks like dichotomicaly branched, a little remembering elk horns. Lichen usually more remembers a small bush, but young lichens might look as "leafy". The image is enlarged. $Lichens/sides.jpg 
   Evernia_prunastri
   Evernia_furfuraceae
*END
 *ELSE 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 64 37
  *ENTER 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Anaptychia_sp
*END
 *IF Thallus round or remembers irregular rosette, with lobed or shredded borders. Fruit bodies and sorals over the whole surface of the lobes. Lichen is firmly attached to the substrate. $Lichens/nt_yellow.jpg 
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
*END
 *ELSE Thallus is the most like one of Evernia, but the edges very ciliate. There are many fruit bodies (3-6 mm in diameter) over the whole surface of thallus. 
   Anaptychia_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 65 39
  *ENTER 
   Biatora_sp
   Icmadophila_sp
*END
 *IF Sand lichen, makes grey crusts on sand, reinforcing it. 
   Biatora_sp
*END
 *ELSE Decomposing wood lichen, rose - coloured fruit bodies (1..2 mm in diameter) above the crusty thallus 
   Icmadophila_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 66 9
  *ENTER 
   Ramalina_sp
*END
 *IF It can be one of the Ramalina species. Thallus concists more or less branched ribbons or (quite seldom) lobes. Both sides of the ribbons have the same color. At the borders of the ribbons some Ramalina"s have quite large fruit bodies, up to 10 mm in diameter. Normally grows on trees or wooden substrates. Press "Yes" to determine more exactly. SO2-sensitivity for these lichens is ca 35-55 g/m3. Is it similar to the samples given below? $Lichens/Ramalina.jpg
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
*END
 *ELSE  
   Lecanora_sp
   Lepraria_sp
   Xantoria_parietina
   Usnea_sp
   Cladonia_sp
   Pseudevernia_furfuracea
   Ramalina_farinacea
   Ramalina_fraxinea
   Ramalina_fastigiata
   Physcia_sp
   Platismatia_glauca
   Hypogymnia_physodes
   Evernia_prunastri
   Evernia_furfuraceae
   Parmelia_caperata
   Parmelia_saxatilis
   Parmelia_acetabulum
   Parmelia_glabratula
   Parmelia_sulcata
   Parmelia_subrudecta
   Parmelia_pastillifera
   Parmelia_tiliacea
   Stereocaulon_sp
   Baeomyces_sp
   Cetraria_sp
   Cornicularia_sp
   Alectoria_sp
   Ramalina_sp
   Cladonia_foliacea
   Peltigera_sp
   Candelaria_sp
   Cetraria_pinastri
   Lobaria_sp
   Cetraria_glauca
   Anaptychia_sp
   Undefined_sp
   Biatora_sp
   Icmadophila_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 67 31
  *ENTER 
   Undefined_sp
*END
 *IF There are at least 26000 species of different lichens in the world. Some of them can only be recognised after looking at microscopic cross-sections of the lichen. This small key is created for illustration purposes only and cover only the lichens that are the most widespread and easy to determine. Your lichen the most probably belong to species that have not been included into the key. Detailed key, covering much more lichens, can only be created during serious scientific project. $Lichens/nameliai.jpg 
   Undefined_sp
*END
 *ELSE  
   Undefined_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 68 31
  *ENTER 
   Biatora_sp
*END
 *IF Sand lichen, makes grey, black or brown crusts on sand, reinforcing it. Crusts can be easily separated from sand. Thallus black of dark brown. Sometimes covers quite large areas of substrate. In general, diameter varies from 1 to 100 mm. 
   Biatora_sp
*END
 *ELSE  
   Biatora_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 69 31
  *ENTER 
   Icmadophila_sp
*END
 *IF Icmadophila is the lichen of forests and swamps, mainly on decomposing wood or old peat-moss. Rose - coloured fruit bodies (1..2 mm in diameter) sometimes has short stems (use magnifier). 
   Icmadophila_sp
*END
 *ELSE  
   Icmadophila_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 70 31
  *ENTER 
   Alectoria_sp
*END
 *IF  This lichen usually grows on older pines, firs or birchs. Fruit bodies very rare. In Lithuanian, this lichen (not Usnea) is called witch"s hair (Usnea is called loosener), but we are not sure about other languages. Differently from Usnea, witch"s hair branches dichotomically and does not have the white "core". Alectoria is quite sensitve to air pollution and should indicate clean air. SO2-sensitivity: ca 30 mkg/m3 $Lichens/alectoria_a.jpg 
   Alectoria_sp
*END
 *ELSE  
   Alectoria_sp
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 71 31
  *ENTER 
   Evernia_furfuraceae
*END
 *IF Your lichen is Evernia_furfuraceae. Ribbonlike thallus hanging down in bundles. The upper side of lobes is grey, usually with numerous powder-like extrusions (isidia), the lower side is bright rose - coloured or lilyish black. As a rule, this lichen grows on coniferouos trees (usually pines). Confusion is possible with Pseudevernia (upper side gray, bottom black) and Ramalina (both sides green). SO2-sensitivity: ca 55 mkg/m3. $Lichens/evfurf.jpg
   Evernia_furfuraceae
*END
 *ELSE  
   Evernia_furfuraceae
*END

*FROM by Audrius Meskauskas http://members.xoom.com/AudriusA/es.htm 2
*PG 0
*END

 *RULE 72 31
  *ENTER 
   Cladonia_sp
*END
 *IF The lichen can be one of Cladonia-species. This genus includes many species that can differ a lot. The upstanding thalli (pothedia) are growing on a basethallus. These potedia can be beaker-like or bushlike. SO2-sensitivity: 125 mkg/m3. Photo courtesy of Kathryn Eberhart, Palmer, Alaska,  $Lichens/cladspec.jpg 
   Cladonia_sp
*END
 *ELSE  
   Cladonia_sp
*END

*FROM Kathryn Eberhart, Palmer, Alaska, http://www.alaskascreensavers.com/gallery/lichens/ak/lichens.htm 77
*PG 0
*END

 *RULE 73 31
  *ENTER 
   Lobaria_sp
*END
 *IF Thallus consists large sheets. They are 100-300 mm in diameter, with creases, usually greyish. Typically grows on the trunks of the old oaks. Lobaria linata, taken as typical example, is a large-lobed lichen with many ridges and hollows on its upper surface. It grows with mosses on the forest floor, at the bases of trees, and on the trunks of birch trees. Its bottom surface is a mottled brown and white. During the dry parts of the year the lichens become very dry and crusty. They will break rather than bend. As soon as there is precipitation and daytime temperatures above freezing, the lichens absorb moisture. Lobaria linata becomes a bright green and feels flexible to the touch. Photo courtesy of Kathryn Eberhart, Palmer, Alaska $Lichens/Lobaria.jpg
   Lobaria_sp
*END
 *ELSE  
   Lobaria_sp
*END

*FROM Kathryn Eberhart, Palmer, Alaska, http://www.alaskascreensavers.com/gallery/lichens/ak/lichens.htm 77
*PG 0
*END

 *RULE 74 31
  *ENTER 
   Cetraria_glauca
*END
 *IF Thallus round or remembers irregular rosette, with lobed or shredded borders. The lobes edges are irregularly cut out. The upper side of the lobes is bluish grey, the lower side black and the edges white. At the edges sometime you can see fruit bodies and powderlike sorals. Grows usually on pines. Exact sensitivity to pollutionis not explored, however lichen is not found in highly polluted regions. $Lichens/cetraria.jpg
   Cetraria_glauca
*END
 *ELSE  
   Cetraria_glauca
*END

*FROM Kathryn Eberhart, Palmer, Alaska, http://www.alaskascreensavers.com/gallery/lichens/ak/lichens.htm 77
*PG 0
*END

*ENDFILE
