unit HBinary3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TForm3 = class(TForm)
    Image1: TImage;
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
     rgn  : HRGN;              {These are needed for the DrawRectRegion stuff}
     wrect : TRect;
     LbDown : boolean;
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses HBinary4,HBinary1;

{$R *.DFM}


procedure TForm3.Panel1MouseDown(Sender: TObject; Button: TMouseButton; {check for mouse buttons}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then LBDown:=true;
  if (Button=mbRight) then Form4.visible:=true;
  if (LBDown) then
     begin
        OldP.X:=X;
        OldP.Y:=Y;
        OldP := ClientToScreen(OldP);            { Q is the TPoint for the screen }
        OldQ:=OldP;
     end;
end;

procedure TForm3.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X, {If left mouse down on upper display panel then move form}
  Y: Integer);
var
  P, Q : TPoint;
begin
   if ((LBDown) and (Moveable)) then
      begin
        P.X := X;                          { P is the TPoint record for the form}
        P.Y := Y;
        Q := ClientToScreen(P);            { Q is the TPoint for the screen }
        if ((Q.X<>OldQ.X) or (Q.Y<>OldQ.Y)) then
           begin
              Form3.Left:=Form3.Left+(Q.X-OldQ.X);
              Form3.Top:= Form3.Top +(Q.Y-OldQ.Y);
           end;
        OldQ:=Q;
      end;
end;

procedure TForm3.Panel1MouseUp(Sender: TObject; Button: TMouseButton;  {If right mouse button is raised then repaint form}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then  LBDown:=false;
  if (Button=mbRight) then Form4.Visible:=true;
end;

procedure TForm3.FormDestroy(Sender: TObject);
begin
   Top3:=Form3.Top;
   Left3:=Form3.Left;
end;


end.
