unit HBinary2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TForm2 = class(TForm)
    Image1: TImage;
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
     rgn  : HRGN;              {These are needed for the DrawRectRegion stuff}
     wrect : TRect;
     LbDown : boolean;
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses HBinary4,HBinary1;

{$R *.DFM}


procedure TForm2.Panel1MouseDown(Sender: TObject; Button: TMouseButton; {check for mouse buttons}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then LBDown:=true;
  if (Button=mbRight) then Form4.visible:=true;
  if (LBDown) then
     begin
        OldP.X:=X;
        OldP.Y:=Y;
        OldP := ClientToScreen(OldP);            { Q is the TPoint for the screen }
        OldQ:=OldP;
     end;
end;

procedure TForm2.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X, {If left mouse down on upper display panel then move form}
  Y: Integer);
var
  P, Q : TPoint;
begin
   if ((LBDown) and (Moveable)) then
      begin
        P.X := X;                          { P is the TPoint record for the form}
        P.Y := Y;
        Q := ClientToScreen(P);            { Q is the TPoint for the screen }
        if ((Q.X<>OldQ.X) or (Q.Y<>OldQ.Y)) then
           begin
              Form2.Left:=Form2.Left+(Q.X-OldQ.X);
              Form2.Top:= Form2.Top +(Q.Y-OldQ.Y);
           end;
        OldQ:=Q;
      end;
end;

procedure TForm2.Panel1MouseUp(Sender: TObject; Button: TMouseButton;  {If right mouse button is raised then repaint form}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then  LBDown:=false;
  if (Button=mbRight) then Form4.Visible:=true;
end;


procedure TForm2.FormDestroy(Sender: TObject);
begin
   Top2:=Form2.Top;
   Left2:=Form2.Left;
end;


end.
