/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Brain;
import com.rexbot.game.card.ButtonLabel;
import com.rexbot.game.card.Counter;
import com.rexbot.game.card.CurrentPlayerLabel;
import com.rexbot.game.card.Hand;
import com.rexbot.game.card.History;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.card.Pot;
import com.rexbot.game.card.Table;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class Player
extends JPanel {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Player == null ? (class$com$rexbot$game$card$Player = Player.class$("com.rexbot.game.card.Player")) : class$com$rexbot$game$card$Player);
    private long bankroll = 0L;
    private long stake = 0L;
    private boolean current = false;
    public static final int HALT = -1;
    public static final int FOLD = 0;
    public static final int CALL = 1;
    public static final int RAISE = 2;
    public static final int HUMAN = 0;
    public static final int COMPUTER = 1;
    private Brain brain = null;
    private ButtonLabel buttonLabel = new ButtonLabel();
    private CurrentPlayerLabel currentPlayerLabel = new CurrentPlayerLabel();
    private long amountBetThisRound = 0L;
    private boolean button = false;
    private JPanel centerPanel;
    private Counter messageLabel;
    private Counter stakeLabel;
    private JPanel topPanel;
    private Hand hand;
    private int number = Integer.MIN_VALUE;
    private boolean folded;
    private int type = 1;
    private String message;
    static /* synthetic */ Class class$com$rexbot$game$card$Player;

    public Player(int number) {
        if (number > 10) {
            throw new RuntimeException("Player number greater than 10 not allowed! number=" + number);
        }
        this.initComponents();
        this.messageLabel.setBackground(Palette.backgroundColor);
        this.stakeLabel.setBackground(Palette.backgroundColor);
        this.topPanel.add((Component)this.currentPlayerLabel, "East");
        this.topPanel.add((Component)this.buttonLabel, "West");
        this.messageLabel.setBackground(Palette.backgroundColor);
        this.setNumber(number);
        this.stakeLabel.setText("$" + this.stake * (long)Opts.getInstance().getBetMultiplier());
        this.setPreferredSize(new Dimension(128, 192));
        this.setMinimumSize(new Dimension(128, 192));
        this.brain = new Brain(this);
        this.setMessage("", Color.black, Palette.backgroundColor);
    }

    public long makeDecision(long betToMe, long potSize, int playerPos) {
        if (this.getType() == 1) {
            long decision = this.brain.makeDecision(betToMe, potSize, playerPos);
            return decision;
        }
        long decision = Table.instance.getHumanInput().getDecision(betToMe);
        return decision;
    }

    public Brain getBrain() {
        return this.brain;
    }

    public long getAmountBetThisRound() {
        return this.amountBetThisRound;
    }

    public void setAmountBetthisRound(long amount) {
        this.amountBetThisRound = amount;
    }

    public void makeBet(Pot pot, long amount) {
        History.getInstance().add(this.getName() + " added " + amount + " into pot");
        if (amount < 0L) {
            throw new RuntimeException("Tried to make a negative bet! : amount=" + amount);
        }
        this.bankroll -= amount;
        this.stake -= amount;
        pot.addBet(amount);
        this.stakeLabel.setText("$" + this.stake * (long)Opts.getInstance().getBetMultiplier());
        this.setAmountBetthisRound(this.getAmountBetThisRound() + amount);
        this.repaint();
    }

    public void win(long amount) {
        cat.debug("Player: " + this.getNumber() + " wins: " + amount);
        this.bankroll += amount;
        this.stake += amount;
        this.stakeLabel.setText("$" + this.stake * (long)Opts.getInstance().getBetMultiplier());
        this.repaint();
    }

    public long getBankroll() {
        return this.bankroll;
    }

    public void setBankroll(long bankroll) {
        this.bankroll = bankroll;
    }

    public void setStake(long stake) {
        this.stake = stake;
        this.stakeLabel.setText("$" + stake * (long)Opts.getInstance().getBetMultiplier());
    }

    public long getStake() {
        return this.stake;
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.stakeLabel = new Counter();
        this.topPanel = new JPanel();
        this.messageLabel = new Counter();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(9, 136, 51));
        this.setOpaque(false);
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.centerPanel, gridBagConstraints);
        this.stakeLabel.setText("counter1");
        this.stakeLabel.setFont(new Font("SansSerif", 1, 18));
        this.stakeLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.stakeLabel, gridBagConstraints);
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setOpaque(false);
        this.add((Component)this.topPanel, new GridBagConstraints());
        this.messageLabel.setText("counter1");
        this.messageLabel.setFont(new Font("SansSerif", 0, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.messageLabel, gridBagConstraints);
    }

    public Hand getHand() {
        return this.hand;
    }

    public void setHand(Hand hand) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        if (this.hand != null) {
            this.centerPanel.remove(this.hand);
        }
        this.hand = hand;
        this.centerPanel.add((Component)hand, gbc);
        this.revalidate();
        this.repaint();
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        if (this.getType() == 0) {
            return "HUMAN(" + this.getNumber() + ")";
        }
        return "COMPUTER(" + this.getNumber() + ")";
    }

    public String toString() {
        return this.getName();
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setOnButton() {
        this.button = true;
        this.buttonLabel.turnOn();
    }

    public void setOffButton() {
        this.button = false;
        this.buttonLabel.turnOff();
    }

    public void setCurrentPlayer(boolean current) {
        this.current = current;
        if (current) {
            this.currentPlayerLabel.turnOn();
        } else {
            this.currentPlayerLabel.turnOff();
        }
    }

    public boolean isFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
        this.repaint();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setMessage(String message, Color borderColor, Color textColor) {
        this.messageLabel.setBackground(borderColor);
        this.messageLabel.setForeground(textColor);
        this.messageLabel.setText(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

