<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Customers</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}

function validate(form) {
      var result = confirm("Are you sure you want to DELETE the selected customer?");
		
		if(result)
		{	
			EDITCUSTOMER.DELETE.value='true';
			EDITCUSTOMER.submit();
			return true;
		}	
      else
		{
			return false;
		}
}
]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(EDITCUSTOMER.CUSTOMER)">


<CENTER><H1>Customers</H1></CENTER><P></P>
<P></P>

<xsl:choose>
<xsl:when test="MSI/EDITCUSTOMER/DELETE[.!='']">
<CENTER><H2 CLASS="status">Successfully Deleted Customer!</H2></CENTER><P></P>
<P></P>
</xsl:when>
</xsl:choose>
	


<FORM METHOD="POST" NAME="EDITCUSTOMER">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<INPUT TYPE="HIDDEN" NAME="recipient" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="subject" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="redirect" VALUE=""></INPUT>

<xsl:for-each select="MSI/EDITCUSTOMER/CUSTOMERLIST/CompanyTable">
<xsl:sort select="company_name" data-type="text" order="ascending"/>

<INPUT TYPE="HIDDEN">
	<xsl:attribute name="NAME"><xsl:value-of select="company_id"/></xsl:attribute>
	<xsl:attribute name="VALUE"><xsl:value-of select="company_name"/></xsl:attribute>
</INPUT>
</xsl:for-each>


<TABLE CELLPADDING="2" WIDTH="100%">

<TR><A>
<xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=515</xsl:attribute>
Add New Customer</A> 
</TR>

<TR>
<TD HEIGHT="15">
<xsl:text> </xsl:text>
</TD>
</TR>


<TR><TD WIDTH="30%" VALIGN="TOP">Please Select Customer to Edit</TD><TD WIDTH="70%" VALIGN="TOP"><SELECT NAME="CUSTOMER">

<xsl:for-each select="MSI/EDITCUSTOMER/CUSTOMERLIST/CompanyTable">
<xsl:sort select="company_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="company_name"/></xsl:attribute><xsl:value-of select="company_name"/>
</OPTION>
</xsl:for-each>



</SELECT>
</TD></TR>

<TR><TD WIDTH="30%" VALIGN="TOP"></TD><TD WIDTH="70%" VALIGN="TOP">
<!-- <INPUT TYPE="Radio" NAME="disValue" VALUE="526" CHECKED="true"> Edit Default Item List<BR></BR></INPUT> -->
<!-- <INPUT TYPE="Radio" NAME="disValue" VALUE="525"> Edit Company Information<BR></BR></INPUT> -->

<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="525"></INPUT>
<INPUT TYPE="HIDDEN" NAME="DELETE" VALUE="FALSE"></INPUT>

</TD></TR> 

<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" NAME="EDIT" VALUE="Edit"></INPUT><xsl:text>   </xsl:text><INPUT TYPE="BUTTON" NAME="DELETEBUTTON" VALUE="Delete" onClick="validate(this);"></INPUT></TD>
</TR>

</TABLE></FORM>

</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
