/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Category;

public class ImageIcon {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$ImageIcon == null ? (class$org$nakedobjects$object$ImageIcon = ImageIcon.class$("org.nakedobjects.object.ImageIcon")) : class$org$nakedobjects$object$ImageIcon));
    private static final String DIRECTORY = "images/";
    public static final int NORMAL = 32;
    public static final int SMALL = 16;
    private static Hashtable imageIcons = new Hashtable();
    private static MediaTracker mt = new MediaTracker(new Canvas());
    private static final Image largeUnknown = ImageIcon.loadAsResource("UnknownLarge.gif");
    private static final Image smallUnknown = ImageIcon.loadAsResource("UnknownSmall.gif");
    private String name;
    private int size;
    private String status;
    private Image image;
    static /* synthetic */ Class class$org$nakedobjects$object$ImageIcon;

    public ImageIcon(Image image, String string, int n, String string2) {
        this.image = image;
        this.name = string;
        this.size = n;
        this.status = string2;
        imageIcons.put(string + n + string2, this);
    }

    public Image getImage() {
        if (this.image == null) {
            throw new NullPointerException();
        }
        return this.image;
    }

    public static ImageIcon getImageIcon(String string, int n, String string2) {
        String string3 = string + n + string2;
        if (imageIcons.containsKey(string3)) {
            return (ImageIcon)imageIcons.get(string3);
        }
        Image image = ImageIcon.loadImage(string, n, string2);
        ImageIcon imageIcon = new ImageIcon(image, string, n, string2);
        return imageIcon;
    }

    public String getName() {
        return this.name;
    }

    private static Image loadAsFile(String string) {
        String string2 = DIRECTORY + string;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(string2);
        if (image != null) {
            mt.addImage(image, 0);
            try {
                mt.waitForAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (mt.isErrorAny()) {
                LOG.error((Object)("Failed to load image from file: " + string2));
                mt.removeImage(image);
                image = null;
            }
        }
        LOG.info((Object)("Image " + image + " loaded from file: " + string));
        return image;
    }

    private static Image loadAsResource(String string) {
        URL uRL = (class$org$nakedobjects$object$ImageIcon == null ? (class$org$nakedobjects$object$ImageIcon = ImageIcon.class$("org.nakedobjects.object.ImageIcon")) : class$org$nakedobjects$object$ImageIcon).getResource("/images/" + string);
        LOG.debug((Object)("Image from " + uRL));
        if (uRL == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image != null) {
            mt.addImage(image, 0);
            try {
                mt.waitForAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (mt.isErrorAny()) {
                LOG.error((Object)("Failed to load image from resource: " + uRL));
                mt.removeImage(image);
                image = null;
            }
        }
        LOG.info((Object)("Image " + image + " loaded from " + uRL));
        return image;
    }

    public static Image loadImage(String string) {
        Image image = ImageIcon.loadAsResource(string);
        if (image == null) {
            image = ImageIcon.loadAsFile(string);
        }
        if (image == null) {
            if (string.indexOf("16") > 0) {
                image = smallUnknown;
            } else if (string.indexOf("32") > 0) {
                image = largeUnknown;
            }
        }
        if (image == null) {
            LOG.error((Object)("No image loaded for: " + string));
        }
        return image;
    }

    public static Image loadImage(String string, int n, String string2) {
        String string3 = n == 0 ? string + string2 + ".gif" : string + n + string2 + ".gif";
        return ImageIcon.loadImage(string3);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String toString() {
        return "ImageIcon [name=" + this.name + ",size=" + this.size + ",size=" + this.status + ",image=" + this.image + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

