//==============================================================================
// BLIST.H -- Copyright  2000 Adam King
//
//		Basic Dynamic List
//==============================================================================
#ifndef BASICLIST_H
#define BASICLIST_H

#include "listerr.h"

#define	ID_LISTBASE	4000

struct BLIST_ITEM
{
	char *		szItem;
	BLIST_ITEM	*	NextItem;
};

enum BLIST_FINDRESULT
{
	BLIST_FR_FOUND,
	BLIST_FR_NONE
};

struct BLIST_FOUNDITEM
{
	BLIST_FINDRESULT	Res;
	BLIST_ITEM *	Item;
};

class BASICLIST
{
	BLIST_ITEM * 	BList;

	int		ItemCount;

public:
	BASICLIST();
	~BASICLIST();

	void Clear(void);

	LISTERR Add(char * szStr, BOOL keepDupes = FALSE, BOOL caseSens = TRUE);

	BLIST_ITEM * Pop();

	BLIST_ITEM * RemoveLastItem(void);

	BOOL RemoveString(char * str);

	BOOL FindStr(char * szStr, BOOL caseSens = TRUE);

	BLIST_FOUNDITEM InList(char * szStr, BOOL caseSens = TRUE);

	int Count();

	int GetItemCount() { return ItemCount; }

	BLIST_ITEM * GetTOS(void) { return BList; }

	BLIST_ITEM * GetNthItem(int n);

	char * GetNthStr(long n);

	BLIST_ITEM * GetStrItem(char * str);

	int GetStrPos(char * str);

	char * GetRandomItemStr();

	BLIST_ITEM * GetRandomItem();

	void FillList(HWND hList, BOOL reset = TRUE, long data = 0);

	void FillCombo(HWND hCombo, BOOL reset = TRUE);

	int FillMenu(HMENU hMenu, UINT BaseID, char maxNum);

	void SortAlpha(BOOL reversed = FALSE);

private:
	void Swap(int idx1, int idx2);
};

#endif
