{************************************************}
{                                                }
{   My Turbo Vision Demo                         }
{   Works well with Borland Pascal and Delphi    }
{   1996, Cosmin Truta <cosmint@cs.ubbcluj.ro>   }
{                                                }
{************************************************}

program MyTVDemo;

{$X+,S-}
{$M 16384,8192,655360}

uses
  Objects, Drivers, Views, Menus, Dialogs, App, Calendar;

type
  PMyTVDemo = ^TMyTVDemo;
  TMyTVDemo = object(TApplication)
    constructor Init;
    procedure About; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitDesktop; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

const
  cmAbout    = 1002;
  cmCalendar = 1003;

{ TMyTVDemo }
constructor TMyTVDemo.Init;
begin
  inherited Init;
  About;
end;

procedure TMyTVDemo.About;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 40, 11);
  D := New(PDialog, Init(R, 'About'));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Grow(-1, -1);
    Dec(R.B.Y, 3);
    Insert(New(PStaticText, Init(R,
      #13 +
      ^C'My Turbo Vision Demo'#13 +
      #13 +
      ^C'Author: Cosmin Truta'#13 +
      #13 +
{$IFDEF VER70}
      ^C'Compiled with Borland Pascal 7.0'
{$ELSE}
{$IFDEF VER80}
      ^C'Compiled with Borland Delphi 1.0'
{$ELSE}
      ^C'Compiled with <unknown compiler>'
{$ENDIF}
{$ENDIF}
    )));

    R.Assign(15, 8, 25, 10);
    Insert(New(PButton, Init(R, 'O~K', cmOk, bfDefault)));
  end;
  if ValidView(D) <> nil then
  begin
    Desktop^.ExecView(D);
    Dispose(D, Done);
  end;
end;

procedure TMyTVDemo.HandleEvent(var Event: TEvent);

procedure Calendar;
var
  P: PCalendarWindow;
begin
  P := New(PCalendarWindow, Init);
  InsertWindow(P);
end;

begin  { HandleEvent }
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      begin
        case Event.Command of
          cmAbout: About;
          cmCalendar: Calendar;
        else
          Exit;
        end;
        ClearEvent(Event);
      end;
  end;
end;

procedure TMyTVDemo.InitDesktop;
var
  R: TRect;
begin
  GetExtent(R);
  Dec(R.B.Y);
  New(Desktop, Init(R));
end;

procedure TMyTVDemo.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  R.B.X := R.A.X + 8;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~S~tart', hcNoContext, NewMenu(
      NewSubMenu('~P~rograms', hcNoContext, NewMenu(
        NewItem('~C~alendar', '', kbF3, cmCalendar, hcNoContext, nil)),
      NewItem('~A~bout...', '', kbF1, cmAbout, hcNoContext,
      NewLine(
      NewItem('Sh~u~t down', '', kbAltF4, cmQuit, hcNoContext, nil))))),
    nil))));
end;

procedure TMyTVDemo.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  Inc(R.A.X, 8);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbAltX, cmQuit,
      NewStatusKey('', kbF1, cmAbout,
      NewStatusKey('', kbF3, cmCalendar,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbF5, cmZoom,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF6, cmNext,
      NewStatusKey('', kbShiftF6, cmPrev,
      NewStatusKey('', kbF10, cmMenu,
      nil))))))))),
    nil)));
end;

var
  Demo: TMyTVDemo;

begin
  Demo.Init;
  Demo.Run;
  Demo.Done;
end.
