/*
 *  UNDIGEST.C
 *
 *  Source code for a program to split a digest into individual news messages
 *  into a specific directory.
 *
 *  Authors: Roy Silvernail and James Copland.
 *
 *  Syntax:
 *  undigest [-? |-c |-d |-H |-m news_group |-t ] < digest_file_name
 *
 *  Example: undigest -m pc.digest < d:\news\comp\sys\ibm\pc\digest\32.
 *
 *  delivers news items to the pc.digest group from the items in the
 *  d:\news\comp\sys\ibm\pc\digest\32. IBM PC DIGEST file.
 *
 *  Compiled under Quick C 2.5 and Turbo C++ 1.01
 *
 *  Version 2.2:  11/25/93  Fixed the version number reported.  Fixed
 *                          Newsgroups: line for digest headers, when
 *                          undigesting mail digests.  Under certain
 *                          circumstances, undigest would lose the last
 *                          article in a digest... fixed.  Temp files
 *                          moved to temporary directory.  (Cnews sites
 *                          may not have a /spool/unbatch)
 *
 *  Version 2.1:  11/14/93  Fixed bug which added a space to the end of
 *                          the Newsgroups: line.
 *
 *  Version 2.0:  6/13/93   Added batching of articles for rnews, and
 *                          explicit support for Ralf Brown's SPAWNO
 *                          package.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *
 */

#define SHORT 0               /* for usage() */
#define LONG 1
#define BRAG 2

#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>       /* needed for isspace(), below  rms */
#include <io.h>
#include "waffle.h"

#ifdef USE_SPAWNO

#include <spawno.h>

#endif

#ifdef __TURBOC__

#include <conio.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <process.h>
#include <dir.h>

#ifdef USE_WAFLIB           /* from my Waffle lib, */
#define system wsystem      /* which isn't distributed.  rms */
#endif

#ifndef L_tmpnam
#define L_tmpnam 15  /* Original size of temporary fname set by rms.  */
#endif               /* Defined in stdio.h by QC.  jc */

#ifndef _MAX_PATH
#define _MAX_PATH MAXPATH  /* Compatibility. rms */
#endif

#endif

/* Declare other functions in this file jc */

void usage(int x);            /* jc */
void write_header(void);      /* jc */
void write_count(void);       /* jc */

/* Data or variables */


char  buf[1024], path[1024], rnews[_MAX_PATH], group[_MAX_PATH] = {""};
char  fname[L_tmpnam], *tmpstr1, dash70[72], spool[_MAX_PATH];
int   new = 0, num = 1, mail = 0, i = 1;
int   keep_header = 1, /* rms */ keep_trailer = 0, was_from, was_date; /* jc */
int   msg_id; /* rms */
FILE  *outfile, *infile;
char  *params[] = { "waffle","temporary","node", NULL };
long  header, start, end;
fpos_t pos, pos1;
struct tm *timeptr;
time_t ltime;

int main(int argc, char *argv[])
{
  if (argc > 1) {                 /* Parse Switches */
    while (i < argc && argv[i][0] == '-') {
      if (argv[i][1] == '?') {    /* If help wanted */
        usage(SHORT);             /* tell'm how it works */
        exit(-1);
      }                           /* and get out */
      if (argv[i][1] == 'H') {
        usage(LONG);
        exit(-2);
      }
      if (argv[i][1] == 'c') {
        usage(BRAG);
        exit(-3);
      }
      if (argv[i][1] == 'm') {    /* If user specified  newsgroup */
        mail = 1;                 /* Set flag */
        strcpy(group, argv[++i]); /* Copy newsgroup */
      }
      else if (argv[i][1] == 't') {   /* If output trailer switch */
             keep_trailer = 1;        /* Set keep trailer flag */
           }
      else if (argv[i][1] == 'd') {   /* If drop header switch */
             keep_header = 0;         /* Reset keep header flag */
           }
      ++i;
    };                                /* end while */
  }                                   /* end if(argc>1) */

  /* Initialize subsystems and memory and sign on */

  winitenv(params);
  memset(&dash70[0], '-', 70);
  dash70[70] = '\n';
  dash70[71] = '\0';
  SetIDFormat("%s.gated.by.undigest");
#ifdef _QC
  init_SPAWNO(".",SWAP_ANY);
#endif
  fprintf(stderr, "Undigest 2.2 is Copyright (C) 1993 by Roy Silvernail & James Copland.\n");
  fprintf(stderr, "Undigest 2.2 must be distributed without fee or charge.\n");

  /* Make Rnews line */

  strcpy(buf,wgetenv("waffle"));
  if (buf[0] == '\0') {
    fprintf(stderr, "undigest: Please set the \"waffle: \" line in /waffle/system/static to the\n");
    fprintf(stderr, "          correct value for your system and then rerun me.\n");
    exit(-1);
  }
  sprintf(rnews, "%s/BIN/RNEWS", buf);
  tmpstr1 = rnews;            /* Normalize "/" to "\" */
  while (*tmpstr1) {
    if (*tmpstr1 == '/') *tmpstr1 = '\\';
    tmpstr1++;
  }

  /* Make output file name */

  strcpy(buf,wgetenv("temporary"));
  if (buf[0] == '\0') {
    fprintf(stderr, "undigest: Please set the \"temporary: \" line in /waffle/system/static to the\n");
    fprintf(stderr, "          correct value for your system and then rerun me.\n");
    exit(-1);
  }
  sprintf(spool, "%s/BATCH4.", buf);
  tmpstr1 = spool;            /* Normalize "/" to "\" */
  while (*tmpstr1) {
    if (*tmpstr1 == '/') *tmpstr1 = '\\';
    tmpstr1++;
  }
#ifdef DEBUG
  fprintf(stderr, "undigest: rnews == %s\n          spool == %s\n", rnews, spool);
#endif
  if ((outfile = fopen(spool, "wb")) == NULL) {
    perror("undigest: Spool file problem ! ");
    exit(-1);
  }
#ifdef DEBUG
  if (freopen("D:\\NEWS\\BISON\\SCI\\HOMEBREW\\4.", "r", stdin) == NULL) {
    perror("undigest: Can't open input file! ");
    exit(-1);
  }
#endif

/* Assume we are in the digest header and get the path line for later */

 fgets(path, sizeof(path), stdin);
 if (keep_header) {
   write_header();
   fputs(path, outfile);
   if(group[0] != '\0') {
     fprintf(outfile, "Newsgroups: %s\n", group); /* for mail digests */
   }
 }

 /*
  *  We're breaking up compliant digests, so the first
  *  separator is supposed to be 70 dashes.  Also, there's
  *  no need to have this loop duplicated.  keep_header
  *  code made conditional.  rms
  */

 while (fgets(buf, sizeof(buf), stdin) && strcmp(dash70, buf) != 0) {
   if (strncmp("Newsgroups:", buf, 11) == 0) {
     if (group[0] == '\0')                    /* If no user defined group */
       sscanf(buf,"Newsgroups: %s ", group);  /* use the digest group */
       sprintf(buf, "Newsgroups: %s\n", group);  /* print correct group for rnews */
   }
   if (keep_header) fputs(buf, outfile);
 }                                /* end of while in header */

 printf("undigest: Undigesting articles to %s\n", group);
 if (keep_header) {
   write_count();
#ifdef DEBUG
   fprintf(stderr, "undigest: Posting digest header\n");
#endif
 }                                /* End of 2nd if (keep_header) */

 /* Now in digest body */

 /*
  * all instances of !isalnum changed to isspace.  It's a subtle
  * difference, but we're really looking for spaces, not
  * (non-alpha && non-number).
  */

 while (fgets(buf, sizeof(buf), stdin)) {   /* While not EOF, read a line */
   if (new == 0 && isspace(buf[0])) continue;
   if (new == 0) {
     new = 1;
     msg_id = 0;
     was_from = (!(strnicmp(buf,"From:",5)))?1:0;   /* jc */
     was_date = (!(strnicmp(buf,"Date:",5)))?1:0;   /* jc */
     write_header();
     if (!mail) fputs(path, outfile);
     fputs(buf, outfile);
     fprintf(outfile, "Newsgroups: %s\n", group);  /* print correct group for rnews */
     continue;
   }                              /* End if (new == 0) */
   if (new == 1) {
     if (strcmp("------------------------------\n", buf) == 0) {
       write_count();
#ifdef DEBUG
       fprintf(stderr, "undigest: posting digest article %d\n", num++);
#endif
       if (fgetpos(stdin,&pos)) perror("Fgetpos 1 failled");  /* jc */
       new = 0;
       continue;
     }                            /* End if (strcmp(...) == 0) */
    if (isspace(buf[0]) && !msg_id) {
       fputs(MakeMsgID("\n"), outfile);
       msg_id = 1;
    }                            /* End if (isspace(buf[0]) && !msg_id) */
     if (strnicmp(buf,"Message-ID:",11) == 0) msg_id = 1;
     if (strnicmp(buf,"From:",5) == 0) was_from = 1;   /* jc */
     if (strnicmp(buf,"Date:",5) == 0) was_date = 1;   /* jc */
   }                              /* End if (new == 1) */
   fputs(buf, outfile);           /* write a line. */
 }                                /* End while not EOF */

/*
 *  We've gone past the trailer, if there was one so,
 *
 *  If there was a trailer,
 *    backspace input to start of last message,
 *    backspace output to the last header.
 *  If we want to keep the trailer:
 *     write_header() output,
 *     write the message headers,
 *     if the last message was a trailer,
 *        while not eof on input copy input to output,
 *     else,
 *        write a fixed message.
 *     write_count() output.
 *  move input to the end of file.
 *  truncate output.  rms
 *  close output.
 *  system("rnews output").
 *  exit(0).
 *
 *                           jc
 */

 if (!(was_from && was_date)) {   /* If the last message was a trailer */
   fgetpos(stdin, &pos1);         /* Get stdin position to restore         */
   fsetpos(stdin, &pos);          /* Set stdin to start of digest trailer  */
   fseek(outfile, header, SEEK_SET);  /* backspace output to the last header */
   if (keep_trailer) {
#ifdef DEBUG
     fprintf(stderr, "undigest: posting digest trailer\n");
#endif
     write_header();
     time(&ltime );               /* make the message headers */
     timeptr = localtime(&ltime );
     strftime(buf, (size_t) 36, "%a, %d %b %y %X %z", timeptr );
     fprintf(outfile, "Newsgroups: %s\n", group); /* Write the message headers */
     fprintf(outfile, "Date: %s\n", buf);
     fprintf(outfile, "From: Undigest@%s\n", wgetenv("node"));
     fprintf(outfile, "Subject: Digest Trailer\n");
     fprintf(outfile, "%s \n", MakeMsgID("\n"));
     if (!(was_from && was_date)) {  /* If the last message was a trailer */
       while (fgets(buf, sizeof(buf), stdin))   /* While not EOF, read a line */
           fputs(buf, outfile);              /* write a line. */
     } else {
       fprintf(outfile, "This digest had no Trailer.\n");
     };                 /* End if (!(was_from && was_date)) */
     write_count();
     header = end;
     fsetpos(stdin, &pos1);           /* restore stdin position. */
   } else {                   /* End if (keep_header) */
    chsize(fileno(outfile),header);  /* rms */
   }

 } else {
   write_count();
 }

 fclose(outfile);                 /* Close the batch2 file */
 sprintf(buf, "%s < %s", rnews, spool);
 if(system(buf)) perror("undigest: rmail returned an error"); /* run rmail */
 return (0);                      /* and exit. */
}

void write_header(void)
{
 long int result;
 char buf1[21];

 result = 0;
 sprintf(buf1, "#! rnews %010.10lu\n",result);
 header = ftell(outfile);
 fputs(buf1, outfile);
 start = ftell(outfile);
}

void write_count(void)
{
 long int result;
 char buf2[21];

 end = ftell(outfile);
 result = (end - start);
 sprintf(buf2, "#! rnews %010.10lu\n",result);
 fseek(outfile, header, SEEK_SET);
 fputs(buf2, outfile);
 fseek(outfile, end, SEEK_SET);
}

void usage(int verbose)
{
 fprintf(stderr, "Usage: undigest [-? |-c |-d |-H |-m news_group |-t ] < digest_file_name\n");
 if (verbose == SHORT) {
   fprintf(stderr, "\tundigest -H for help\n");
 } else if (verbose == LONG) {
       fprintf(stderr, "\n\
Options:\n\
\n\
    -c  see who wrote this thing      -d  don't post the header\n\
    -m  post to this newsgroup        -t  post the digest trailer, too\n\
    -?  pointer to this help          -H  this help\n\
\n\
For digests in a newsgroup, such as comp.sys.ibm.pc.digest, simply\n\
\n\
undigest < articlename\n\
\n\
For mailed digests, with no Newsgroups: line, use\n\
\n\
undigest -m newsgroup.name < mailed digest file\n\
\n\
To gate a digest to a newsgroup within Waffle, use the alias\n\
\n\
address | c:\\waffle\\bin\\undigest.exe -m newsgroup.name\n");
 } else if (verbose == BRAG) {
       fprintf(stderr, "\
\n\
Undigest written by Roy M. Silvernail for Turbo C++.\n\
Quick C contributions and a couple of nice features by\n\
magus@brewhau.bison.mb.ca (James C. Copland)\n\
who welcomes the \"tip of the virtual hat\".\n\
\n");
 }
}
