/*
Function: int mvfile(char *oldpath, char *newpath)
Purpose : Move file using rename or copy.
Params  : oldpath = path to file to be moved including filename
          newpath = full path to new directory, no filename
Return  : zero on success, non zero on error and set _errbuf.
*/

int mvfile(char *oldpath, char *newpath)
{
  FILE *finalfile = NULL;
  FILE *oldfile = NULL;
  char finalpath[MAXPATH];
  char drive[MAXDRIVE];
	char dir[MAXDIR];
	char file[MAXFILE];
  char ext[MAXEXT];
  char cpbuf;
  int  flags;

  mkdir(newpath);
  strcpy(finalpath,newpath);
  flags = fnsplit(oldpath,drive,dir,file,ext);
  if (flags & FILENAME)
  {
    strcat(finalpath,"\\");
    strcat(finalpath,file);
  }
  else
  {
    sprintf(_errbuf,"no filename specified: %s",oldpath);
    goto ErrorExit;
  }
  if (flags & EXTENSION) strcat(finalpath,ext);
  if (flags & DRIVE)
  {
    if (drive[0] == finalpath[0])
    {
      if (rename(oldpath,finalpath) != 0)
      {
        sprintf(_errbuf,"rename failed: %s",strerror(errno));
        goto ErrorExit;
      }
    }
    else
    {
      if ((oldfile = fopen(oldpath,"rb")) == NULL)
      {
        sprintf(_errbuf,"error opening %s for read",oldpath);
        goto ErrorExit;
      }
      if ((finalfile = fopen(finalpath,"wb")) == NULL)
      {
        sprintf(_errbuf,"error opening %s for write",finalpath);
        goto ErrorExit;
      }
      cpbuf = getc(oldfile);
      while (!feof(oldfile))
      {
        fprintf(finalfile,"%c",cpbuf);
      }
      fclose(finalfile);
      fclose(oldfile);
      unlink(oldpath);
  }
  else
  {
    if (rename(oldpath,finalpath) != 0)
    {
      sprintf(_errbuf,"rename failed: %s",strerror(errno));
      goto ErrorExit;
    }
  }
GoodExit:
  return 0;
ErrorExit:
  if (finalfile) fclose(finalfile);
  if (oldfile) fclose(oldfile);
  return 1;
}
