{===========================================================================}
{                                                                           }
{                    Unit LMouse                  }
{                    Release 1.0                  }
{                                                                           }
{               CREATED BY Dr. LUIS  VACA         }        
{                  All Rights Reserved            }
{                                                                           }
{  " Promote Programming ... Register !!!"                                  }
{===========================================================================}

Unit EMouse;
INTERFACE

TYPE

   Point      = Record
            X,Y : Integer;
   END;

   Rect       = Record
            A,B : Point;
   END;

   AMouse      = Record
             Event : Integer;
             P     : Point;
   END;

   AnyKey      = Record
         ScanCode  : Word;
         CharCode  : Char;
         ASCII     : Boolean;
         Extended  : Boolean;
   END;

   Eventype = Record
                    Command   : Word;
                    Key       : AnyKey;
                    Mouse     : AMouse;
   END;


   SystemTime = Record
                Hour : Word;
                Min  : Word;
                Sec  : Word;
                uec  : Word;
   END;




     { KeyS OBTAINED FROM INTERRUPT $16, SERVICES $2 AND $10  }
{ NOTE: THIS NUMBERS DO NOT CORRESPOND WITH TP SCAN CODES, THEREFORE IS
 USELESS TO USE TP FUNCTIONS ORD () OR CHR () TO MANIPULATE THIS NUMBERS }

CONST
     Sk_ScrollLock	= $10;
     Sk_NumLock		= $20;
     Sk_CapsLock	= $40;
     Sk_InsLock		= $80;

     Key_ESC		= $01;
     {       ASCII Keys      }
     Key_A		= $1E;
     Key_B		= $30;
     Key_C		= $2E;
     Key_D		= $20;
     Key_E		= $12;
     Key_F		= $21;
     Key_G		= $22;
     Key_H		= $23;
     Key_I	        = $17;
     Key_J		= $24;
     Key_K		= $25;
     Key_L		= $26;
     Key_M		= $32;
     Key_N		= $31;
     Key_O		= $18;
     Key_P		= $19;
     Key_Q		= $10;
     Key_R		= $13;
     Key_S		= $1F;
     Key_T		= $14;
     Key_U		= $16;
     Key_V		= $2F;
     Key_W		= $11;
     Key_x		= $2D;
     Key_Y		= $15;
     Key_Z		= $2C;

     {     Number Keys       }
     Key_1		= $02;
     Key_2		= $03;
     Key_3		= $04;
     Key_4		= $05;
     Key_5		= $06;
     Key_6		= $07;
     Key_7		= $08;
     Key_8		= $09;
     Key_9		= $0A;
     Key_0		= $0B;

     {       F Keys         }
     Key_F1		= $3B;
     Key_F2		= $3C;
     Key_F3		= $3D;
     Key_F4		= $3E;
     Key_F5		= $3F;
     Key_F6		= $40;
     Key_F7		= $41;
     Key_F8		= $42;
     Key_F9		= $43;
     Key_F10		= $44;
     Key_F11		= 133;
     Key_F12		= 134;

     {      Edit Keys        }
     Key_Space		= $39;
     Key_Enter		= $1C;
     Key_Tab		= $0F;
     Key_SysReq		= $54;
     Key_BackSpace	= $0E;
     Key_Ins		= $52;
     Key_Del		= $53;
     Key_CtrlHome       = 123;
     Key_AltSpace       = $A;

     {     Arrow Keys        }
     Key_Home		= $47;
     Key_UpArrow	= $48;
     Key_PgUp		= $49;
     Key_LeftArrow	= $4B;
     Key_RightArrow	= $4D;
     Key_DownArrow	= $50;
     Key_End		= $4F;
     Key_PgDn		= $51;

     { Keys from center pad }
     Key_NumLock	= $45;
     Key_ScrollLock	= $46;
     Key_Ctrl		= $04;
     Key_Shift          = $02;
     Key_Alt		= $08;
     Key_CapsLock 	= $3A;

     { Keys from numeric pad }
     Key_Minus		= $0C;
     Key_Equal		= $0D;
     Key_Period		= $34;
     Key_LBracket 	= $1A;
     Key_RBracket 	= $1B;
     Key_Coma		= $33;
     Key_Semi		= $27;
     Key_Rquote		= $28;
     Key_Lquote		= $29;
     Key_asterisk 	= $37;
     Key_GrayMinus	= $4A;
     Key_Center5	= $4C;
     Key_GrayPlus 	= $4E;

     Key_BackSlash	= $2B;
     Key_ForwSlash	= $35;

    {       Shift and number symbols      }
     Key_Number         = Key_Shift + Key_3;
     Key_Dollar         = Key_Shift + Key_4;
     Key_Percent        = Key_Shift + Key_5;
     Key_And            = Key_Shift + Key_7;
     Key_Underline      = Key_Shift + Key_minus;
     Key_Plus           = Key_Shift + Key_equal;


{################# Mouse CONSTANTS ###################}

TYPE
    MaskType = Array[0..1, 0..15] of Word;


CONST      {############ ALL THE GOODIE Mouse SHAPES ############}

   Standard: MaskType =
     (($3FFF,$1FFF,$0FFF,$07FF,$03FF,$01FF,$00FF,$007F,    { <-- Screen Mask }
       $003F,$001F,$01FF,$10FF,$30FF,$F87F,$F87F,$FC7F),

      ($0000,$4000,$6000,$7000,$7800,$7C00,$7E00,$7F00,    { <-- Cursor Mask }
       $7F80,$7C00,$6C00,$4600,$0600,$0300,$0300,$0000));

   PointingHand: MaskType =
     (($E1FF,$E1FF,$E1FF,$E1FF,$E1ff,$E000,$E000,$E000,   
       $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000),

      ($1E00,$1200,$1200,$1200,$1200,$13ff,$1249,$1249,   
       $1249,$9001,$9001,$9001,$8001,$8001,$8001,$FFFF));

   HourGlass: MaskType =
     (($0000,$0000,$0000,$0000,$8001,$C003,$E007,$F00F,
       $E007,$C003,$8001,$0000,$0000,$0000,$0000,$FFFF),

      ($0000,$7FFE,$6006,$300C,$1818,$0C30,$0660,$03C0,
       $0660,$0C30,$1998,$33CC,$67E6,$7FFE,$0000,$0000));

   MaskQUESTION : Masktype =
     (($FFFF,$C00F,$800F,$800F,$878F,$8F8F,$F80F,$F00F,
       $F01F,$F0FF,$F1FF,$F1FF,$F1FF,$F1FF,$F1FF,$FBFF),

      ($0000,$0000,$0FE0,$3020,$2020,$0020,$0060,$0380,
       $0600,$0400,$0400,$0400,$0400,$0000,$0400,$0000));

   DiagCross: MaskType =
     (($07E0,$0180,$0000,$C003,$F00F,$C003,$0000,$0180,
       $07E0,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

      ($0000,$700E,$1C38,$0660,$03C0,$0660,$1C38,$700E,
       $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

   CheckMark: MaskType =
     (($FFF0,$FFE0,$FFC0,$FF03,$0607,$000F,$001F,$C03F,
       $F07F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

       ($0000,$0006,$000C,$0018,$0030,$0060,$70C0,$1D80,
	$0700,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

   MaskCursor : Masktype =
     (($07FF,$07FF,$07FF,$8FFF,$8FFF,$8FFF,$8FFF,$8FFF,
       $8FFF,$8FFF,$8FFF,$07FF,$07FF,$07FF,$FFFF,$FFFF),

      ($0000,$7000,$2000,$2000,$2000,$2000,$2000,$2000,
       $2000,$2000,$2000,$2000,$7000,$0000,$0000,$0000));

   MaskResizeBack : Masktype =
     (($00FF,$01FF,$03FF,$01FF,$20EF,$704F,$F80F,$FC0F,
        $FE0F,$FC0F,$F80F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

      ($0000,$7C00,$7800,$5C00,$0E00,$0700,$03A0,$01E0,
       $00E0,$01E0,$0000,$0000,$0000,$0000,$0000,$0000));

   MaskResizeForw : Masktype =
     (($F00F,$F80F,$FC0F,$F80F,$704F,$20EF,$01FF,$03FF,
       $07FF,$03FF,$01FF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

      ($0000,$03E0,$01E0,$03A0,$0700,$0E00,$5C00,$7800,
       $7000,$7800,$0000,$0000,$0000,$0000,$0000,$0000));


   MaskResizeVert : Masktype =
     (($FE7F,$FC3F,$F81F,$F00F,$E007,$FC3F,$FC3F,$FC3F,
       $FC3F,$FC3F,$FC3F,$E007,$F00F,$F81F,$FC3F,$FE7F),

      ($0000,$0180,$03C0,$07E0,$0180,$0180,$0180,$0180,
       $0180,$0180,$0180,$0180,$07E0,$03C0,$0180,$0000));


   MaskResizeHor : Masktype =
     (($FFFF,$F7EF,$E7E7,$C7E3,$8001,$0000,$0000,$8001,
       $C7E3,$E7E7,$F7EF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

      ($0000,$0000,$0000,$1008,$300C,$7FFE,$7FFE,$300C,
       $1008,$0000,$0000,$0000,$0000,$0000,$0000,$0000));


   MaskTCross : Masktype =
     (($FC7F,$F83F,$F01F,$D837,$8C63,$0001,$0001,$0001,
       $8C63,$DC77,$F83F,$F01F,$F83F,$FC7F,$FFFF,$FFFF),

      ($0100,$0380,$07C0,$0100,$2108,$610C,$FFFE,$610C,
       $2108,$0100,$0100,$07C0,$0380,$0100,$0000,$0000));


{############ Mouse AND KeyBOARD FUNCTION INTERRUPTS ############}

PROCEDURE GraphicsMouse(Mask: MaskType; X,Y : Integer);
PROCEDURE MouseCursor(Mask : Masktype; X,Y : Integer);
PROCEDURE TextMouse;
PROCEDURE ShowMouse;
PROCEDURE HideMouse;
FUNCTION MouseStatus(VAR X,Y:Integer):Integer;
FUNCTION MouseinR(VAR P: Point; VAR R : Rect) : Boolean;
PROCEDURE ResetMouse;
PROCEDURE MoveMouse(X,Y : Integer);
PROCEDURE MouseInit;
PROCEDURE MouseBox(BX,by,bx1,by1 : Word);
PROCEDURE MouseMinMax(X,Y,x1,y1:Integer);
FUNCTION GetKey(VAR aChar: char; VAR isExtended: Boolean): Word;
FUNCTION GetEvent(VAR E : Eventype): Boolean;
PROCEDURE ClearEvent(VAR E : Eventype);
FUNCTION DoubleClick ( P : point): Boolean;
PROCEDURE Quit(msg : string);
PROCEDURE GetCounter(VAR Counter:SystemTime);
PROCEDURE ResetCounter(VAR Counter:SystemTime);
PROCEDURE GetLap(VAR Counter:SystemTime);
PROCEDURE Beep;
PROCEDURE Wait(n:Integer);
PROCEDURE Bell(tone, duration, rep : Integer);
PROCEDURE TextCursor(OnOff : Boolean);
FUNCTION LastxPress(Button : Byte) : Word;
FUNCTION LastYPress(Button : Byte) : Word;
FUNCTION KBFlag : Word;



CONST

     Left_Button_Released   = 4;
     Right_Button_Released  = $10;
     Left_Button_Pressed    = 2;
     Right_Button_Pressed   = 8;
     Mouse_Moving           = 1;
     Mouse_Interrupt     = $33;

TYPE
  Mouse_Event_Rec =
    record
      Event          : Word;
      Button_Status  : Word;
      Row            : Word;
      Col            : Word;
    END;


    Box      =
    record
     X,Y,
     x1,y1 : Word;
    END;



VAR
  Mouse          : Mouse_Event_Rec;
  MouseExists    : Boolean;
  InGraphics     : Boolean;
  HideBox        : Box;
  Event          : Boolean;


IMPLEMENTATION

USES
    CRT, DOS;     {<----- I'M USING TP'S CRT HERE ,THIS TPU CAN NOT BE USED LATTER }

{$F+ }


PROCEDURE Quit(msg : string);
BEGIN
     HideMouse; { HIDE Mouse AND TERMINATE INTERRUPT BEFORE QUITING }
     Clrscr;
     TextMode(LastMode);   { RESTORE SCREEN MODE }
     Writeln (msg);        { QUIT WITH MESSAGE }
     Halt(0);              { TERMINATE PROGRAM }
END;


{############ SHOW HIDE TExT BLINKING CURSOR ############}
PROCEDURE TextCursor(OnOff : Boolean);
CONST
    HideCursor = 32;  {<----- THIS WILL HIDE THE BLINKING TExT CURSOR }
VAR
   Reg : registers;
Begin
     Reg.AH := $01;
     If OnOff then
     Reg.CH := 1      {<------ THIS RESTORES (SHOWS) THE CURSOR }
     ELSE
     Reg.CH := HideCursor; 
     Reg.CL := 14;
     INTR($10, Reg);
end;

{############ MAKE A TONE ############}
PROCEDURE Beep;
BEGIN
  Sound(500); Delay(25); NoSound;
END;

{############ MORE SOPHISTICATED SOUND ############}
PROCEDURE Bell(tone, duration, rep : Integer);
VAR
   X : Integer;
BEGIN
     For X:=1 to Rep Do
                       BEGIN
                            Sound(tone);
                            Delay(duration);
                            NoSound;
                       END;
END;

{############ REPLACEMENT FOR TP'S DELAY ############}
PROCEDURE Wait(n:Integer);
BEGIN
     Delay(n);
END;

{############ RESET A TIME COUNTER ############}
PROCEDURE ResetCounter(VAR Counter:SystemTime);
BEGIN
    Counter.hour:=0;
    Counter.min :=0;
    Counter.sec :=0;
    Counter.uec :=0;
END;

{############ START A COUNTER ############}
PROCEDURE GetCounter(VAR Counter:SystemTime);
BEGIN
     Counter.uec := (Counter.uec + 1);
     if Counter.uec > 60 then
                             BEGIN
                                  inc(Counter.sec);
                                  Counter.uec := 0;
                             END;

     if Counter.sec > 60 then
                             BEGIN
                                  inc(Counter.min);
                                  Counter.sec := 0;
                             END;

     if Counter.min > 60 then
                             BEGIN
                                  inc(Counter.hour);
                                  Counter.min := 0;
                             END;

     if Counter.hour > 24 then Counter.hour :=0;

END;

{############ GET ELAPSED TIME SINCE LAST CALL ############}
PROCEDURE GetLap(VAR Counter:SystemTime);
BEGIN
    GetTime(Counter.hour,Counter.min,Counter.sec,Counter.uec);
END;


{ CHECK FOR SPECIAL KeyS SUCH AS ALT, CNTRL OR SHIFT }
FUNCTION KBFlag : Word;
VAR
  Reg : Registers;
BEGIN
     Reg.AH := $02;
     INTR ($16, Reg);
     KBFlag:= (Reg.AL);      { CHECK Key BUFFER FOR SPECIAL KeyS }
END;


{############ THIS IS THE HEART OF THE KeyBOARD INTERRUPT ############}
FUNCTION GetKey(VAR aChar: char; VAR isExtended: Boolean): Word;


CONST
    Key_lShift = $01;
    Key_rShift = $02;
VAR
  Reg      :     Registers;
  ExtKey   :     Word;
  aKey     :     Word;
  Spec     :     Boolean;
BEGIN
     Spec:= FALSE;
     Reg.AH := $10;
     INTR ($16, Reg);
     aKey:= Word(Reg.AH);
     aChar:= Chr(Reg.AL);
     ExtKey := KBFlag;
     If (ExtKey AND Key_Ctrl) <> 0 then
        BEGIN
             aKey  := (aKey + Key_Ctrl);
             Spec  := TRUE;
        END ELSE
     If (ExtKey AND Key_Alt) <> 0 then
        BEGIN
             aKey  := (aKey + Key_Alt);
            Spec   := TRUE;
        END ELSE
     If (ExtKey AND Key_lShift) <> 0 then
        BEGIN
             aKey  := (aKey + Key_Shift);
            Spec   := TRUE;
        END ELSE
     If (ExtKey AND Key_rShift) <> 0 then
        BEGIN
             aKey  := (aKey + Key_Shift);
            Spec   := TRUE;
        END;
     IsExtended:= Spec;
     GetKey:= aKey;
END;

{############ THIS IS THE LOOP THAT POOLS Mouse AND KeyBOARD IN ONE PASS ############}
FUNCTION GetEvent(VAR E : Eventype): Boolean;
VAR
   ms,X,Y       : Integer;
   Event        : Boolean;
BEGIN
    E.Command       := 0;
    E.Key.CharCode  := ' ';
    E.Key.ScanCode  := 0;
    E.Key.ASCII     := FALSE;
    E.Key.Extended  := FALSE;
    E.Mouse.Event   := 0;
    E.Mouse.P.X     := 0;
    E.Mouse.P.Y     := 0;
    Event:=FALSE;
    { CHECK Mouse FIRST }
    MS:= Mousestatus(E.Mouse.P.X,E.Mouse.P.Y);
    if (MS <> 0) then  { IF A Mouse Event GET IT }
                         BEGIN
                              { WHICH Mouse Event ? }
                              E.Mouse.Event:=MS;
                              Event:=TRUE;
                         END;
   { CHECK KeyBOARD }
   If KeyPressed then   { IF A Key PRESSED GET IT }
                        BEGIN
                             E.Key.ScanCode := GetKey(E.Key.CharCode, E.Key.Extended);
                             E.Key.ASCII := (E.Key.ScanCode In[Key_1 .. Key_0])
                                         OR (E.Key.ScanCode In[Key_Q .. Key_M])
                                         OR (E.Key.ScanCode = Key_Space)
                                         OR (E.Key.ScanCode = Key_BackSlash)
                                         OR (E.Key.ScanCode = Key_ForwSlash)
                                         OR (E.Key.ScanCode = Key_Number   )
                                         OR (E.Key.ScanCode = Key_Dollar   )
                                         OR (E.Key.ScanCode = Key_Percent  )
                                         OR (E.Key.ScanCode = Key_And      )
                                         OR (E.Key.ScanCode = Key_Underline)
                                         OR (E.Key.ScanCode = Key_Plus     )
                                         OR (E.Key.ScanCode = Key_Minus    )
                                         OR (E.Key.ScanCode = Key_Equal	   )
                                         OR (E.Key.ScanCode = Key_Period   )
                                         OR (E.Key.ScanCode = Key_LBracket )
                                         OR (E.Key.ScanCode = Key_RBracket )
                                         OR (E.Key.ScanCode = Key_Coma	   )
                                         OR (E.Key.ScanCode = Key_Semi	   )
                                         OR (E.Key.ScanCode = Key_Rquote   )
                                         OR (E.Key.ScanCode = Key_Lquote   )
                                         OR (E.Key.ScanCode = Key_asterisk );
                             Event:=TRUE;
                        END;
    GetEvent:= Event;
END;

{############ RESET AN Event MESSAGE ############}
PROCEDURE ClearEvent(VAR E : Eventype);
BEGIN
    E.Command       := 0;
    E.Key.ScanCode  := 0;
    E.Key.CharCode  := ' ';
    E.Key.ASCII     := FALSE;
    E.Key.Extended  := FALSE;
    E.Mouse.Event   := 0;
    E.Mouse.P.X     := 0;
    E.Mouse.P.Y     := 0;
END;

{############ ALL Mouse INTERRUPTS FOLLOW ############}
{ PROGRAMMING IDEAS OBTAINED FROM :
   " MICROSOFT Mouse PROGRAMMERS REFERENCE, THE MICROSOFT PRESS "
 IF YOU WANT TO LEARN MORE ABOUT THE Mouse THIS BOOK IS A MUST }

PROCEDURE ResetMouse;
VAR
  Reg : Registers;
BEGIN
  if MemW[$0000:$00CC] = 0 then
    MouseExists := False
  else
    BEGIN
      Reg.AX := 0;
      INTR (Mouse_Interrupt, Reg);
      MouseExists := (Reg.AX <> 0);
    END;
END;

{############ INTERRUPT # 1 SHOW THE Mouse ############}
PROCEDURE ShowMouse;
VAR
  Reg : Registers;
BEGIN
  if MouseExists then
    BEGIN
      Reg.AX := 1;
      INTR (Mouse_Interrupt, Reg);
    END;
END;

{############ INTERRUPT # 2 HIDE THE Mouse ############}
PROCEDURE HideMouse;
VAR
  Reg : Registers;
BEGIN
  if MouseExists then
    BEGIN
      Reg.AX := 2;
      INTR (Mouse_Interrupt, Reg);
    END;
END;

{############ THIS IS THE HEART TO IDENTIFY Mouse EventS ############}
FUNCTION MouseStatus(VAR X,Y:Integer):Integer;
VAR
  status:Word;
BEGIN
     If Mouse.Event <> 0 then
        BEGIN
             Case Mouse.Event of
                  left_button_pressed     : Status := 1;
                  left_button_released    : Status := 2;
                  right_button_pressed    : Status := 3;
                  right_button_released   : Status := 4;
                  Mouse_moving            : Status := 5;
             END
        END   ELSE Status := 0;
     X:=Mouse.Col;
     Y:=Mouse.Row;
     MouseStatus := Status;
END;


{############ CHECK FOR Mouse POINTER IN RECTANGLE ############}
                { OR ANY POINT FOR THAT MATTER }
FUNCTION MouseinR(VAR P: Point; VAR R : Rect) : Boolean;
VAR
  stat, X, Y : Integer;
BEGIN
    MouseInR:= (P.X >= R.A.X) and (P.X <= R.B.X) and (P.Y >= R.A.Y) and (P.Y <= R.B.Y);
END;

{############ INTERRUPT # 4 MOVE THE Mouse ############}
PROCEDURE MoveMouse(X,Y : Integer);
VAR
  Reg : Registers;
BEGIN
  if MouseExists then
    BEGIN
      Reg.AX := 4;
      Reg.CX :=X;
      Reg.DX :=Y;
      INTR (Mouse_Interrupt, Reg);
      MouseExists := (Reg.AX <> 0);
    END;
END;

{############ INTERRUPT # 5 SELF ExPLANATORY ############}
FUNCTION LastxPress(Button : Byte) : Word;
VAR
  Reg : Registers;
BEGIN
	Reg.AX := 5;
	Reg.BX := Button;
        INTR (Mouse_Interrupt, Reg);
	lastxPress := Reg.CX;
END;

{############ INTERRUPT # 5 SELF ExPLANATORY ############}
FUNCTION LastYPress(Button : Byte) : Word;
VAR
  Reg : Registers;
BEGIN
	Reg.AX := 5;
	Reg.BX := Button;
        INTR (Mouse_Interrupt, Reg);
	lastYPress := Reg.DX;
END; 

{############ SELF ExPLANATORY ############}
PROCEDURE WaitforRelease;
VAR
   MS1 : Integer;
   P   : Point;
BEGIN
     REPEAT
           MS1 := Mousestatus(P.X,P.Y);
     UNTIL (MS1 = 2);
END;

{############ GET DOUBLE CLICK ############}
FUNCTION DoubleClick ( P : point): Boolean;
VAR
   MS1, MS2, MS3 : Integer;
   ok : Boolean;
BEGIN
     MS1 := LastxPress(0);
     MS2 := LastYPress(0);
     MS3 := Mousestatus(P.X,P.Y);
     ok := (MS1 = P.X) and (MS2 = P.Y);
     DoubleClick := (ok) and (MS3 = 1);
END;

{############ INTERRUPT # 7 RESTRICT Mouse MOVEMENT TO RECTANGLE ############}
PROCEDURE MouseMinMax(X,Y,x1,y1:Integer);
VAR
  Reg : Registers;
BEGIN
  if MouseExists then
    BEGIN
      Reg.AX := 7;
      Reg.CX :=X;
      Reg.DX :=x1;
      INTR (Mouse_Interrupt, Reg);
      Reg.AX := 8;
      Reg.CX :=Y;
      Reg.DX :=y1;
      INTR (Mouse_Interrupt, Reg);
      MouseExists := (Reg.AX <> 0);
    END;
END;

{############ INTERRUPT # 9 Mouse CURSOR IN GRAPHICS MODE ############}
PROCEDURE MouseCursor(Mask : Masktype; X,Y : Integer);
VAR
  Reg : Registers;
BEGIN
    Reg.AX := 9;
    Reg.BX := X;   {horizontal hot spot}   { Software cursor = 0 }
    Reg.CX := Y;   {vertical hot spot}
    Reg.DX := Ofs(MasK);     {screen mask}
    Reg.ES := Seg(Mask);     {cursor mask}
    INTR (Mouse_Interrupt, Reg);
END;

{############ INTERRUPT # 9 + RESET Mouse DRIVER ############}
PROCEDURE GraphicsMouse(Mask : MaskType; X,Y : Integer);
VAR
  Reg : Registers;
BEGIN
  MouseInit;
  if MouseExists then
  BEGIN
    Reg.AX := 9;
    Reg.BX := X;   {horizontal hot spot}   { Software cursor = 0 }
    Reg.CX := Y;   {vertical hot spot}
    Reg.DX := Ofs(MasK);     {screen mask}
    Reg.ES := Seg(Mask);     {cursor mask}
  END;
    INTR (Mouse_Interrupt, Reg);
    InGraphics := true;
END;

{############ INTERRUPT # 10 Mouse CURSOR IN TExT MODE ############}
PROCEDURE TextMouse;
VAR
  Reg : Registers;
BEGIN
  MouseInit;
  if MouseExists then
  BEGIN
       Reg.AX := 10;
       Reg.BX := 0;
       Reg.CX := $FFFF;
       Reg.DX := $7700;
  END;
  INTR (Mouse_Interrupt, Reg);
END;

{############ INTERRUPT # 16 HIDE Mouse IF IN BOx ############}
      { THIS IS USED FOR UPDATING REGIONS OF THE SCREEN }
PROCEDURE MouseBox(BX,by,bx1,by1 : Word);
VAR
  Reg : Registers;
BEGIN
  if MouseExists then
  BEGIN
     Reg.AX := 16;
     Reg.ES := seg(HideBox);
     Reg.DX := ofs(HideBox);
     HideBox.X:=BX;
     HideBox.Y:=BY;
     HideBox.x1:=Bx1;
     HideBox.Y1:=BY1;
  END;
    INTR (Mouse_Interrupt, Reg);
END;




{############ Mouse INTERRUPT HANDLER TO INTERACT WITH Mouse DRIVER ############}
                   { YOU STILL NEED A Mouse DRIVER INSTALLED }
      { NOTICE THAT I'M USING INTERRUPT $33 TO COMMUNICATE WITH Mouse DRIVER }
PROCEDURE Mouse_Handler
           (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP :Word);
INTERRUPT;

BEGIN
  Mouse.Event         := AX;    { INTERRUPT SERVICE TO CALL }
  Mouse.Button_Status := BX;    { THIS RETURNS BUTTON STATUS }
  Mouse.Col           := CX;    { THIS IS Y }
  Mouse.Row           := DX;    { THIS IS X }
  If NOT INGRAPHICS then
                        BEGIN
                        { IF NOT IN GRAPHICS DIVIDE TO OBTAINED TExT COORDINATES }
                             Mouse.Col           := CX div 8;
                             Mouse.Row           := DX div 8;
                        END;
   { DONE IN ASSEMBLY TO INCREASE SPEED }
  InLine ( 
    $8B/$E5/
    $5D/
    $07/
    $1F/
    $5F/
    $5E/
    $5A/
    $59/
    $5B/
    $58/
    $CB );
END; { PROCEDURE Mouse_Handler }

{############ INTERRUPT # 12 INSTALL MY OWN INTERRUPT CALL ############}
PROCEDURE Install_Mouse_Interrupt_Handler;
VAR
  Reg : Registers;
BEGIN
  Reg.AX := 12;
  { ANY OF THESE EventS WILL ACTIVATE THE INTERRUPT }
  Reg.CX := Left_Button_Released +
            Right_Button_Released +
            Left_Button_Pressed +
            Right_Button_Pressed +
            Mouse_Moving;

  Reg.DX := Ofs(Mouse_Handler);               { KEEP OLD VECTOR TABLE }
  Reg.ES := Seg(Mouse_Handler);
  INTR (Mouse_Interrupt, Reg);
END;

{############ INITIALIZE THE Mouse, CHECK IF DRIVER AND Mouse PRESENT ############}
PROCEDURE MouseInit;
BEGIN
  Mouse.Event     := 0;
  MouseExists    := False;
  InGraphics := False;
    ResetMouse;
    if MouseExists then
    BEGIN
      MoveMouse(0,0);
      Install_Mouse_Interrupt_Handler;
    END;
END; { PROCEDURE Initialize_Mouse }
{$F-}
END.

{############ END OF EMouse LIBRARY ############}
