{ Unit Math makes some undocumented, but fully functional routines of the
  coprocessor/emulator floating point package available to the user. These
  functions are *not* available for REAL arithmetic in $N- mode.

  Copyright (c) 1990-1992 Norbert Juffa                                   }



{$N+,E+}

UNIT Math;


INTERFACE

FUNCTION Tan (X: EXTENDED): EXTENDED;

FUNCTION Log (X: EXTENDED): EXTENDED;

FUNCTION Ld  (X: EXTENDED): EXTENDED;

FUNCTION PowerOfTen (X: EXTENDED): EXTENDED;

FUNCTION PowerOfTwo (X: EXTENDED): EXTENDED;


IMPLEMENTATION

FUNCTION Tan (X: EXTENDED): EXTENDED; ASSEMBLER;
ASM
   FLD   TBYTE PTR [X]    { get argument }
   INT   3Eh              { call shortcut interrupt }
   DW    90F0h            { signal Tan wanted to shortcut handler }
END;

FUNCTION Log (X: EXTENDED): EXTENDED; ASSEMBLER;
ASM
   FLD   TBYTE PTR [X]    { get argument }
   INT   3Eh              { call shortcut interrupt }
   DW    90F8h            { signal Log10 wanted to shortcut handler }
END;

FUNCTION Ld  (X: EXTENDED): EXTENDED; ASSEMBLER;
ASM
   FLD   TBYTE PTR [X]    { get argument }
   INT   3Eh              { call shortcut interrupt }
   DW    90F6h            { signal Log2 wanted to shortcut handler }
END;

FUNCTION PowerOfTen (X: EXTENDED): EXTENDED; ASSEMBLER;
ASM
   FLD   TBYTE PTR [X]    { get argument }
   INT   3Eh              { call shortcut interrupt }
   DW    90FEh            { signal Power of 10 wanted to shortcut handler}
END;

FUNCTION PowerOfTwo (X: EXTENDED): EXTENDED; ASSEMBLER;
ASM
   FLD   TBYTE PTR [X]    { get argument }
   INT   3Eh              { call shortcut interrupt }
   DW    90FCh            { signal Power of 2 wanted to shortcut handler }
END;


END. { Math }
