PROGRAM StrTest; { Copyright (c) 1991-1993 Norbert Juffa }

{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,R-,S-,V-,X-}
{$M 16384,0,655360}

USES Time;

VAR
  I: INTEGER;
  U: STRING [1];
  Q: STRING [100];
  S: STRING [55];
  T: STRING [60];
  V: STRING;
  Start: LONGINT;
  L: WORD;

CONST TestStr: ARRAY [1..22] OF CHAR = 'HELLO, THIS IS A TEST ';

BEGIN
   WriteLn ('String Function Compatibility and Speed Test');
   WriteLn;
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      T := 'THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG 1234567890';
      Insert (T, T, 1);
      Delete (T, 55, 54);
      S := Copy (T, -5, 2);     {'TH'}
      U := Copy (T, 7, 4);      {'I'}
      S := S + U;               {'THI'}
      Q := Copy (T, 32, 70);    {'THE LAZY DOG 1234567890'}
      Delete (Q, 2, 1);         {'TE LAZY DOG 1234567890'}
      Delete (Q, 100, 2);       {'TE LAZY DOG 1234567890'}
      Delete (Q, 3, -4);        {'TE LAZY DOG 1234567890'}
      Delete (Q, 3, 10);        {'TE1234567890'}
      I := Pos ('S', T);        {25}
      Insert(Copy(T,I,200),Q,3);{'TES OVER THE LAZY DOG 12345678901234567890'}
      Delete (Q, 4, 6);         {'TESTHE LAZY DOG 12345678901234567890}
      S := S + T [25];          {'THIS'}
      S := S + Copy (S, 3, -5) + Copy (S, 3, 2);  {'THISIS'}
      V := T;                   {'THE QUICK BROWN FOX JUMPS OVER THE LAZY ..'}
      Delete (V, -10, 47);      {'AZY DOG 1234567890'}
      IF (Copy (V, -7, -1) = '') AND (Pos ('DOG', V) = 5) THEN {TRUE}
         Insert (V, S, 200);    {'THISISAZY DOG 1234567890'}
      U := Copy (T, 44, 40);    {' '}
      Insert (U, S, 5);         {'THIS ISAZY DOG 1234567890'}
      I := Pos ('ZY', S);       {9}
      Delete (S, I, -5);        {'THIS ISAZY DOG 1234567890'}
      Insert (Copy(S,5,1),S,8); {'THIS IS AZY DOG 1234567890'}
      Delete (S, 10, 16);       {'THIS IS A0'}
      IF S [Length (S)] = '0' THEN {TRUE}
         S := S + Q;            {'THIS IS A0TESTHE LAZY DOG 123456789012345...'}
      V := Copy (S, Length (S) - 19, 10); {'1234567890'}
      IF V = Copy (S, Length (S) - 9, 10) THEN {TRUE}
         Delete (S, 15, 3 * Length (V)+2); {'THIS IS A0TEST'}
      Insert ('', S, 0);        {'THIS IS A0TEST'}
      Insert(Copy(S,5,1),S,11); {'THIS IS A0 TEST'}
      Insert ('HELLO', S, -4);  {'HELLOTHIS IS A0 TEST'}
      Insert (',', S, 6);       {'HELLO,THIS IS A0 TEST'}
      Delete (S, Pos ('TEST', S) - 2, 1); {'HELLO,THIS IS A TEST'}
      Delete (Q, 0, 32767);     {''}
      Q := Q + ' ';             {' '}
      Insert (Q, S, 7);         {'HELLO, THIS IS A TEST'}
      Insert (Q, S, 255);       {'HELLO, THIS IS A TEST '}
      IF (S = TestStr) AND (Q = ' ') AND
         (V = '1234567890') AND (T = 'THE QUICK BROWN FOX JUMPS OVER THE'+
         ' LAZY DOG 1234567890') AND (L=1) THEN BEGIN
         WriteLn ('Test OK');
         WriteLn;
         END;
   END;
   WriteLn ('String-Benchmark completes in', Clock-Start:5, ' ms');
END.
