PROGRAM LONGPERF;  { Copyright (c) 1992,1993 Norbert Juffa }

{ Program LONGPERF tests speed of longint operations. This is the TP version. }
{ It was compiled using the Turbo Pascal 6.0 compiler using my own run-time   }
{ library available as TPL60N19.ZIP from garbo@uwasa.fi. Switches were set    }
{ for fastest execution of binary using: $r-,s-,i-,v-,b-,a+                   }

{ Statistics of longint operations used: }
{ add/sub: 8                             }
{ mul:     3                             }
{ div/mod: 2                             }
{ shifts:  2                             }
{ bit-ops: 2                             }
{ abs val: 2                             }
{ ----------                             }
{ total:  21                             }

{$R-,S-,I-,A+,B-,V-}

USES Time;                       { function clock return time in milliseconds }

VAR Start, J, K, L, N: LONGINT;

BEGIN
   Start := Clock;
   K := 1396878;
   L := 9176;
   J := 8568673;
   FOR N := 0 TO 10000 DO BEGIN
      L := (K * L * J) * (J + K) + K;
      K := ((Abs (K + J + N)) SHR (J AND (Longint(31)))) + L;
      L := Abs (L) SHL (K AND (Longint(31)));
      J := (K * J - L) * (L + K + J);
   END;
   WriteLn ('elapsed: ', Clock-Start, ' ms');
   WriteLn ('actual:', N:9, L:16, J:16, K:16);
   WriteLn ('expected:', 10000:7, 1209532416:16, 1083102604:16, 1421878289:16);
END.


/* Program LONGPERF tests speed of longint operations. This is the C version. */
/* It was compiled using the Microsoft C/C++ 7.0 optimizing compiler. Switches*/
/* were set for fastest execution of binary using: -Oxazb2 -Gr -AS            */

/* Statistics of longint operations used: */
/* add/sub: 8                             */
/* mul:     3                             */
/* div/mod: 2                             */
/* shifts:  2                             */
/* bit-ops: 2                             */
/* abs val: 2                             */
/* ----------                             */
/* total:  21                             */


#include <stdlib.h>
#include <stdio.h>

extern long cdecl extime(void);  /* returns time in milliseconds */
long start,i,j,k,l,n;

void main (void)
{
   start = extime();
   k = 1396878;
   l = 9176;
   j = 8568673;
   for (n=0; n<=10000; n++)
      {
      l = (k * l * j) / (j + k) + k;
      k = ((labs (k + j + n)) >> (j & 31L)) + l;
      l = labs(l) << (k & 31L);
      j = (k * j - l) % (l + k +j);
      }

   printf ("elapsed: %0ld ms\n", extime()-start);
   printf ("actual: %8ld %15ld %15ld %15ld\n",n,l,j,k);
   printf ("expected: %6ld %15ld %15ld %15ld\n",10000,1209532416,1083102604,1421878289);
}

