Uses Graph,sObjects,Crt,Mouse,sTypes;
{$R+ $S+}
(*  sWindow By Steve Poulsen *)
(*  Graphical User Interface *)
(*  Demo Program *)
(*  Coming soon... More features plus extensive documentation *)
(*  Use it like many popular windows programming languages but *)
(*  use it for DOS *)

Type
  PsChild2Window=^TsChild2Window;      (* Make my child window look like *)
  TsChild2Window=object(TsWindow)      (* default window *)
    SubChild:PsWindow;                 (* My child window can have a *)
                                       (* subchild also *)

    Constructor Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);

                                       (* Override Init so I can change *)
                                       (* some of the attributes *)
  End;

  PsMyWindow=^TsMyWindow;              (* This is another window I want *)
  TsMyWindow=object(TsWindow)
    Child1:PsWindow;                   (* It can have 3 children.  2 that *)
    Child2:PsWindow;                   (* are the default and 1 like above *)
    Child3:PsChild2Window;
    Constructor Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
    Procedure SetUpWindow; virtual;
  End;

  PsChildWindow=^TsChildWindow;        (* And another window *)
  TsChildWindow=object(TsWindow)
    Constructor Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
    Procedure SetUpWindow; virtual;
  End;

  PsMyApp=^TsMyApp;                    (* This is my app and it sets up *)
  TsMyApp=object(TsApplication)        (* the main window and controls the *)
    Procedure InitMainWindow; virtual; (* program *)
  End;

Constructor TsChildWindow.Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
  Begin
    TsWindow.Init(sParent,sTitle,sX,sY,sW,sH);
    With Attr Do
      Begin
        FrameColor:=12;                (* Change the colors of this window *)
        TitleColor:=4;
      End;
  End;

Constructor TsChild2Window.Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
  Begin
    TsWindow.Init(sParent,sTitle,sX,sY,sW,sH);
    With Attr Do
      Begin
        FrameColor:=10;               (* color change *)
        TitleColor:=2;                (* I will set the subchild window up *)
      End;
    SubChild:=New(PsChildWindow,Init(@Self,'SubChild',Attr.X+60,Attr.Y+60,Attr.W-40,Attr.H-40));
    With SubChild^.Attr Do
      Begin
        FrameColor:=13;               (* and change it's colors again *)
        TitleColor:=5;
      End;
  End;

Constructor TsMyWindow.Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
  Begin
    TsWindow.Init(sParent,sTitle,sX,sY,sW,sH);
{    Attr.Style:=Attr.Style - ws_Maximize;
    Maximize:=True;}  (* These two lines set the window to maximize and
                         remove the maximize button *)

                      (* set up 3 children as defined above *)

    Child1:=New(PsChildWindow,Init(@Self,'Child 1',Attr.X+20,Attr.Y+40,Attr.W-20,Attr.H-20));
    Child2:=New(PsChildWindow,Init(@Self,'Child 2',Attr.X+80,Attr.Y+60,Attr.W-20,Attr.H-20));
    Child3:=New(PsChild2Window,Init(@Self,'Child 3',Attr.X+140,Attr.Y+80,Attr.W-40,Attr.H-40));
  End;

Procedure TsChildWindow.SetUpWindow;
  Begin
    TsWindow.SetUpWindow;        (* This is where the window actually get *)
    Active;                      (* drawn.  Active sets the viewport *)
    SetColor(0);
    OutTextXY(10,10,'Steve''s Windows');
    OutTextXY(10,20,'Add as many windows as needed.');
    OutTextXY(10,30,'Forget about the looks and spend your time');
    OutTextXY(10,40,'on the program''s logic.');
    OutTextXY(10,60,'(c) 1993 by Steve Poulsen');
    InActive;                    (* This sets viewport to entire screen *)
  End;

Procedure TsMyWindow.SetUpWindow;
  Begin
    TsWindow.SetUpWindow;      (* No change here *)
  End;

Procedure TsMyApp.InitMainWindow;     (* This is the first window *)
  Var                                 (* This sets the window of type *)
    Title:Array[1..20] Of Char;       (* PsMyWindow and the rest is defined *)
                                      (* from there *)
  Begin
    MainWindow:=New(PsMyWindow,Init(nil,'Main Window',10,10,400,200));
    TsApplication.InitMainWindow;     (* This will paint my window *)
  End;

Var
  MyApp:TsMyApp;

Begin
  MyApp.Init;                         (* Set up windows *)
  MyApp.Run;                          (* Handle events *)
  MyApp.Done;                         (* Remove windows *)
End.