;======================================================================
; MODULE NAME:  ErrMsg
; DEPENDENCIES: System
; LAST MOD ON:  9102.11
; PROGRAMMER:   Naoto Kimura
;
;     This unit was made for those who want to have more descriptive
; error messages from Turbo Pascal programs.  The error messages will
; be sent to the standard DOS output file.  The "EndWait" unit is
; installed for version 5 of the compiler.
;
; MODIFICATION HISTORY:
; 9004.08       Naoto Kimura
;               Initial version created
; 9005.11       Naoto Kimura
;               Added error message for version 5.5
; 9006.04       Naoto Kimura
;               Made minor adjustment to code, shrinking it by a few
;               bytes.
; 9102.11       Naoto Kimura
;               Added new error messages for version 6.0
;=====================================================================
.MODEL TPASCAL
LOCALS

DATASEG

; From System unit
EXTRN	ExitProc:DWORD,ErrorAddr:DWORD,ExitCode:WORD
; Local to unit
EXTRN	ExitSave:DWORD,VerboseMsg:BYTE

BufferSize	EQU	8
Buffer		DB	BufferSize DUP (?)

Msg1		DW	?
Msg1Len		DW	?
Msg2		DW	?
Msg2Len		DW	?

CODESEG

Copyright	DB	'ERRMSG.TPU                copyright '
		DB	'Naoto Kimura (02/11/91)';

NewLine		DB	13,10
NewLineLen	=	$-NewLine

UnknownMsg1	DB	'Unknown error code ('
UnknownMsg1Len	=	$-UnknownMsg1
UnknownMsg2	DB	')',13,10
UnknownMsg2Len	=	$-UnknownMsg2

NormalMsg1	DB	'Normal termination with exit code ('
NormalMsg1Len	=	$-NormalMsg1
NormalMsg2	DB	')',13,10
NormalMsg2Len	=	$-NormalMsg2

;
; -------------------- DOS errors --------------------
;
Err1Msg		DB	'DOS: Invalid function number.'
Err1Len		=	$-Err1Msg
Err1Expln	DB	'    Possible cause:',13,10,'    You made a '
		DB	'call to an nonexistent DOS function.',13,10
Err1ELen	=	$-Err1Expln
Err2Msg		DB	'DOS: File not found.',13,10
Err2Len		=	$-Err2Msg
Err2Expln	DB	'    Possible cause:',13,10,'    Name assigned'
		DB	' to file variable passed to Reset, Append, Re'
		DB	'name, or Erase',13,10,'    does not specify a'
		DB	'n existing file.',13,10
Err2ELen	=	$-Err2Expln
;
Err3Msg		DB	'DOS: Path not found.',13,10
Err3Len		=	$-Err3Msg
Err3Expln	DB	'    Possible causes:',13,10,'    1) Name assi'
		DB	'gned to file variable passed to Reset, Rewrit'
		DB	'e, Append or',13,10,'       Erase is invalid '
		DB	'or specifies a nonexistent subdirectory.',13
		DB	10,'    2) Path passed to ChDir, MkDir, or RmD'
		DB	'ir is invalid or specifies a',13,10,'       n'
		DB	'onexistent directory',13,10
Err3ELen	=	$-Err3Expln
;
Err4Msg		DB	'DOS: Too many open files.',13,10
Err4Len		=	$-Err4Msg
Err4Expln	DB	'    Possible causes:',13,10,'    Reset, Rewri'
		DB	'te or Append could not open file because ther'
		DB	'e are too many',13,10,'    files opened.  DOS'
		DB	' never allows more than 15 open files per pro'
		DB	'cess.  If',13,10,'    this error occurred wit'
		DB	'h less than 15 files, this may indicate that '
		DB	'the',13,10,'    CONFIG.SYS file does not incl'
		DB	'ude a FILES=xx entry or that the entry',13,10
		DB	'    specifies too few files.  To remedy this '
		DB	'problem, increase this value to',13,10,'    p'
		DB	'roblem, increase this value to a larger value'
		DB	', for example 20.',13,10
Err4ELen	=	$-Err4Expln
;
Err5Msg		DB	'DOS: File access denied.',13,10
Err5Len		=	$-Err5Msg
Err5Expln	DB	'    Possible causes:',13,10,'    1) Reset or '
		DB	'Append failed because FileMode allows writing'
		DB	' and the name',13,10,'       assigned to the '
		DB	'file variable specifies a directory or read-o'
		DB	'nly file.',13,10,'    2) Rewrite failed becau'
		DB	'se the directory is full or the file name is'
		DB	13,10,'       already used by a directory or a'
		DB	' read-only file.',13,10,'    3) Rename failed'
		DB	' because the file variable was assigned to a '
		DB	'directory,',13,10,'       or because the new '
		DB	'name specified specifies an existing file.',13
		DB	10,'    4) Erase cannot be used with a directo'
		DB	'ry nor can it be used with a',13,10,'       r'
		DB	'ead-only file.',13,10,'    5) MkDir encounter'
		DB	'd a problem because',13,10,'       a) directo'
		DB	'ry name already exists as a file name or dire'
		DB	'ctory name.',13,10,'       b) there is no mor'
		DB	'e room in the parent directory.',13,10,'     '
		DB	'  c) the path specified a device.',13,10,'   '
		DB	' 6) RmDir encounterd a problem because',13,10
		DB	'       a) directory specified is not empty.'
		DB	13,10,'       b) the path does not specify a d'
		DB	'irectory.',13,10,'       c) the path specifie'
		DB	's the root directory.',13,10,'    7) You trie'
		DB	'd reading from a file that was not open for r'
		DB	'eading.',13,10,'    8) You tried writing to a'
		DB	' file that was not open for writing',13,10
Err5ELen	=	$-Err6Expln
;
Err6Msg		DB	'DOS: Invalid file handle.',13,10
Err6Len		=	$-Err6Msg
Err6Expln	DB	'    Possible causes:',13,10,'    This error i'
		DB	's reported if an invalid file handle is passe'
		DB	'd to a DOS system',13,10,'    call.  It shoul'
		DB	'd never occur; if it does, it is an indicatio'
		DB	'n that the',13,10,'    file variable was some'
		DB	'how trashed.',13,10
Err6ELen	=	$-Err6Expln
;
Err12Msg	DB	'DOS: Invalid file access code.',13,10
Err12Len	=	$-Err12Msg
Err12Expln	DB	'    Possible causes:',13,10,'    Reset or App'
		DB	'end encountered difficulty because the value '
		DB	'of FileMode is',13,10,'    invalid.',13,10
Err12ELen	=	$-Err12Expln
;
Err15Msg	DB	'DOS: Bad drive number.',13,10
Err15Len	=	$-Err15Msg
Err15Expln	DB	'    Possible causes:',13,10,'    GetDir faile'
		DB	'd because the drive number specified is inval'
		DB	'id.',13,10
Err15ELen	=	$-Err15Expln
;
Err16Msg	DB	'DOS: Cannot remove current directory.',13,10
Err16Len	=	$-Err16Msg
Err16Expln	DB	'    Possible causes:',13,10,'    Path specifi'
		DB	'ed for RmDir is the current directory.',13,10
Err16ELen	=	$-Err16Expln
;
Err17Msg	DB	'DOS: Cannot rename across drives.',13,10
Err17Len	=	$-Err17Msg
Err17Expln	DB	'    Possible causes:',13,10,'    You cannot r'
		DB	'ename across disk drives.'
Err17ELen	=	$-Err17Expln

;
; -------------------- I/O errors --------------------
;
Err100Msg	DB	'I/O: Disk read error.',13,10
Err100Len	=	$-Err100Msg
Err100Expln	DB	'    Possible causes:',13,10,'    A read was a'
		DB	'ttempted past end of file.',13,10
Err100ELen	=	$-Err100Expln
;
Err101Msg	DB	'I/O: Disk write error.',13,10
Err101Len	=	$-Err101Msg
Err101Expln	DB	'    Possible causes:',13,10,'    Disk is full'
		DB	'.',13,10
Err101ELen	=	$-Err101Expln
;
Err102Msg	DB	'I/O: File not assigned.',13,10
Err102Len	=	$-Err102Msg
Err102Expln	DB	'    Possible causes:',13,10,'    Reset, Rewri'
		DB	'te, Append, Rename, or Erase failed because t'
		DB	'he file',13,10,'    variable has not been ass'
		DB	'igned a name through Assign.',13,10
Err102ELen	=	$-Err102Expln
;
Err103Msg	DB	'I/O: File not open.',13,10
Err103Len	=	$-Err103Msg
Err103Expln	DB	'    Possible causes:',13,10,'    A file opera'
		DB	'tion was attempted when file was not open.',13
		DB	10
Err103ELen	=	$-Err103Expln
;
Err104Msg	DB	'I/O: File not open for input.',13,10
Err104Len	=	$-Err104Msg
Err104Expln	DB	'    Possible causes:',13,10,'    File cannot '
		DB	'be read when it is not opened for input.',13
		DB	10
Err104ELen	=	$-Err104Expln
;
Err105Msg	DB	'I/O: File not open for output.',13,10
Err105Len	=	$-Err105Msg
Err105Expln	DB	'    Possible causes:',13,10,'    File cannot '
		DB	'be written to when it is not opened for outpu'
		DB	't.',13,10
Err105ELen	=	$-Err105Expln
;
Err106Msg	DB	'I/O: Invalid numeric format.',13,10
Err106Len	=	$-Err106Msg
Err106Expln	DB	'    Possible causes:',13,10,'    Read or Read'
		DB	'ln tried to read a numeric variable, and the '
		DB	'input did not',13,10,'    conform to proper n'
		DB	'umeric format.',13,10
Err106ELen	=	$-Err106Expln
;
; -------------------- Critical errors --------------------
;
Err150Msg	DB	'Critical Error: Disk is write-protected.',13
		DB	10
Err150Len	=	$-Err150Msg
Err150Expln	DB	'See DOS manual for details.',13,10
Err150ELen	=	$-Err150Expln
;
Err151Msg	DB	'Critical Error: Unknown unit.',13,10
Err151Len	=	$-Err151Msg
Err151Expln	DB	'See DOS manual for details.',13,10
Err151ELen	=	$-Err151Expln
;
Err152Msg	DB	'Critical Error: Drive not ready.',13,10
Err152Len	=	$-Err152Msg
Err152Expln	DB	'See DOS manual for details.',13,10
Err152ELen	=	$-Err152Expln
;
Err153Msg	DB	'Critical Error: Unknown command.',13,10
Err153Len	=	$-Err153Msg
Err153Expln	DB	'See DOS manual for details.',13,10
Err153ELen	=	$-Err153Expln
;
Err154Msg	DB	'Critical Error: CRC error in data.',13,10
Err154Len	=	$-Err154Msg
Err154Expln	DB	'See DOS manual for details.',13,10
Err154ELen	=	$-Err154Expln
;
Err155Msg	DB	'Critical Error: Bad drive request structure l'
		DB	'ength.',13,10
Err155Len	=	$-Err155Msg
Err155Expln	DB	'See DOS manual for details.',13,10
Err155ELen	=	$-Err155Expln
;
Err156Msg	DB	'Critical Error: Disk seek error.',13,10
Err156Len	=	$-Err156Msg
Err156Expln	DB	'See DOS manual for details.',13,10
Err156ELen	=	$-Err156Expln
;
Err157Msg	DB	'Critical Error: Unknown media type.',13,10
Err157Len	=	$-Err157Msg
Err157Expln	DB	'See DOS manual for details.',13,10
Err157ELen	=	$-Err157Expln
;
Err158Msg	DB	'Critical Error: Sector not found.',13,10
Err158Len	=	$-Err158Msg
Err158Expln	DB	'See DOS manual for details.',13,10
Err158ELen	=	$-Err158Expln
;
Err159Msg	DB	'Critical Error: Printer out of paper.',13
		DB	10
Err159Len	=	$-Err159Msg
Err159Expln	DB	'See DOS manual for details.',13,10
Err159ELen	=	$-Err159Expln
;
Err160Msg	DB	'Critical Error: Device write fault.',13,10
Err160Len	=	$-Err160Msg
Err160Expln	DB	'See DOS manual for details.',13,10
Err160ELen	=	$-Err160Expln
;
Err161Msg	DB	'Critical Error: Device read fault.',13,10
Err161Len	=	$-Err161Msg
Err161Expln	DB	'See DOS manual for details.',13,10
Err161ELen	=	$-Err161Expln
;
Err162Msg	DB	'Critical Error: Hardware failure.',13,10
Err162Len	=	$-Err162Msg
Err162Expln	DB	'See DOS manual for details.',13,10
Err162ELen	=	$-Err162Expln
;
; -------------------- Fatal errors --------------------
;
Err200Msg	DB	'Fatal: Division by zero.',13,10
Err200Len	=	$-Err200Msg
Err200Expln	DB	''
Err200ELen	=	$-Err200Expln
;
Err201Msg	DB	'Fatal: Range check error.',13,10
Err201Len	=	$-Err201Msg
Err201Expln	DB	'    Possible causes:',13,10,'    1) Index exp'
		DB	'ression of an array qualifier was out of rang'
		DB	'e.',13,10,'    2) An attempt was made to assi'
		DB	'gn an out of range value to a variable.',13
		DB	10,'    3) An attempt was made to pass an out '
		DB	'of range value as a parameter to a',13,10,'  '
		DB	'     procedure or function.',13,10
Err201ELen	=	$-Err201Expln
;
Err202Msg	DB	'Fatal: Stack overflow error.',13,10
Err202Len	=	$-Err202Msg
Err202Expln	DB	'    Possible causes:',13,10,'    This error i'
		DB	's reported on entry to a procedure or functio'
		DB	'n compiled in the',13,10,'    {$S+} state whe'
		DB	'n there is not enough stack space to allocate'
		DB	' the',13,10,'    subprogram''s local variable'
		DB	's.  Increase the size of the stack by using'
		DB	13,10,'    the {$M #,#,#} compiler directive.'
		DB	13,10
Err202ELen	=	$-Err202Expln
;
Err203Msg	DB	'Fatal: Heap overflow error.',13,10
Err203Len	=	$-Err203Msg
Err203Expln	DB	'    Possible causes:',13,10,'    New or GetMe'
		DB	'm request failed.',13,10
Err203ELen	=	$-Err203Expln
;
Err204Msg	DB	'Fatal: Invalid pointer operation.',13,10
Err204Len	=	$-Err204Msg
Err204Expln	DB	'    Possible causes:',13,10,'    a) Pointer p'
		DB	'assed to Dispose or FreeMem is NIL.',13,10,' '
		DB	'   b) Pointer passed to Dispose or FreeMem po'
		DB	'ints outside heap area.',13,10,'    c) Free l'
		DB	'ist could not be expanded.',13,10
Err204ELen	=	$-Err204Expln
;
Err205Msg	DB	'Fatal: Floating point overflow.',13,10
Err205Len	=	$-Err205Msg
Err205Expln	DB	'    Possible causes:',13,10,'    A floating-'
		DB	'point operation produced a number too large '
		DB	'for Turbo',13,10,'    Pascal or the numeric '
		DB	'coprocessor (if any) to handle.',13,10
Err205ELen	=	$-Err205Expln
;
Err206Msg	DB	'Fatal: Floating point underflow.',13,10
Err206Len	=	$-Err206Msg
Err206Expln	DB	'    Possible causes:',13,10,'    A floating-'
		DB	'point operation produced an underflow.  This'
		DB	' error is',13,10,'    only reported if you a'
		DB	're using the 8087 numeric coprocessor with'
		DB	13,10,'    a control word that unmasks underf'
		DB	'low exceptions.  By default,',13,10,'    an '
		DB	'underflow causes a result of zero to be retu'
		DB	'rned.',13,10
Err206ELen	=	$-Err206Expln
;
Err207Msg	DB	'Fatal: Invalid floating point operation.',13
		DB	10
Err207Len	=	$-Err207Msg
Err207Expln	DB	'    Possible causes:',13,10,'    a) Real valu'
		DB	'e passed to Trunc or Round not in range -21,4'
		DB	'74,843,648 to',13,10,'       21,474,843,647.'
		DB	13,10,'    b) Argument passed to Sqrt was nega'
		DB	'tive.',13,10,'    c) The 8087''s stack overfl'
		DB	'owed',13,10
Err207ELen	=	$-Err207Expln
;
; Turbo Pascal Version 5.0 error message
;
Err208Msg	DB	'Fatal: Overlay manager not installed.',13,10
Err208Len	=	$-Err208Msg
Err208Expln	DB	'    Possible causes:',13,10,'    Your program'
		DB	' is calling an overlaid procedure or function'
		DB	', but the',13,10,'    overlay manager is not '
		DB	'installed.  Most likely, you are not calling'
		DB	13,10,'    OvrInit, or the call to OvrInit fai'
		DB	'led.  Note that, if you have',13,10,'    init'
		DB	'ialization code in any of your overlaid units'
		DB	', you must create an',13,10,'    additional n'
		DB	'on-overlaid unit which calls OvrInit, and use'
		DB	' that unit',13,10,'    before any of the over'
		DB	'laid units.  For a complete description of th'
		DB	'e',13,10,'    overlay manager, refer to Chapt'
		DB	'er 6 in the User''s Guide, "Using Overlays."'
		DB	13,10
Err208ELen	=	$-Err208Expln
;
Err209Msg	DB	'Fatal: Overlay file read error.',13,10
Err209Len	=	$-Err209Msg
Err209Expln	DB	'    Possible causes:',13,10,'    A read error'
		DB	' occurred when the overlay manager tried to r'
		DB	'ead an overlay',13,10,'    file.',13,10
Err209ELen	=	$-Err209Expln

;
; Turbo Pascal Version 5.5 error messages
;
Err210Msg	DB	'Fatal: Object not initialized.',13,10
Err210Len	=	$-Err210Msg
Err210Expln	DB	'    Possible causes:',13,10,'    With range-c'
		DB	'hecking on, you made a call to an object''s v'
		DB	'irtual',13,10,'    method, before the object '
		DB	'had been initialized via a constructor',13,10
		DB	'    call.',13,10
Err210ELen	=	$-Err210Expln
;
; Turbo Pascal Version 6.0 error messages.
;
Err211Msg	DB	'Fatal: Call to abstract method'
Err211Len	=	$-Err211Msg
Err211Expln	DB	'    Possible Causes:',13,10,'    This error i'
		DB	's generated by the Abstract procedure in the '
		DB	'Objects unit; it',13,10,'    indicates that y'
		DB	'our program tried to execute an abstract virt'
		DB	'ual method.',13,10,'    When an object type c'
		DB	'ontains one or more abstract methods it is ca'
		DB	'lled an',13,10,'    abstract object type.  It'
		DB	' is an error to instatiate objects of an abst'
		DB	'ract',13,10,'    type -- abstract types exist'
		DB	' only so that you can inherit from them and'
		DB	13,10,'    override the abstract methods.',13
		DB	10,13,10,'    For example, the Compare method '
		DB	'of the TSortedCollection type in the',13,10
		DB	'    Objects unit is abstract, indicating that'
		DB	' to implement a sorted',13,10,'    collection'
		DB	' you must create an object type that inherits'
		DB	' from',13,10,'    TSortedCollection and overr'
		DB	'ides the Compare method.',13,10
Err211ELen	=	$-Err211Expln

Err212Msg	DB	'Fatal: Stream registration error'
Err212Len	=	$-Err212Msg
Err212Expln	DB	'    Possible cause:',13,10,'    This error is'
		DB	' generated by the RegisterType procedure in t'
		DB	'he Objects unit',13,10,'    indicating that o'
		DB	'ne of the following errors have occurred:',13
		DB	10,'        1) The stream registration record '
		DB	'does not reside in the data segment.',13,10
		DB	'        2) The ObjType field of the stream re'
		DB	'gistration record is zero.',13,10,'        3)'
		DB	' The type has already been registered.',13,10
		DB	'        4) Another type with the same ObjType'
		DB	' value already exits.',13,10
Err212ELen	=	$-Err212Expln

Err213Msg	DB	'Fatal: Collection index out of range.'
Err213Len	=	$-Err213Msg
Err213Expln	DB	'    Possible cause:',13,10,'    The index pas'
		DB	'sed to a method of a TCollection is out of ra'
		DB	'nge.',13,10
Err213ELen	=	$-Err213Expln

Err214Msg	DB	'Fatal: Collection overflow error'
Err214Len	=	$-Err214Msg
Err214Expln	DB	'    Possible cause:',13,10,'    The error is '
		DB	'reported by a TCollection if an attempt is ma'
		DB	'de to add an',13,10,'    element when the col'
		DB	'lection cannot be expanded.',13,10
Err214ELen	=	$-Err214Expln
;
;
; ==================== Message table ====================
;
MsgStruc	STRUC
	Num	DW	?
	MsgPtr	DW	?
	MsgLen	DW	?
	ExpPtr	DW	?
	ExpLen	DW	?
MsgStruc	ENDS
;

ErrTbl		=	$
; -------------------- DOS errors --------------------
IRP	N,<1,2,3,4,5,6,12,15,16,17>
	MsgStruc <&N,Err&N&Msg,Err&N&Len,Err&N&Expln,Err&N&ELen>
	ENDM
; -------------------- I/O errors --------------------
IRP	N,<100,101,102,103,104,105,106>
	MsgStruc <&N,Err&N&Msg,Err&N&Len,Err&N&Expln,Err&N&ELen>
	ENDM
; -------------------- Critical errors --------------------
IRP	N,<150,151,152,153,154,155,156,157,158,159,160,161,162>
	MsgStruc <&N,Err&N&Msg,Err&N&Len,Err&N&Expln,Err&N&ELen>
	ENDM
; -------------------- Fatal errors --------------------
IRP	N,<200,201,202,203,204,205,206,207>
	MsgStruc <&N,Err&N&Msg,Err&N&Len,Err&N&Expln,Err&N&ELen>
	ENDM
	; version 5.0
	MsgStruc <208,Err208Msg,Err208Len,Err208Expln,Err208ELen>
	MsgStruc <209,Err209Msg,Err209Len,Err209Expln,Err209ELen>
	; version 5.5
	MsgStruc <210,Err210Msg,Err210Len,Err210Expln,Err210ELen>
	; version 6.0
	MsgStruc <211,Err211Msg,Err211Len,Err211Expln,Err211ELen>
	MsgStruc <212,Err212Msg,Err212Len,Err212Expln,Err212ELen>
	MsgStruc <213,Err213Msg,Err213Len,Err213Expln,Err213ELen>
	MsgStruc <214,Err214Msg,Err214Len,Err214Expln,Err214ELen>

NumErr	= ($-ErrTbl) / (SIZE MsgStruc)

ErrorMessage	PROC FAR
	PUBLIC	ErrorMessage
	; Restore exit procedure pointer
	uses	ds
	mov	ax,ds
	mov	es,ax
	mov	di,OFFSET ExitProc
	mov	si,OFFSET ExitSave
	cld
	movsw				; copy pointer
	movsw				;
	;--------------------------------------------------------------
	; Get to new line on display
	;--------------------------------------------------------------
	mov	ax,cs
	mov	ds,ax
	mov	cx,NewLineLen
	mov	dx,OFFSET NewLine
	mov	ah,40h
	mov	bx,0001h
	int	21h
	;--------------------------------------------------------------
	; see if exit ptr is zero
	;--------------------------------------------------------------
	pop	ds		; restore data segment value
	push	ds
	les	di,[ErrorAddr]
	mov	ax,es
	or	ax,di
	jnz	NonZeroError
	;--------------------------------------------------------------
	; No error, but look at exit code
	;--------------------------------------------------------------
	mov	[Msg1],OFFSET NormalMsg1
	mov	[Msg1Len],NormalMsg1Len
	mov	[Msg2],OFFSET NormalMsg2
	mov	[Msg2Len],NormalMsg2Len
	jmp	MsgWithNum
	;--------------------------------------------------------------
	; Non-zero error address, means we have an error
	;--------------------------------------------------------------
NonZeroError:
	mov	si,(OFFSET ErrTbl)-(SIZE MsgStruc)
	mov	ax,[ExitCode]
	mov	cx,NumErr
FindLoop:
	add	si,SIZE MsgStruc
	cmp	ax,[MsgStruc (cs:si).Num]
	loopne	FindLoop
	je	PrintErrMsg
	;--------------------------------------------------------------
	; Non-zero error address with unknown error code
	;--------------------------------------------------------------
DontKnow:
	mov	[Msg1],OFFSET UnknownMsg1
	mov	[Msg1Len],UnknownMsg1Len
	mov	[Msg2],OFFSET UnknownMsg2
	mov	[Msg2Len],UnknownMsg2Len
	;--------------------------------------------------------------
	; Print message with error code
	;--------------------------------------------------------------
MsgWithNum:
	; print first part of msg
	mov	cx,[Msg1Len]
	mov	dx,[Msg1]
	mov	ax,cs
	mov	ds,ax
	mov	ah,40h
	mov	bx,0001h
	int	21h
	pop	ds				; restore data segment
	push	ds
	mov	ax,[ExitCode]
	mov	bx,(OFFSET Buffer)+(BufferSize)
	xor	cx,cx
	mov	si,10
Cnvrt:	dec	bx
	xor	dx,dx
	inc	cx
	div	si
	add	dx,'0'
	mov	[bx],dl
	or	ax,ax
	jnz	Cnvrt
	; print exit code number
	mov	dx,bx
	mov	ah,40h
	mov	bx,0001h
	int	21h
	; print tail end of msg
	mov	cx,[Msg2Len]
	mov	dx,[Msg2]
	mov	ax,cs
	mov	ds,ax
	mov	ah,40h
	mov	bx,0001h
	int	21h
	jmp	Done
	;--------------------------------------------------------------
	; Print error message selected from search loop
	;--------------------------------------------------------------
PrintErrMsg:
	mov	ax,cs
	mov	ds,ax
	mov	ah,40h
	mov	bx,0001h
	mov	dx,[MsgStruc (cs:si).MsgPtr]
	mov	cx,[MsgStruc (cs:si).MsgLen]
	int	21h
	pop	ds
	push	ds
	test	[VerboseMsg],0ffh
	jz	Done
	; Print explaination string
	mov	ax,cs
	mov	ds,ax
	mov	ah,40h
	mov	bx,0001h
	mov	dx,[MsgStruc (cs:si).ExpPtr]
	mov	cx,[MsgStruc (cs:si).ExpLen]
	int	21h
	;
	;--------------------------------------------------------------
	;
Done:
	ret
ErrorMessage	ENDP

END
