{ RNGLIB.PAS : Integer range handling routine library

  Title   : RNGLIB
  Version : 4.0
  Date    : Nov 11,1996
  Author  : J R Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0 (a;; targets)
            Borland Delphi 1.0 for Windows
  Usage   : Unit

  The internal representation of a (possibly broken) integer range is
  an ordered list of non-overlapping low-high intervals.
}

UNIT RngLib;

INTERFACE


type
  RngTyp = ^RngRec;                                  { public }
  RngRec = record l,h: integer; nxt: RngTyp end;     { for internal use }


procedure RngCreate(var r: RngTyp);
{ Create empty range }

procedure RngDispose(var r: RngTyp);
{ Dispose possibly non-empty range structure }

function RngInside(r: RngTyp; i: integer): boolean;
{ Test if value i is inside range r }

procedure RngInsert(var r: RngTyp; l,h: integer);
{ Insert range [l,h] into range r }

procedure RngDelete(var r: RngTyp; l,h: integer);
{ Delete range [l,h] from range r }

procedure RngMerge(var r1: RngTyp; r2: RngTyp);
{ Merge range r2 into range r1 (result in r1) }

procedure RngRemove(var r1: RngTyp; r2: RngTyp);
{ Remove range r2 from range r1 (result in r1) }



IMPLEMENTATION


{--- Local routines ---}

procedure order(var l,h: integer);
var t: integer;
begin if l>h then begin t:= l; l:= h; h:= t end end;


function below(r: RngTyp; i: integer): boolean;
begin if r=nil then below:= false else below:= i < r^.l end;


function above(r: RngTyp; i: integer): boolean;
begin if r=nil then above:= false else above:= i > r^.h end;


function inside(r: RngTyp; i: integer): boolean;
begin
  if r=nil then inside:= false else inside:= (i >= r^.l) and (i <= r^.h)
end;

function connected(r1,r2: RngTyp): boolean;
begin
  if r2=nil then connected:= false else connected:= r1^.h >= pred(r2^.l)
end;


function included(r: RngTyp; l,h: integer): boolean;
begin
  if r=nil then included:= true
  else included:= (l >= r^.l) and (h < r^.h)
end;


function minimum(i1,i2: integer): integer;
begin if i1<i2 then minimum:= i1 else minimum:= i2 end;


function maximum(i1,i2: integer): integer;
begin if i1>i2 then maximum:= i1 else maximum:= i2 end;



{--- Interfaced routines ---}

procedure RngCreate(var r: RngTyp);
begin r:= nil end;


procedure RngDispose(var r: RngTyp);
begin if r<>nil then begin RngDispose(r^.nxt); dispose(r); end; end;


function RngInside(r: RngTyp; i: integer): boolean;
begin
  if      r=nil      then RngInside:= false
  else if above(r,i) then RngInside:= RngInside(r^.nxt,i)
  else                    RngInside:= inside(r,i);
end;


procedure RngInsert(var r: RngTyp; l,h: integer);
var r0: RngTyp;
begin
  order(l,h);
  if above(r,pred(l)) then RngInsert(r^.nxt,l,h)
  else if (r=nil) or below(r,succ(h)) then begin
    new(r0); r0^.l:= l; r0^.h:= h; r0^.nxt:= r; r:= r0;
  end
  else if not included(r,l,h) then begin
    r^.l:= minimum(l,r^.l);
    r^.h:= maximum(h,r^.h);
    while connected(r,r^.nxt) do begin
      r0     := r^.nxt;
      r^.h   := maximum(r^.h,r0^.h);
      r^.nxt := r0^.nxt;
      dispose(r0);
    end;
  end;
end;


procedure RngDelete(var r: RngTyp; l,h: integer);
var r0: RngTyp;
begin if r<>nil then begin
  order(l,h);
  if above(r,l) then RngDelete(r^.nxt,l,h)
  else if not below(r,h) then begin
    if l > r^.l then begin
      if h < r^.h then begin
        new(r0);
        r0^.l:= succ(h); r0^.h:= r^.h; r0^.nxt:= r^.nxt;
        r^.h:= pred(l); r^.nxt:= r0;
      end
      else begin
        r^.h:= pred(l);
        RngDelete(r^.nxt,l,h);
      end;
    end
    else begin { l <= r^.l }
      if h < r^.h then r^.l:= succ(h)
      else begin
        r0:= r; r:= r^.nxt; dispose(r0);
        RngDelete(r,l,h);
      end;
    end;
  end;
end end;


procedure RngMerge(var r1: RngTyp; r2: RngTyp);
begin with r2^ do begin
  if r2<>nil then begin RngInsert(r1,l,h); RngMerge(r1,nxt) end;
end end;


procedure RngRemove(var r1: RngTyp; r2: RngTyp);
begin with r2^ do begin
  if r2<>nil then begin RngDelete(r1,l,h); RngRemove(r1,nxt) end;
end end;


END.
