unit KeyNames;

{ Graphics Vision Unit,
  Copr. 1995 Matthias Koeppe

  Determines the name of a key specified by its scan-code, using
  language-dependent components.
}

{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}

interface

{$ifdef Windows}
uses WinGr, GvViews, GvMenus;
{$else}
uses WinRes, GvViews, GvMenus;
{$endif}

const
  sComposeKeys   = 200;
  sSequenceKeys  = 201;
  sAltModifier   = 202;
  sCtrlModifier  = 203;
  sShiftModifier = 204;
  sFunctionKey   = 205;
  sEscapeKey     = 206;
  sTabKey        = 207;
  sPrintKey      = 208;
  sScrollKey     = 209;
  sPauseKey      = 210;
  sBackspaceKey  = 211;
  sEnterKey      = 212;
  sInsertKey     = 213;
  sDeleteKey     = 214;
  sHomeKey       = 215;
  sEndKey        = 216;
  sPageUpKey     = 217;
  sPageDownKey   = 218;
  sSpaceKey      = 219;
  sLeftKey       = 220;
  sRightKey      = 221;
  sUpKey         = 222;
  sDownKey       = 223;
  sMinusKey      = 224;
  sPlusKey       = 225;
  sAltMinusKey   = 226;
  sAltEqualKey   = 227;

function kn(KeyCode: Word): string;

{ Simplified menu NewItem function
}
function NewItemKn(Name: TMenuStr; KeyCode: Word; Command: Word;
  AHelpCtx: Word; Next: PMenuItem): PMenuItem;
function NewItemKnHc(Name: TMenuStr; KeyCode: Word; Command: Word;
  Next: PMenuItem): PMenuItem;

{ Simplified NewStatusKey function
}
function NewStatusKeyKn(Text: String; KeyCode: Word; Command: Word;
  Next: PStatusItem): PStatusItem;

{ Add accelerator codes and key names to a menu
}
{$ifndef Windows}
procedure AddAccelerators(Menu: PMenu; Accelerators: PAccelerators);
{$endif}

implementation

uses Objects, GvTexts, Drivers;

function kn(KeyCode: Word): string;
var
  c: Char;

	function F(num: integer): string;
	var
	  s: string[2];
	begin
	  Str(num, s);
	  F := GetStr(sFunctionKey) + s
	end;

	function Compose(Modifier: Integer; Key: string): string;
	begin
	  Compose := GetStr(Modifier) + GetStr(sComposeKeys) + Key
	end;

	function Comp(Modifier: Integer; Key: Integer): string;
        begin
	  Comp := Compose(Modifier, GetStr(Key))
        end;

begin
  kn := '';
  c := GetAltChar(KeyCode);
  If c <> #0
  then kn := GetStr(sAltModifier) + GetStr(sComposeKeys) + c
  else begin
    c := GetCtrlChar(KeyCode);
    If c <> #0
    then kn := GetStr(sCtrlModifier) + GetStr(sComposeKeys) + c;
  end;
  If Lo(KeyCode) = 0 then
  case Hi(KeyCode) of
    $3B..$44:
      kn := F(Hi(KeyCode) - $3A);
    $54..$5D:
      kn := Compose(sShiftModifier, F(Hi(KeyCode) - $53));
    $5E..$67:
      kn := Compose(sCtrlModifier, F(Hi(KeyCode) - $5D));
    $68..$71:
      kn := Compose(sAltModifier, F(Hi(KeyCode) - $67));
    Hi(kbAltEqual):
      kn := GetStr(sAltEqualKey);
    Hi(kbAltMinus):
      kn := GetStr(sAltMinusKey);
    Hi(kbAltSpace):
      kn := Comp(sAltModifier, sSpaceKey);
    Hi(kbCtrlDel):
      kn := Comp(sCtrlModifier, sDeleteKey);
    Hi(kbCtrlEnd):
      kn := Comp(sCtrlModifier, sEndKey);
    Hi(kbCtrlHome):
      kn := Comp(sCtrlModifier, sHomeKey);
    Hi(kbCtrlIns):
      kn := Comp(sCtrlModifier, sInsertKey);
    Hi(kbCtrlLeft):
      kn := Comp(sCtrlModifier, sLeftKey);
    Hi(kbCtrlPgDn):
      kn := Comp(sCtrlModifier, sPageDownKey);
    Hi(kbCtrlPgUp):
      kn := Comp(sCtrlModifier, sPageUpKey);
    Hi(kbCtrlPrtSc):
      kn := Comp(sCtrlModifier, sPrintKey);
    Hi(kbCtrlRight):
      kn := Comp(sCtrlModifier, sRightKey);
    Hi(kbDel):
      kn := GetStr(sDeleteKey);
    Hi(kbDown):
      kn := GetStr(sDownKey);
    Hi(kbEnd):
      kn := GetStr(sEndKey);
    Hi(kbHome):
      kn := GetStr(sHomeKey);
    Hi(kbIns):
      kn := GetStr(sInsertKey);
    Hi(kbLeft):
      kn := GetStr(sLeftKey);
    Hi(kbPgDn):
      kn := GetStr(sPageDownKey);
    Hi(kbPgUp):
      kn := GetStr(sPageUpKey);
    Hi(kbRight):
      kn := GetStr(sRightKey);
    Hi(kbShiftDel):
      kn := Comp(sShiftModifier, sDeleteKey);
    Hi(kbShiftIns):
      kn := Comp(sShiftModifier, sInsertKey);
    Hi(kbShiftTab):
      kn := Comp(sShiftModifier, sTabKey);
    Hi(kbUp):
      kn := GetStr(sUpKey);
  end else
  case KeyCode of
    kbBack:
      kn := GetStr(sBackspaceKey);
    kbCtrlBack:
      kn := Comp(sCtrlModifier, sBackspaceKey);
    kbCtrlEnter:
      kn := Comp(sCtrlModifier, sEnterKey);
    kbEnter:
      kn := GetStr(sEnterKey);
    kbEsc:
      kn := GetStr(sEscapeKey);
    kbGrayMinus:
      kn := GetStr(sMinusKey);
    kbGrayPlus:
      kn := GetStr(sPlusKey);
    kbTab:
      kn := GetStr(sTabKey);
  end;
end;

function NewItemKn(Name: TMenuStr; KeyCode: Word; Command: Word;
  AHelpCtx: Word; Next: PMenuItem): PMenuItem;
begin
  NewItemKn := NewItem(Name, kn(KeyCode), KeyCode, Command, AHelpCtx, Next)
end;

function NewItemKnHc(Name: TMenuStr; KeyCode: Word; Command: Word;
  Next: PMenuItem): PMenuItem;
begin
  NewItemKnHc := NewItem(Name, kn(KeyCode), KeyCode, Command, hc + Command, Next)
end;

function NewStatusKeyKn(Text: String; KeyCode: Word; Command: Word;
  Next: PStatusItem): PStatusItem;
begin
  NewStatusKeyKn := NewStatusKey('~' + kn(KeyCode) + '~ ' + Text,
    KeyCode, Command, Next)
end;

{$ifndef Windows}
procedure AddAccelerators(Menu: PMenu; Accelerators: PAccelerators);
var
  Item: PMenuItem;
begin
  If Menu <> nil
  then begin
    Item := Menu^.Items;
    while Item <> nil do
      with Item^ do
      begin
	If Command = 0
	then AddAccelerators(SubMenu, Accelerators)
	else begin
	  If Accelerators <> nil
	  then begin
	    if KeyCode = 0
	    then KeyCode := LookUpAccelerator(Accelerators, Command)
	  end;
	  If (KeyCode <> 0) and (Param = nil)
	  then Param := NewStr(kn(KeyCode))
	end;
	Item := Next
      end
  end
end;
{$endif}

end.
