
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVAPP.TXT GVAPP.DOC GINFO.TXT NEW.TXT GV.VER
}

unit GVApp;

{ Unit GVApp enthlt die Typen TProgram und TApplication }

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

interface

{$ifdef Windows}
uses WinDos, Dos, WinTypes, Objects, Drivers, WinGr, OMemory, Views, GvViews,
     GvDialog, GvMenus;
{$else}
uses Dos, Objects, Drivers, Memory, Views, GVViews, GVDialog, GVMenus;

{$define AsyncMouse -- No synchronous call-backs from the mouse handler }

{$endif Windows}

const

{ TApplication palette }

  CColor = #03#00#07#12#15#07#12#15#00#15#07#15#01#00#15#01#00#15#07#00#15#08+  {  22 }
	   #15#00#07#08#07#00#15#15#07#07#07#15#01#00#15#01#00#15#07#00#15#08+  {  44 }
	   #15#00#07#08#07#00#15#07#01#03#07#15#01#00#15#01#00#15#07#00#15#08+  {  66 }
	   #15#00#07#08#07#07#00#00#07#15#07#15#01#00#15#01#00#15#07#00#15#08+  {  88 }
	   #15#00#07#08#07#00#00#15#04#04#07#07#00#09#07#00#14#15#06#12#12#12+  { 110 }
	   #08#00#09#00#07#15#00#15#14#14#07#07#07#08#15#15#07#02#00#00#15#07+  { 132 }
	   #00#15#00#00#15#15#00#15#07#00#07#06#08#07#15#01#00#15#01#00#15#07+  { 154 }
	   #00#15#08#15#00#07#08#07#15#15#01#00#02;				{ 167 }

{ Application idle command }

  cmIdle  = 41;

{ Standard application commands }

  cmNew       = 30;
  cmOpen      = 31;
  cmSave      = 32;
  cmSaveAs    = 33;
  cmSaveAll   = 34;
  cmChangeDir = 35;
  cmDosShell  = 36;
  cmCloseAll  = 37;

{ Standard application help contexts }

  hcNew          = hc + cmNew;
  hcOpen         = hc + cmOpen;
  hcSave         = hc + cmSave;
  hcSaveAs       = hc + cmSaveAs;
  hcSaveAll      = hc + cmSaveAll;
  hcChangeDir    = hc + cmChangeDir;
  hcDosShell     = hc + cmDosShell;
  hcExit         = hc + cmQuit;

  hcUndo         = hc + cmUndo;
  hcCut          = hc + cmCut;
  hcCopy         = hc + cmCopy;
  hcPaste        = hc + cmPaste;
  hcClear        = hc + cmClear;

  hcTile         = hc + cmTile;
  hcCascade      = hc + cmCascade;
  hcCloseAll     = hc + cmCloseAll;
  hcResize       = hc + cmResize;
  hcZoom         = hc + cmZoom;
  hcNext         = hc + cmNext;
  hcPrev         = hc + cmPrev;
  hcClose        = hc + cmClose;

type

{ TDeskTop object }

  PDeskTop = ^TDeskTop;
  TDeskTop = object(TGGroup)
    Background: PBackground;
    TileColumnsFirst: Boolean;
    constructor Init(var Bounds: TRect);
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
    procedure Cascade(var R: TRect);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitBackground; virtual;
    procedure Tile(var R: TRect);
    procedure TileError; virtual;
  end;

{ TRoot object }

  PRoot = ^TRoot;
  TRoot = object(TGGroup)
    constructor Init;
    destructor Done; virtual;
    procedure DoneEvents; virtual;
    procedure DoneSystem; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitEvents; virtual;
    procedure InitScreen; virtual;
    procedure InitSystem; virtual;
    procedure PutEvent(var Event: TEvent); virtual;
    procedure Run; virtual;
    procedure Timer(var Event: TEvent); virtual;
  end;

{ TProgram object }

  { Palette layout }
  {      1 = TBackground }
  {  2-  9 = TMenuView/TStatusLine }
  { 10- 31 = TWindow (White) }
  { 32- 53 = TWindow (Gray) }
  { 54- 75 = TWindow (Cyan) }
  { 76-139 = TDialog }
  {140-144 = misc }
  {145-165 = THelpWindow }

    {  94 = StaticText and StaticSign }
    {  95 = Label normal text }
    {  96 = Label selected text }
    {  97 = Label normal shortcut }
    {  98 = Label selected shortcut }
    {  99 = Label normal background }
    { 100 = Label selected background }
    { 101 = Icon normal background }
    { 102 = Icon selected background }
    { 103 = Button background }
    { 104 = Button normal text }
    { 105 = Button default text }
    { 106 = Button selected text }
    { 107 = Button disabled text }
    { 108 = Button normal shortcut }
    { 109 = Button default shortcut }
    { 110 = Button selected shortcut }
    { 111 = Button border }
    { 112 = Button lines }
    { 113 = Regler frame selected }
    { 114 = Regler frame normal }
    { 115 = Regler frame disabled }
    { 116 = Regler background }
    { 117 = Cluster normal text }
    { 118 = Cluster selected text }
    { 119 = Cluster normal shortcut }
    { 120 = Cluster selected shortcut }
    { 121 = Cluster normal background }
    { 122 = Cluster selected background }
    { 123 = Cluster disabled background
    { 124 = Cluster disabled text }
    { 125 = InputLine passive }
    { 126 = InputLine active }
    { 127 = InputLine selected }
    { 128 = InputLine arrows }
    { 129 = InputLine frame }
    { 130 = InputLine text }
    { 131 = InputLine cursor }
    { 132 = Arrowfield background }
    { 133 = Arrowfield icon }
    { 134 = ListViewer background }
    { 135 = ListViewer frame }
    { 136 = ListViewer normal text }
    { 137 = ListViewer selected text }
    { 138 = ListViewer normal background }
    { 139 = ListViewer selected background }
    { 140 = InfoPane text }
    { 141 = InfoPane background }
    { 142 = Clock text }
    { 143 = Clock background }
    { 144 = Eye color }

  PProgram = ^TProgram;
  TProgram = object(TRoot)
    constructor Init;
    destructor Done; virtual;
    function CanMoveFocus: Boolean;
    procedure DoneFonts; virtual;
    procedure DoneTexts; virtual;
    function ExecuteDialog (P: PDialog; Data: Pointer): Word;
    procedure GetEvent(var Event: TEvent); virtual;
    function GetPalette: PPalette; virtual;
    procedure Idle; virtual;
    procedure InitDesktop; virtual;
    procedure InitFonts; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure InitTexts; virtual;
    function InsertWindow(P: PWindow): PWindow;
    function LanguageResource: string; virtual;
    procedure OutOfMemory; virtual;
    procedure SetScreenMode(Mode: Word);
    function ValidView(P: PGView): PGView;
  end;

{ TApplication object }

  PApplication = ^TApplication;
  TApplication = object(TProgram)
    constructor Init;
    destructor Done; virtual;
    procedure Cascade;
    procedure DoneSystem; virtual;
    procedure DosShell;
    procedure GetTileRect(var R: TRect); virtual;
    procedure InitSystem; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Tile;
    procedure WriteShellMsg; virtual;
  end;

{ Standard menus and status lines }

function StdStatusKeys(Next: PStatusItem): PStatusItem;

function StdFileMenuItems(Next: PMenuItem): PMenuItem;
function StdEditMenuItems(Next: PMenuItem): PMenuItem;
function StdWindowMenuItems(Next: PMenuItem): PMenuItem;

{ GVApp registration procedure }

  procedure RegisterGVApp;

const

{ Public variables }

  Root: PRoot = nil;
  Application: PProgram = nil;
  Desktop: PDesktop = nil;
  MenuBar: PMenuView = nil;
  StatusLine: PStatusLine = nil;

{ Stream registration records }

  RDeskTop: TStreamRec = (
    ObjType: 146;
    VmtLink: Ofs(TypeOf(TDeskTop)^);
    Load: @TDeskTop.Load;
    Store: @TDeskTop.Store);

implementation

{$ifdef Windows}
uses WinProcs, VgaMem, ExtGraph, HistList, GvTexts, KeyNames;
{$else}
Uses GVDriver, MyMouse, MyFonts, Gr, Extgraph, VGAMem, HistList, GVTexts,
  KeyNames;
{$endif}

const

{ Private variables }

  Pending: TEvent = (What: evNothing);

{$ifdef Windows}
procedure DoPaint(View: pointer; var PS: TPaintStruct); far;
begin
  If View <> nil
  then PGView(View)^.DrawView;
end;

procedure DoChangeSize(x, y: Integer); far;
begin
  If Application <> nil
  then begin
    with Application^ do
    begin
      Lock;
      GrowTo(x, y);
      Unlock;
    end;
    ValidateRect(HWindow, nil)
  end;
end;

procedure DoGetMCursor(n: Integer); far;
const
  sysCursor: array[mcStd..mcLargeCross] of PChar
    = (IDC_ARROW, IDC_CROSS, IDC_WAIT, IDC_CROSS);
  gvCursor: array[mcInput..mcResizeHori] of PChar
    = (IDC_IBEAM, IDC_SIZE, IDC_SIZENWSE, IDC_SIZENESW,
       IDC_SIZENS, IDC_SIZEWE);
begin
  If n in [Low(sysCursor)..High(sysCursor)]
  then CursorHandle := LoadCursor(0, sysCursor[n]) else
  if n in [Low(gvCursor)..High(gvCursor)]
  then CursorHandle := LoadCursor(0, gvCursor[n]);
end;

{$else}
var
  SaveGetMC: TGetMCProc;

procedure DoGetMCursor (n: Integer); far; assembler;
Asm
	MOV	AX, n
	MOV	MyMouse.CursorNum, AX
	MOV	BX, AX
	SUB	AX, 50
	JB	@@1
	PUSH	BX
	CALL	GetGVViewsCursor
	PUSH	BX
	CALL	GetGVDialogCursor
	JMP	@@2
@@1:	PUSH	BX
	CALL	SaveGetMC
@@2:
End;
{$endif}

procedure DoChMCursor; far;
Begin
  If MCurrent=mcNoCursor then Begin
    NewNum:=MCurStandard;
    If Application<>nil then Application^.ChMCursor;
  End
  Else NewNum:=MCurrent;
End;

(***************************** TDesktop object ******************************)

constructor TDeskTop.Init;
begin
  TGGroup.Init(Bounds);
  GrowMode := gfGrowHiX + gfGrowHiY;
  TileColumnsFirst := true;
  InitBackground;
  If Background <> nil then Insert (Background);
end;

constructor TDesktop.Load;
Begin
  TGGroup.Load (S);
  GetSubViewPtr (S,Background);
  S.Read(TileColumnsFirst, SizeOf(TileColumnsFirst));
End;

procedure TDesktop.Store;
Begin
  TGGroup.Store (S);
  PutSubViewPtr (S,BackGround);
  S.Write(TileColumnsFirst, SizeOf(TileColumnsFirst));
End;

function Tileable (P: PGView): Boolean;
begin
  Tileable := (P^.Options and ofTileable <> 0) and
    (P^.State and sfVisible <> 0);
end;

procedure TDeskTop.Cascade;
var
  CascadeNum: Integer;
  LastView: PGView;
  Min, Max: TPoint;

 procedure DoCount(P: PGView); far;
 begin
   if Tileable(P) then
   begin
     Inc(CascadeNum);
     LastView := P;
   end;
 end;

 procedure DoCascade(P: PGView); far;
 var
   NR: TRect;
 begin
   if Tileable(P) and (CascadeNum >= 0) then
   begin
     NR.Copy(R);
     Inc(NR.A.X, CascadeNum*20); Inc(NR.A.Y, CascadeNum*20);
     P^.Locate(NR);
     Dec(CascadeNum);
   end;
 end;

begin
  CascadeNum := 0;
  ForEach(@DoCount);
  if CascadeNum > 0 then
  begin
    LastView^.SizeLimits(Min, Max);
    if (Min.X > R.B.X - R.A.X - (CascadeNum-1)*20) or
       (Min.Y > R.B.Y - R.A.Y - (CascadeNum-1)*20) then TileError
    else
    begin
      Dec(CascadeNum);
      Lock;
      ForEach(@DoCascade);
      Unlock;
    end;
  end;
end;

procedure TDeskTop.HandleEvent;
begin
  TGGroup.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmNext: SelectNext(false);
      cmPrev: SelectNext(true);
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TDeskTop.InitBackground;
var
  R: TRect;
begin
  GetExtent(R);
  New(Background, Init (R));
end;

function ISqr(X: Integer): Integer; assembler;
asm
	MOV	CX,X
	MOV	BX,0
@@1:    INC     BX
	MOV	AX,BX
	IMUL	AX
        CMP	AX,CX
        JLE	@@1
	MOV	AX,BX
        DEC     AX
end;

procedure MostEqualDivisors(N: Integer; var X, Y: Integer; FavorY: Boolean);
var
  I: Integer;
begin
  I := ISqr(N);
  if ((N mod I) <> 0) then
    if (N mod (I+1)) = 0 then Inc(I);
  if I < (N div I) then I := N div I;
  if FavorY then
  begin
    X := N div I;
    Y := I;
  end
  else
  begin
    Y := N div I;
    X := I;
  end;
end;

procedure TDeskTop.Tile;
var
  NumCols, NumRows, NumTileable, LeftOver, TileNum: Integer;

 procedure DoCountTileable(P: PGView); far;
 begin
   if Tileable(P) then Inc(NumTileable);
 end;

 function DividerLoc(Lo, Hi, Num, Pos: Integer): Integer;
 begin
   DividerLoc := LongDiv(LongMul(Hi - Lo, Pos), Num) + Lo;
 end;

 procedure CalcTileRect(Pos: Integer; var NR: TRect);
 var
   X,Y,D: Integer;
 begin
   D := (NumCols - LeftOver) * NumRows;
   if Pos < D then
   begin
     X := Pos div NumRows;
     Y := Pos mod NumRows;
   end else
   begin
     X := (Pos - D) div (NumRows + 1) + (NumCols - LeftOver);
     Y := (Pos - D) mod (NumRows + 1);
   end;
   NR.A.X := DividerLoc(R.A.X, R.B.X, NumCols, X);
   NR.B.X := DividerLoc(R.A.X, R.B.X, NumCols, X+1);
   if Pos >= D then
   begin
     NR.A.Y := DividerLoc(R.A.Y, R.B.Y, NumRows+1, Y);
     NR.B.Y := DividerLoc(R.A.Y, R.B.Y, NumRows+1, Y+1);
   end else
   begin
     NR.A.Y := DividerLoc(R.A.Y, R.B.Y, NumRows, Y);
     NR.B.Y := DividerLoc(R.A.Y, R.B.Y, NumRows, Y+1);
   end;
 end;

 procedure DoTile(P: PGView); far;
 var
   R: TRect;
 begin
   if Tileable(P) then
   begin
     CalcTileRect(TileNum, R);
     P^.Locate(R);
     Dec(TileNum);
   end;
 end;

begin
  NumTileable := 0;
  ForEach(@DoCountTileable);
  if NumTileable > 0 then
  begin
    MostEqualDivisors(NumTileable, NumCols, NumRows, not TileColumnsFirst);
    if ((R.B.X - R.A.X) div NumCols = 0) or
       ((R.B.Y - R.A.Y) div NumRows = 0) then TileError
    else
    begin
      LeftOver := NumTileable mod NumCols;
      TileNum := NumTileable-1;
      Lock;
      ForEach(@DoTile);
      Unlock;
    end;
  end;
end;

procedure TDesktop.TileError;
begin
end;

(****************************** TRoot object ********************************)

constructor TRoot.Init;
var
  R: TRect;
begin
  If Root = nil
  then Root := @Self;
  InitSystem;
  InitScreen;
  R.Assign(0, 0, SizeX, SizeY);
  inherited Init(R);
  State := sfVisible + sfSelected + sfFocused + sfModal + sfExposed;
  If Root <> @Self
  then Root^.Insert(@Self)
end;

destructor TRoot.Done;
begin
  TGGroup.Done;
  DoneSystem;
  If Root = @Self then Root := nil;
end;

procedure TRoot.DoneEvents;
Begin
  {$ifndef Windows}
  If Root = @Self then
  GVDriver.DoneEvents;
  {$endif}
End;

procedure TRoot.DoneSystem;
begin
end;

procedure TRoot.GetEvent(var Event: TEvent);
begin
  If Root <> @Self
  then inherited GetEvent(Event)
  else begin
    if Pending.What <> evNothing then
    begin
      Event := Pending;
      Pending.What := evNothing;
    end else
    begin
      GetMouseEvent(Event);
      {$ifndef Windows}
      {$ifdef AsyncMouse}
      If MouseInstalled
      then begin
	DoChMCursor;
	If NewNum <> CursorNum
	then begin
	  DoGetMCursor(NewNum);
	  SetCursorPtr(CursorPtr)
	end
      end;
      {$endif AsyncMouse}
      {$endif Windows}
      if Event.What = evNothing then
      begin
	GetKeyEvent(Event);
	if Event.What = evNothing then begin
	  GetTimerEvent (Event);
	  If Event.What = evTimer
	  then begin
	    Timer(Event);
	    ClearEvent(Event)
	  end
	  else Idle;
	end;
      end;
    end;
  end;
end;

procedure TRoot.HandleEvent(var Event: TEvent);
var
  I: Word;
  C: Char;
begin
  TGGroup.HandleEvent(Event);
  if Event.What = evCommand then
    if Event.Command = cmQuit then
    begin
      EndModal(cmQuit);
      ClearEvent(Event);
    end;
  if (Event.What = evBroadcast) and (Event.Command = cmIdle) and (Root <> @Self)
  then Idle;
end;

procedure TRoot.Idle;
begin
  If Root = @Self
  then begin
    If CommandSetChanged then Begin
      Message(@Self, evBroadcast, cmCommandSetChanged, nil);
      CommandSetChanged := False;
    End;
    Message(@Self, evBroadCast, cmIdle, nil)
  end;
end;

procedure TRoot.InitEvents;
Begin
  If Root = @Self
  then begin
    {$ifdef Windows}
    ChangeCursor:=DoChMCursor;
    WinGr.GetMCursor:=DoGetMCursor;
    {$else}
    GVDriver.InitEvents;
    SaveGetMC:=MyMouse.GetMCursor;
    {$ifndef AsyncMouse}
    ChangeCursor:=DoChMCursor;
    MyMouse.GetMCursor:=DoGetMCursor;
    {$endif AsyncMouse}
    {$endif Windows}
  end;
End;

procedure TRoot.InitScreen;
Begin
{$ifdef Windows}
  SizeX := GetSystemMetrics(sm_cxscreen);
  SizeY := GetSystemMetrics(sm_cyscreen);
{$endif Windows}
End;

procedure TRoot.InitSystem;
begin
end;

procedure TRoot.PutEvent(var Event: TEvent);
begin
  If Root = @Self
  then Pending := Event
  else inherited PutEvent(Event)
end;

procedure TRoot.Run;
begin
  Execute;
end;

procedure TRoot.Timer(var Event: TEvent);
begin
  HandleEvent(Event)
end;

(***************************** TProgram object ******************************)

constructor TProgram.Init;
var
  R: TRect;
begin
  Application := @Self;
  inherited Init;
  SetState(sfRoot, true);
  InitFonts;
  InitDesktop;
  InitMenuBar;
  InitStatusLine;
  If Desktop <> nil then Insert(Desktop);
  If MenuBar <> nil then Insert(MenuBar);
  If StatusLine <> nil then Insert(StatusLine);
end;

destructor TProgram.Done;
begin
  DoneFonts;
  inherited Done;
  MenuBar:=nil;
  StatusLine:=nil;
  Desktop:=nil;
  Application:=nil;
end;

function TProgram.CanMoveFocus;
Begin
  CanMoveFocus := Desktop^.Valid(cmReleasedFocus);
End;

procedure TProgram.DoneFonts;
begin
  {$ifdef Windows}
  WinGr.DoneFonts
  {$else}
  GVDriver.DoneFonts
  {$endif}
end;

procedure TProgram.DoneTexts;
Begin
  FreeTexts
End;

function TProgram.ExecuteDialog;
var C: Word;
Begin
  ExecuteDialog := cmCancel;
  If ValidView (P) <> nil then Begin
    If Data <> nil then P^.SetData (Data^);
    C := Desktop^.ExecView (P);
    If (C <> cmCancel) and (Data <> nil) then P^.GetData (Data^);
    Dispose (P, Done);
    ExecuteDialog := C;
  End;
End;

procedure TProgram.GetEvent(var Event: TEvent);

	function ContainsMouse(P: PView): Boolean; far;
	begin
	  ContainsMouse := (P^.State and sfVisible <> 0) and
	    P^.MouseInView(Event.Where);
	end;

begin
  inherited GetEvent(Event);
  if StatusLine <> nil then
    if (Event.What and evKeyDown <> 0) or
      (Event.What and evMouseDown <> 0) and
      (FirstThat(@ContainsMouse) = PGView(StatusLine)) then
      StatusLine^.HandleEvent(Event);
end;

function TProgram.GetPalette;
const P: String[Length(CColor)] = CColor;
Begin
  GetPalette := @P;
End;

procedure TProgram.Idle;
begin
  If StatusLine <> nil then StatusLine^.Update;
  inherited Idle;
end;

procedure TProgram.InitDesktop;
var R: TRect;
Begin
  GetExtent (R);
  R.Grow (0,-21);
  Desktop:=New (PDesktop,Init (R));
End;

procedure TProgram.InitFonts;
begin
  {$ifdef Windows}
  WinGr.InitFonts;
  {$else}
  GvDriver.InitFonts
  {$endif}
end;

procedure TProgram.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 21;
  MenuBar := New (PMenuBar, Init (R, NewMenu (nil)));
end;

procedure TProgram.InitStatusLine;
Var R: TRect;
Begin
  GetExtent(R);
  R.A.Y := R.B.Y - 21;
  New(StatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('', kbF10, cmMenu, nil)), nil)));
End;

procedure TProgram.InitTexts;
var
  L: PStringList;
  Path: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
Begin
  FSplit(ParamStr(0), Dir, Name, Ext);
  Path := FSearch(LanguageResource, Dir + ';' + GetEnv('PATH'));
  LoadTexts(Path)
End;

function TProgram.InsertWindow;
Begin
  InsertWindow := nil;
  If ValidView(P) <> nil then
    If CanMoveFocus then Begin
      Desktop^.Insert(P);
      InsertWindow := P;
    End
    Else Dispose(P, Done);
End;

function TProgram.LanguageResource: string;
begin
  case Language of
    lfGerman:
      LanguageResource := 'GERMAN.GVL';
    else
      LanguageResource := 'ENGLISH.GVL';
  end;
end;

procedure TProgram.OutOfMemory;
begin
end;

procedure TProgram.SetScreenMode(Mode: Word);
var
  R: TRect;
begin
  {$ifndef Windows}
  GvDriver.SetScreenMode(Mode);
  R.Assign(0, 0, SizeX, SizeY);
  ChangeBounds(R)
  {$endif}
end;

function TProgram.ValidView;
begin
  ValidView := nil;
  if P <> nil then
  begin
    if LowMemory then
    begin
      Dispose(P, Done);
      OutOfMemory;
      Exit;
    end;
    if not P^.Valid(cmValid) then
    begin
      Dispose(P, Done);
      Exit;
    end;
    ValidView := P;
  end;
end;

(****************************** TApplication object *************************)

constructor TApplication.Init;
begin
  TProgram.Init;
  {$ifdef Windows}
  Paint := DoPaint;
  ChangeSize := DoChangeSize;
  {$endif}
end;

destructor TApplication.Done;
begin
  {$ifdef Windows}
  Paint := NoPaint;
  ChangeSize := NoChangeSize;
  {$endif}
  TProgram.Done;
end;

procedure TApplication.Cascade;
var R: TRect;
Begin
  GetTileRect(R);
  If Desktop <> nil then Desktop^.Cascade(R);
End;

procedure TApplication.DoneSystem;
begin
  DoneHistory;
  {$ifndef Windows}
  DoneMyFonts;
  {$endif}
  DoneVgaMem;
  DoneSysError;
  DoneVideo;
  DoneTexts;
  DoneEvents;
  DoneMemory;
end;

procedure TApplication.DosShell;
Begin
  {$ifndef Windows}
  DoneSysError;
  DoneVideo;
  DoneEvents;
  DoneDosMem;
  WriteShellMsg;
  SwapVectors;
  Exec(GetEnv('COMSPEC'), '');
  SwapVectors;
  InitDosMem;
  InitEvents;
  InitVideo;
  InitSysError;
  Redraw;
  {$endif Windows}
End;

procedure TApplication.GetTileRect;
Begin
  Desktop^.GetExtent(R);
End;

procedure TApplication.HandleEvent;
Begin
  TProgram.HandleEvent(Event);
  If Event.What = evCommand then Begin
    Case Event.Command of
      cmTile: Tile;
      cmCascade: Cascade;
      cmDosShell: DosShell;
     else Exit;
    End;
    ClearEvent(Event);
  End;
End;

procedure TApplication.InitSystem;
begin
  InitMemory;
  InitEvents;
  InitTexts;
  InitVideo;
  InitSysError;
  InitVgaMem;
  {$ifndef Windows}
  InitMyFonts;
  {$endif}
  InitHistory;
end;

procedure TApplication.Tile;
var R: TRect;
Begin
  GetTileRect(R);
  If Desktop <> nil then Desktop^.Tile(R);
End;

procedure TApplication.WriteShellMsg;
Begin
  PrintStr(GetStr(34));
End;

(******************** Standard menus and status lines ***********************)

function StdStatusKeys;
Begin
  StdStatusKeys :=
    NewStatusKey('', kbAltX, cmQuit,
    NewStatusKey('', kbF10, cmMenu,
    NewStatusKey('', kbAltF3, cmClose,
    NewStatusKey('', kbF5, cmZoom,
    NewStatusKey('', kbCtrlF5, cmResize,
    NewStatusKey('', kbF6, cmNext,
    NewStatusKey('', kbShiftF6, cmPrev,
    Next)))))));
End;

{ A little helper function. The menu item name is taken from the
  string resource. The key name (if any) is created by NewItemKN.
}
function NewItemX(Num: Word; Key: Word;
  Command: Word; Next: PMenuItem): PMenuItem;
begin
  NewItemX := NewItem(GetStr(Num), kn(Key), Key, Command, hc + Command, Next)
end;

function StdFileMenuItems;
Begin
  StdFileMenuItems :=
    NewItemX(35, kbNoKey, cmNew,
    NewItemX(36, kbF3, cmOpen,
    NewItemX(37, kbF2, cmSave,
    NewItemX(38, kbNoKey, cmSaveAs,
    NewItemX(39, kbNoKey, cmSaveAll,
    NewLine(
    NewItemX(40, kbNoKey, cmChangeDir,
    NewItemX(41, kbNoKey, cmDosShell,
    NewItemX(42, kbAltX, cmQuit,
    Next)))))))));
End;

function StdEditMenuItems;
const
      {$IFDEF Ver60}
      Key = kbCtrlBack;
      {$ELSE}
      Key = kbAltBack;
      {$ENDIF}
Begin
  StdEditMenuItems :=
    NewItemX(43, Key, cmUndo,
    NewLine(
    NewItemX(44, kbShiftDel, cmCut,
    NewItemX(45, kbCtrlIns, cmCopy,
    NewItemX(46, kbShiftIns, cmPaste,
    NewItemX(47, kbCtrlDel, cmClear,
    Next))))));
End;

function StdWindowMenuItems;
Begin
  StdWindowMenuItems :=
    NewItemX(52, kbNoKey, cmTile,
    NewItemX(53, kbNoKey, cmCascade,
    NewItemX(54, kbNoKey, cmCloseAll,
    NewLine(
    NewItemX(55, kbCtrlF5, cmResize,
    NewItemX(56, kbF5, cmZoom,
    NewItemX(57, kbF6, cmNext,
    NewItemX(58, kbShiftF6, cmPrev,
    NewItemX(59, kbAltF3, cmClose,
    Next)))))))));
End;

(************************ GVApp registration procedure **********************)

procedure RegisterGVApp;
Begin
  RegisterType (RDesktop);
End;

end.
