program getopttest;

(* Getopt for GNU.

   Copyright (C) 1987, 88, 89, 90, 91, 92, 93, 94, 95
   	Free Software Foundation, Inc.

   see getoptli.pas for complete comment.      *)


uses getoptlib;

const
  digit_optind : integer = 0;

var
  c : integer;
  this_option_optind : integer;


begin


  while true do
    begin

      if optind <> 0 then
        this_option_optind := optind
      else
        this_option_optind := 1;

      c := getopt (argc, argvptr^, 'abc:d::0123456789');
      if (c = EOF_getopt) then
	break;

      case c of
        integer('0')..integer('9'):
          begin
	    if ( (digit_optind <> 0) and (digit_optind <> this_option_optind) ) then
	      writeln('digits occur in two different argv-elements.');
	    digit_optind := this_option_optind;
	    writeln('option ', char(c));
          end;
        integer('a'):
          writeln('option a');
        integer('b'):
          writeln('option b');
        integer('c'):
          writeln('option c, argument ', optarg);
        integer('d'):
          writeln('option d, argument "', optarg, '"');
      else
        writeln('?? getopt returned character code ', c, ' ??');

      end; (* case *)

    end; (* while true *)


  if (optind < argc) then
    begin
      write('non-option ARGV-elements: ');
      while (optind < argc) do
        begin
          write( argvptr^[optind], ' ' );
          inc(optind);
        end;
      writeln;
    end


end.

