{$F+,I-,O-,N-}
{$IFDEF PROD } {$D-,L-,R- } {$ELSE } {$D+,L+,R+ } {$ENDIF }                     {.L-}
                                                                                {.L+}
(*     Free distribution
 *
 *     This unit may be distributed and used freely. No donations are 
 *     solicited. Comments may be E-mailed via BITNET/INTERNET to:
 *                SPRAGGEJ@QUCDN.QUEENSU.CA
 *
 *     This file may be modified and distributed, as long as the
 *     copyright notice is not removed, and the modifications are 
 *     documented.
 *
 *     Disclaimer: this unit is provided as is, without warranty of any 
 *     kind. Use it at your own risk. 
 *
 *)

(*           E X T E N D E D   P R O G R A M   S U P P O R T
 *
 *                            Overlay Buffer Sizing
 *
 *     Written:    90.06.10
 *     Modified:
 *     Status:     Source confidential, trade secret
 *
 *     Open the overlay file, prepare to access overlays, and if no
 *     extended memory is available for overlay swaps, increase the 
 *     size of the overlay buffer as much as possible.
 *
 *     Notes:  Programs which include this unit will not run under 
 *             versions of DOS earlier than 3.0.
 *
 *             A compile time flag is supported in this module:
 *             PROD     indicates this is a production version of the
 *                      program, and a number of run-time tests are no
 *                      longer necessary.
 *
 *     Copyright (c) 1991 by Taliesin Software Resources (Ontario) Limited
 *     All rights reserved
 *)

UNIT GENOVR;

INTERFACE

USES   OVERLAY,                   { TURBO (tm) overlay manager unit    }
       DOS;                       { extended Pascal support            }

IMPLEMENTATION 

FUNCTION OvrName : STRING;        { return the overlay name            }

VAR
   ofd     :   DirStr;                      { overlay file directory   }
   ofb     :   NameStr;                     { overlay base name        }
   ofx     :   ExtStr;                      { program extension (.EXE) }

BEGIN          { Overlay Name }
   IF ParamStr (0) = '' THEN
   BEGIN
       WRITELN ('You must have DOS version 3 or over to run this',
                ' program.');
       RunError (1000);
   END;
   FSplit (ParamStr (0), ofd, ofb, ofx);
   OvrName := ofd + ofb + '.OVR'
END;           { Overlay Name }

PROCEDURE  IncreaseBuffer              { increase overlay buffer size  }
(
       ofn              :    STRING;        { overlay file name        }
       minfree          :    LONGINT        { minimum free allowed     }
);

VAR
   size                 :    LONGINT;       { size of the buffer       }
   ofl                  :    FILE;          { overlay file for length  }

BEGIN          { Increase Buffer }
   ASSIGN (ofl, ofn);
   RESET (ofl, 1);
   size := FileSize (ofl);
   CLOSE (ofl);
   IF size > MaxAvail - minfree THEN
       size := MaxAvail - minfree;
   IF (size > OvrGetBuf) THEN
       OvrSetBuf (size)
END;           { Increase Buffer }

BEGIN          { Initialization section }
   OvrInit (OvrName);
   IF OvrResult <> 0 THEN
       RunError (OvrResult);
   OvrInitEMS;
   IF (OvrResult <> 0) THEN 
       IncreaseBuffer (OvrName, 65536);
END.           { Info Resource Overlay Install }
