{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/SimpSrch.pas             [x] Protected mode

  Primitive text searching for files.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFSTREAM, EFFILE, CRT;

const SearchCache = 16000; { Higher value gives better perfomance }

var SearchStream : pStream; Data : string;


begin
     if IsFile(ParamStr(1)) and (ParamStr(2) <> '') then begin
        WriteLn ('* Searching *');

        { Initialize a file stream that we will search }
        SearchStream := New ( pIFile,
                              Initialize (ParamStr(1), SearchCache) );

        { Perform an un-optimized search; 1) read string of
          the same length as the searched string from the stream,
          2) compare strings and 3) walk backwards to the character
          after beginning of the read string. }

        while not SearchStream^.IsEnd and (Data <> ParamStr(2)) do

              with SearchStream^ do begin

                   { Read a string from the stream }
                   Read (Data[1], Length(ParamStr(2)));
                   Data[0] := Chr(LastTransfer);
                   { Seek backwards }
                   if (Position > Pred(Length(ParamStr(2)))) and
                      (Position < Size) then
                      Seek (Position - Pred(Length(ParamStr(2))));

              end;

        if (Data = ParamStr(2))
           then WriteLn ('Found at ', SearchStream^.Position, '.')
           else WriteLn ('Not found.');

        SearchStream^.Free;

     end else WriteLn ('This program only run with file and search string parameters.');
end.