{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Copy.pas                 [x] Protected mode

  This examples shows how data can be moveda between streams. It
  implements a simple file copying application.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFFILE;


var FirstStream, SecondStream : pFile; Storage : string;

{ ParamStr(1) should contain the source file and ParamStr(2) the target
  file. }

begin
     { tIFile opens a read-only file, and tOFile cretes a write-only
       file. }
     FirstStream  := New ( pIFile, Initialize (ParamStr(1), 1000) );
     SecondStream := New ( pOFile, Initialize (ParamStr(2), 1000) );

     FirstStream^.CopyOut (SecondStream, FirstStream^.Size);

     { The above CopyOut call could be replaced with the following:

       Storage[0] := #255;
       while not FirstStream^.IsEnd do begin
             FirstStream^.Read (Storage[1], 255);
             SecondStream^.Write (Storage[1], FirstStream^.LastTransfer);
       end; }

      FirstStream^.Free; SecondStream^.Free;
end.