{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Sorting1.pas      [x] Protected mode

  Sorting demonstration. This program demonstrates how you
  can control the sorting using special sort plug classes.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFARRAY, EFSORT, EFTEST;

var Collection : tArray;
    Text       : string;
    Index      : word;

begin
     MemPush; { EFTEST }

     with Collection do begin

          { Initialize a ordered list of text strings. }
          Initialize (SizeOf(Text), 10);

          { Add something to the collection }
          Text := 'Kenneth ';   Store (Text);
          Text := 'Jenny   ';   Store (Text);
          Text := 'Jonathan';   Store (Text);
          Text := 'Clark   ';   Store (Text);
          Text := 'Adam    ';   Store (Text);
          Text := 'Eve     ';   Store (Text);
          Text := 'Lucas   ';   Store (Text);

          { Sort with pInsertionSortPlug. Also, try pBubbleSortPlug,
            pMergeSortPlug or pQuickSortPlug. The last one is
            in EFADT and is the default sorting algorithm. }

          InstallPlug (New (pMergeSortPlug, Initialize (NIL)));
          Sort (AscendingOrder);

          { Display the elements in the collection
            in the order their actual order. }

          for Index := 1 to Elements do begin

              Retrieve (Text, Index);
              WriteLn (Text);

          end;

          Intercept;

     end;

     MemPop; { EFTEST }
end.