{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Array1.pas        [x] Protected mode

  Demonstration of the array list ADT. Simple element handling.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFARRAY, EFTEST;


const NumberOfElements = 100;

var MyList : tArray; Timer : tTimer;
    Word1, Word2 : word;


begin
     MemPush; { EFTEST }
     Randomize; Timer.Initialize;

     WriteLn ('* Array with dynamic allocation *');

     { Generate an array list with 100 entries an then display them all }

     with MyList do begin
          { Initialize an array with a fixed number of elements }
          Initialize (NumberOfElements, SizeOf(Word1));
                     { Elements }       { Element size }

          { Sequential writing to array (write numbers 1 ... n in reversed
            order) }
          for Word2 := 1 to NumberOfElements do
              Store (Word2);

          { Reverse element order (swap first and last element and decrement
            interval until all elements have been swapped) }
          for Word2 := 1 to Capacity div 2 do
              Swap (Word2, Succ(Elements - Word2));

          { Display entries (in normal order) }
          for Word2 := Capacity downto 1 do
              Write (Word(Get(Word2)^.Data(0)^):8); { Advanced access }

          WriteLn;
          WriteLn ('Used ', Elements, ' elements of an array with storage capacity of ', Capacity, ' elements.');
          Intercept;
     end;

     with Timer do begin WriteLn (StringMS); Intercept; end;

     MemPop; { EFTEST }
end.