DB> i am interested in writing a utility for telix dialing dir... but i
DB>have teh record format in "C", and while i have a LITTLE exp. in "C",
DB>its not enough to do the util in it.. do you have, or could you tell me
DB>how, to convert the c format to pascal?

It's not that easy.   Most of the strings in the dialing dir are
standard ASCIIZ (null-terminated) C strings.   They have no length byte
(Character 0) like Pascal does.  Thus, you need a library to convert
between PASCAL and ASCIIZ strings, and since the "C" files has headers
which are not the same size as the actual entries, the only way to
handle it in Pascal is to open it as an untyped file and use blockread
and blockwrite, along with SEEK and a formula to calculate the location
of an entry.   Blockread and blockwrite will read and write into this
record structure:

type

  DD_entry_type = Record
          name     : array[1..25] of char;   (* entry name *)
          number   : Array[1..17] of char;   (* phone number *)
          baud,                              (* baud rate *)
          parity,                            (* parity: 0=n 1=e 2=o  *)
          data,                              (* number of data bits  *)
          stop,    : Byte;                   (* number of stop bits  *)
          script   : Array[1..12] of char;   (* linked script file   *)
          lastcall : Array[1..6]  of char;   (* last call ie 102991  *)
          totcalls : Word;                   (* total calls to entry *)
          terminal,                          (* terminal type to use *)
          protocol,                          (* default protocol     *)
          toggles,                           (* bit 0: local echo    *)
                                             (* bit 1: add LFs       *)
                                             (* bit 2: BS trans      *)
                                             (* bit 3: BS key        *)
          filler1,
          filler2,
          dprefnum : Char;                   (* dial prefix number   *)
          password : Array[1..14] of Char;   (* password for entry   *)

  End; { Record DD_EntryType }

(*
   ASCII string fields like the name, number, password, etc. are stored
   in C format, but include the terminating 0 only if there is room. For
   example, if an entry name is 25 characters long it will completely
   fill up the field, and no terminating zero will be added. This was
   done for space reasons, but means that if you manipulate the
   directories you must take care. C programmers for example should
   use the strncpy function instead of the strcpy function to access
   these fields, and must make sure to add a terminating zero.  Pascal
   programmers will need to manipulate the array of char structures
   directly (which is faster than the COPY, DELETE, or CONCAT functions
   anyway), and take care to add the terminating null.

   baud field:     0 =  300, 1 =  1200, 2 =  2400, 3 =  4800,
                   4 = 9600, 5 = 19200, 6 = 38400, 7 = 57600, 8 = 115200

   terminal field: integer number from 0 - n equivalent to that entry
                   in menu shown when Alt-T function invoked
*)

